/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph;

import java.awt.Font;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PBytes;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PResource;
import org.praxislive.ide.core.api.Syncable;
import org.praxislive.ide.pxr.graph.SuggestFieldInplaceEditor;
import org.praxislive.ide.pxr.graph.SuggestFieldInplaceEditorProvider;

class PropertyWidget
extends LabelWidget {
    private static final Object SYNC_KEY = new Object();
    private static final DecimalFormat FORMATTER = new DecimalFormat("####0.0####");
    private final Scene scene;
    private final ControlInfo info;
    private final Node node;
    private final Node.Property<Object> property;
    private final Listener listener;
    private final Syncable sync;
    private final Value.Type<?> valueType;

    public PropertyWidget(Scene scene, ControlInfo info, Node node, Node.Property<?> property) {
        super(scene);
        this.scene = scene;
        this.info = Objects.requireNonNull(info);
        this.node = Objects.requireNonNull(node);
        this.property = Objects.requireNonNull(property);
        this.listener = new Listener();
        Font f = scene.getDefaultFont();
        this.setFont(f.deriveFont(f.getSize2D() * 0.9f));
        this.sync = (Syncable)node.getLookup().lookup(Syncable.class);
        List args = info.outputs();
        this.valueType = args.size() != 1 ? Value.Type.of(Value.class) : Value.Type.fromName((String)((ArgumentInfo)args.get(0)).argumentType()).orElse(Value.Type.of(Value.class));
        this.initEditAction();
    }

    protected void notifyAdded() {
        super.notifyAdded();
        this.node.addPropertyChangeListener((PropertyChangeListener)this.listener);
        this.updateText();
        if (this.sync != null) {
            this.sync.addKey(SYNC_KEY);
        }
    }

    protected void notifyRemoved() {
        super.notifyRemoved();
        this.node.removePropertyChangeListener((PropertyChangeListener)this.listener);
        if (this.sync != null) {
            this.sync.removeKey(SYNC_KEY);
        }
    }

    private void initEditAction() {
        if (this.info.controlType() != ControlInfo.Type.Property) {
            return;
        }
        List args = this.info.outputs();
        if (args.size() != 1) {
            return;
        }
        Class type = this.valueType.asClass();
        if (PBytes.class == type) {
            return;
        }
        List<String> suggested = Collections.emptyList();
        boolean inplace = false;
        if (PNumber.class == type) {
            inplace = true;
        } else {
            Value allowed = ((ArgumentInfo)args.get(0)).properties().get("allowed-values");
            if (allowed != null) {
                suggested = PArray.from((Value)allowed).map(a -> a.stream().map(Value::toString).collect(Collectors.toList())).orElse(Collections.emptyList());
                inplace = true;
            }
        }
        if (inplace) {
            this.getActions().addAction(ActionFactory.createInplaceEditorAction((InplaceEditorProvider)new SuggestFieldInplaceEditorProvider(new InplaceEditor(suggested))));
        } else if (PBoolean.class == type) {
            this.getActions().addAction(ActionFactory.createEditAction((EditProvider)new BooleanEditHandler()));
        } else {
            this.getActions().addAction(ActionFactory.createEditAction((EditProvider)new PropertyEditHandler()));
        }
    }

    private void updateText() {
        try {
            Object value = this.property.getValue();
            if (this.valueType.asClass() == PNumber.class) {
                PNumber num = PNumber.from((Value)((Value)value)).orElse(PNumber.ZERO);
                if (num.isInteger()) {
                    this.setLabel(num.toString());
                } else {
                    this.setLabel(FORMATTER.format(num.value()));
                }
            } else if (this.valueType.asClass() == PBytes.class) {
                this.setLabel("<bytes>");
            } else if (this.valueType.asClass() == PResource.class) {
                String txt = value.toString();
                int lastSlash = txt.lastIndexOf("/");
                if (lastSlash > 0) {
                    txt = txt.substring(lastSlash);
                }
                this.setLabel(txt);
            } else {
                PropertyEditor ed = this.property.getPropertyEditor();
                ed.setValue(this.property.getValue());
                String text = ed.getAsText();
                if (text != null) {
                    this.setLabel(text);
                } else {
                    this.setLabel(ed.getValue().toString());
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            this.setLabel("");
        }
        this.scene.validate();
    }

    protected Rectangle calculateClientArea() {
        Rectangle r = super.calculateClientArea();
        r.width = Math.min(100, r.width);
        return r;
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(PropertyWidget.this.property.getName())) {
                PropertyWidget.this.updateText();
            }
        }
    }

    private class InplaceEditor
    implements SuggestFieldInplaceEditor {
        private final List<String> suggested;

        private InplaceEditor(List<String> suggested) {
            this.suggested = suggested;
        }

        @Override
        public List<String> getSuggestedValues(Widget widget) {
            return this.suggested;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            try {
                PropertyEditor ed = PropertyWidget.this.property.getPropertyEditor();
                ed.setValue(PropertyWidget.this.property.getValue());
                String text = ed.getAsText();
                if (text != null) {
                    return text;
                }
                return "";
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return "";
            }
        }

        public void setText(Widget widget, String string) {
            try {
                PropertyEditor ed = PropertyWidget.this.property.getPropertyEditor();
                ed.setAsText(string);
                PropertyWidget.this.property.setValue(ed.getValue());
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class BooleanEditHandler
    implements EditProvider {
        private BooleanEditHandler() {
        }

        public void edit(Widget widget) {
            try {
                boolean isBoolean;
                boolean bl = isBoolean = PropertyWidget.this.property.getValueType() == Boolean.class;
                if (isBoolean) {
                    boolean value = (Boolean)PropertyWidget.this.property.getValue();
                    value = !value;
                    PropertyWidget.this.property.setValue((Object)value);
                } else {
                    PropertyEditor ed = PropertyWidget.this.property.getPropertyEditor();
                    boolean value = "true".equalsIgnoreCase(ed.getAsText());
                    value = !value;
                    ed.setAsText("" + value);
                    PropertyWidget.this.property.setValue(ed.getValue());
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class PropertyEditHandler
    implements EditProvider {
        private PropertyEditHandler() {
        }

        public void edit(Widget widget) {
            PropertyEditor ed = PropertyWidget.this.property.getPropertyEditor();
            PropertyPanel panel = new PropertyPanel(PropertyWidget.this.property, 2);
            panel.setChangeImmediate(false);
            DialogDescriptor descriptor = new DialogDescriptor((Object)panel, PropertyWidget.this.property.getDisplayName(), true, e -> {
                if (e.getSource() == DialogDescriptor.OK_OPTION) {
                    panel.updateValue();
                }
            });
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)descriptor);
        }
    }
}

