/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph;

import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.FeatureDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openide.nodes.Node;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.model.ContainerProxy;
import org.praxislive.ide.pxr.api.Attributes;
import org.praxislive.ide.pxr.graph.Colors;

class Utils {
    private Utils() {
    }

    static Point findOffset(List<ComponentProxy> cmps) {
        Point pt = new Point();
        Point loc = new Point();
        boolean first = true;
        for (ComponentProxy cmp : cmps) {
            Utils.getPosition(cmp, loc);
            if (first) {
                pt.x = loc.x;
                pt.y = loc.y;
                first = false;
                continue;
            }
            pt.x = Math.min(pt.x, loc.x);
            pt.y = Math.min(pt.y, loc.y);
        }
        return pt;
    }

    static void offsetComponents(List<ComponentProxy> cmps, Point offset, boolean replace) {
        Point loc = new Point();
        for (ComponentProxy cmp : cmps) {
            Utils.getPosition(cmp, loc);
            int x = replace ? loc.x + offset.x : loc.x - offset.x;
            int y = replace ? loc.y + offset.y : loc.y - offset.y;
            Utils.setAttr(cmp, "graph.x", Integer.toString(x));
            Utils.setAttr(cmp, "graph.y", Integer.toString(y));
        }
    }

    static void getPosition(ComponentProxy cmp, Point pt) {
        int y;
        int x;
        String attrX = Utils.getAttr(cmp, "graph.x");
        String attrY = Utils.getAttr(cmp, "graph.y");
        try {
            x = attrX == null ? 0 : Integer.parseInt(attrX);
            y = attrY == null ? 0 : Integer.parseInt(attrY);
        }
        catch (NumberFormatException nfe) {
            y = 0;
            x = 0;
        }
        pt.x = x;
        pt.y = y;
    }

    static void setAttr(ComponentProxy cmp, String key, String value) {
        Attributes attrs = (Attributes)cmp.getLookup().lookup(Attributes.class);
        if (attrs == null) {
            return;
        }
        attrs.setAttribute(key, value);
    }

    static String getAttr(ComponentProxy cmp, String key) {
        Attributes attrs = (Attributes)cmp.getLookup().lookup(Attributes.class);
        if (attrs == null) {
            return null;
        }
        return attrs.getAttribute(key);
    }

    static String getAttr(ComponentProxy cmp, String key, String def) {
        String ret = Utils.getAttr(cmp, key);
        return ret == null ? def : ret;
    }

    static Pattern globToRegex(String glob) {
        StringBuilder regex = new StringBuilder();
        block7: for (char c : glob.toCharArray()) {
            switch (c) {
                case '*': {
                    regex.append(".*");
                    continue block7;
                }
                case '?': {
                    regex.append('.');
                    continue block7;
                }
                case '|': {
                    regex.append('|');
                    continue block7;
                }
                case '_': {
                    regex.append('_');
                    continue block7;
                }
                case '-': {
                    regex.append("\\-");
                    continue block7;
                }
                default: {
                    if (Character.isJavaIdentifierPart(c)) {
                        regex.append(c);
                        continue block7;
                    }
                    throw new IllegalArgumentException();
                }
            }
        }
        return Pattern.compile(regex.toString());
    }

    static void configureFocusActionKeys(final JTextField textField, boolean primary) {
        if (!primary) {
            textField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "notify-field-accept");
            textField.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "notify-field-accept");
        }
        textField.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                textField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    static String nodesToGlob(Node[] nodes) {
        return Stream.of(nodes).map(FeatureDescriptor::getName).collect(Collectors.joining("|"));
    }

    static Colors colorsForPortType(String type) {
        return Utils.colorsForString(type);
    }

    static Colors colorsForComponent(ComponentProxy cmp) {
        if (cmp instanceof ContainerProxy) {
            return Colors.Orange;
        }
        return Utils.colorsForString(cmp.getType().toString());
    }

    private static Colors colorsForString(String string) {
        String test = string.toLowerCase();
        if (test.startsWith("audio")) {
            return Colors.Green;
        }
        if (test.startsWith("video")) {
            return Colors.Purple;
        }
        if (test.startsWith("data")) {
            return Colors.Red;
        }
        return Colors.Blue;
    }

    static Node.Property<?> findMatchingProperty(ComponentProxy cmp, String id) {
        Node node = cmp.getNodeDelegate();
        for (Node.PropertySet ps : node.getPropertySets()) {
            for (Node.Property p : ps.getProperties()) {
                if (!p.getName().equals(id)) continue;
                return p;
            }
        }
        return null;
    }
}

