/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.util.Objects;
import javax.swing.UIManager;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.PointShape;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.ImageUtilities;
import org.praxislive.ide.pxr.graph.scene.EdgeWidget;
import org.praxislive.ide.pxr.graph.scene.NodeWidget;
import org.praxislive.ide.pxr.graph.scene.PinWidget;

public class LAFScheme {
    private static final boolean IS_DARK = UIManager.getBoolean("nb.dark.theme");
    public static final Color FOREGROUND = LAFScheme.findColor("praxis.graph.foreground", IS_DARK ? new Color(15858173) : new Color(0x191919));
    public static final Color BACKGROUND = LAFScheme.findColor("praxis.graph.background", IS_DARK ? new Color(0x191919) : new Color(15858173));
    public static final Color NODE_BACKGROUND = LAFScheme.findColor("praxis.graph.node.background", IS_DARK ? new Color(0x121212) : new Color(0xF7FDFF));
    public static final Colors DEFAULT_COLORS = new Colors(LAFScheme.findColor("praxis.graph.default.selected", new Color(7638208)), LAFScheme.findColor("praxis.graph.default", new Color(12242416)));
    public static final Colors RED = new Colors(LAFScheme.findColor("praxis.graph.red.selected", new Color(0xFF2A2A)), LAFScheme.findColor("praxis.graph.red", new Color(0xFF8080)));
    public static final Colors GREEN = new Colors(LAFScheme.findColor("praxis.graph.green.selected", new Color(11195392)), LAFScheme.findColor("praxis.graph.green", new Color(13031798)));
    public static final Colors BLUE = new Colors(LAFScheme.findColor("praxis.graph.blue.selected", new Color(7638208)), LAFScheme.findColor("praxis.graph.blue", new Color(12242416)));
    public static final Colors PURPLE = new Colors(LAFScheme.findColor("praxis.graph.green.selected", new Color(13904639)), LAFScheme.findColor("praxis.graph.green", new Color(15040767)));
    public static final Colors ORANGE = new Colors(LAFScheme.findColor("praxis.graph.green.selected", new Color(16748838)), LAFScheme.findColor("praxis.graph.green", new Color(16757866)));
    public static final Colors YELLOW = new Colors(LAFScheme.findColor("praxis.graph.green.selected", new Color(0xF9F900)), LAFScheme.findColor("praxis.graph.green", new Color(0xFFFF7A)));
    private static final Border BORDER_MINIMIZE = BorderFactory.createOpaqueBorder((int)2, (int)2, (int)2, (int)2);

    protected void installUI(NodeWidget widget) {
        widget.setOpaque(false);
        widget.getHeader().setOpaque(false);
        widget.getMinimizeButton().setBorder(BORDER_MINIMIZE);
        this.updateUI(widget);
    }

    protected void updateUI(NodeWidget widget) {
        ObjectState state = widget.getState();
        Colors colors = widget.getSchemeColors();
        if (colors == null) {
            colors = DEFAULT_COLORS;
        }
        if (widget.isBelowLODThreshold()) {
            if (state.isSelected()) {
                if (state.isFocused()) {
                    widget.setBorder(colors.BORDER_SMALL_NODE_SELECTED_FOCUSED);
                } else {
                    widget.setBorder(colors.BORDER_SMALL_NODE_SELECTED);
                }
            } else if (state.isFocused()) {
                widget.setBorder(colors.BORDER_SMALL_NODE_FOCUSED);
            } else {
                widget.setBorder(colors.BORDER_SMALL_NODE);
            }
        } else if (state.isSelected()) {
            if (state.isFocused()) {
                widget.setBorder(colors.BORDER_NODE_SELECTED_FOCUSED);
            } else {
                widget.setBorder(colors.BORDER_NODE_SELECTED);
            }
        } else if (state.isFocused()) {
            widget.setBorder(colors.BORDER_NODE_FOCUSED);
        } else {
            widget.setBorder(colors.BORDER_NODE);
        }
        Widget header = widget.getHeader();
        header.setBorder(state.isSelected() || state.isHovered() ? colors.BORDER_HEADER_SELECTED : colors.BORDER_HEADER);
        Widget comment = widget.getCommentWidget();
        if (comment != null) {
            comment.setBorder(colors.BORDER_HEADER);
        }
    }

    protected boolean isNodeMinimizeButtonOnRight(NodeWidget widget) {
        return false;
    }

    protected Image getMinimizeWidgetImage(NodeWidget widget) {
        return widget.isMinimized() ? ImageUtilities.loadImage((String)"org/praxislive/ide/pxr/graph/scene/resources/vmd-expand.png") : ImageUtilities.loadImage((String)"org/praxislive/ide/pxr/graph/scene/resources/vmd-collapse.png");
    }

    protected void installUI(EdgeWidget widget) {
        widget.setSourceAnchorShape(AnchorShape.NONE);
        widget.setTargetAnchorShape(AnchorShape.NONE);
        widget.setPaintControlPoints(true);
        widget.setForeground(FOREGROUND);
        this.updateUI(widget);
    }

    protected void updateUI(EdgeWidget widget) {
        ObjectState state = widget.getState();
        Colors colors = widget.getSchemeColors();
        if (colors == null) {
            colors = DEFAULT_COLORS;
        }
        if (state.isHovered() || state.isSelected()) {
            widget.setEndPointShape(PointShape.SQUARE_FILLED_BIG);
        } else {
            widget.setControlPointShape(PointShape.NONE);
            widget.setEndPointShape(PointShape.SQUARE_FILLED_SMALL);
        }
        if (state.isHovered() || state.isSelected()) {
            widget.bringToFront();
            widget.setForeground(colors.COLOR_SELECTED);
            widget.setStroke(new BasicStroke(4.0f));
        } else {
            widget.setForeground(colors.COLOR_SELECTED);
            widget.setStroke(new BasicStroke(2.0f));
        }
        widget.setControlPointCutDistance(5);
    }

    protected void installUI(PinWidget widget) {
        widget.setOpaque(false);
        this.updateUI(widget);
    }

    protected void updateUI(PinWidget widget) {
        ObjectState state = widget.getState();
        Colors colors = widget.getSchemeColors();
        if (colors == null) {
            colors = DEFAULT_COLORS;
        }
        widget.getPinNameWidget().setForeground(IS_DARK ? colors.COLOR_NORMAL : colors.COLOR_SELECTED);
        if (state.isHovered()) {
            widget.setBorder(colors.BORDER_PIN_SELECTED);
        } else {
            widget.setBorder(colors.BORDER_PIN);
        }
    }

    protected int getAnchorGap() {
        return 8;
    }

    protected Color getBackgroundColor() {
        return BACKGROUND;
    }

    private static Color findColor(String uiKey, Color fallback) {
        Color color = UIManager.getColor(uiKey);
        return color == null ? fallback : color;
    }

    public static class Colors {
        private final Color COLOR_SELECTED;
        private final Color COLOR_NORMAL;
        private final Border BORDER_NODE;
        private final Border BORDER_NODE_FOCUSED;
        private final Border BORDER_NODE_SELECTED;
        private final Border BORDER_NODE_SELECTED_FOCUSED;
        private final Border BORDER_HEADER;
        private final Border BORDER_HEADER_SELECTED;
        private final Border BORDER_SMALL_NODE;
        private final Border BORDER_SMALL_NODE_FOCUSED;
        private final Border BORDER_SMALL_NODE_SELECTED;
        private final Border BORDER_SMALL_NODE_SELECTED_FOCUSED;
        private final Border BORDER_PIN;
        private final Border BORDER_PIN_SELECTED;

        public Colors(Color highlight, Color normal) {
            this.COLOR_SELECTED = Objects.requireNonNull(highlight);
            this.COLOR_NORMAL = Objects.requireNonNull(normal);
            this.BORDER_NODE = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createEmptyBorder((int)2), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)NODE_BACKGROUND, (Color)this.COLOR_NORMAL)});
            this.BORDER_NODE_FOCUSED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createResizeBorder((int)2, (Color)FOREGROUND, (boolean)true), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)NODE_BACKGROUND, (Color)this.COLOR_NORMAL)});
            this.BORDER_NODE_SELECTED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createEmptyBorder((int)2), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)NODE_BACKGROUND, (Color)this.COLOR_SELECTED)});
            this.BORDER_NODE_SELECTED_FOCUSED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createResizeBorder((int)2, (Color)FOREGROUND, (boolean)true), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)NODE_BACKGROUND, (Color)this.COLOR_SELECTED)});
            this.BORDER_HEADER = BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)4, (Color)this.COLOR_NORMAL, (Color)this.COLOR_NORMAL);
            this.BORDER_HEADER_SELECTED = BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)4, (Color)this.COLOR_SELECTED, (Color)this.COLOR_SELECTED);
            this.BORDER_SMALL_NODE = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createEmptyBorder((int)3), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)this.COLOR_NORMAL, null)});
            this.BORDER_SMALL_NODE_FOCUSED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createResizeBorder((int)3, (Color)FOREGROUND, (boolean)true), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)this.COLOR_NORMAL, null)});
            this.BORDER_SMALL_NODE_SELECTED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createEmptyBorder((int)3), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)this.COLOR_SELECTED, null)});
            this.BORDER_SMALL_NODE_SELECTED_FOCUSED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createResizeBorder((int)3, (Color)FOREGROUND, (boolean)true), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)this.COLOR_SELECTED, null)});
            this.BORDER_PIN = BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)4, null, null);
            this.BORDER_PIN_SELECTED = BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)4, null, (Color)this.COLOR_NORMAL);
        }
    }
}

