/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.praxislive.ide.pxr.graph.scene.CommentWidget;
import org.praxislive.ide.pxr.graph.scene.GlyphSetWidget;
import org.praxislive.ide.pxr.graph.scene.LAFScheme;
import org.praxislive.ide.pxr.graph.scene.MinimizeAbility;
import org.praxislive.ide.pxr.graph.scene.PraxisGraphScene;

public class NodeWidget
extends Widget
implements StateModel.Listener,
MinimizeAbility {
    private final Widget header;
    private final ImageWidget minimizeWidget;
    private final ImageWidget imageWidget;
    private final LabelWidget nameWidget;
    private final GlyphSetWidget glyphSetWidget;
    private final StateModel stateModel;
    private final LAFScheme scheme;
    private final PraxisGraphScene scene;
    private final SceneListenerImpl sceneListener;
    private final CommentWidget commentWidget;
    private LAFScheme.Colors schemeColors;

    public NodeWidget(PraxisGraphScene<?> scene) {
        super(scene);
        this.scene = scene;
        this.sceneListener = new SceneListenerImpl();
        this.scheme = scene.getLookAndFeel();
        this.stateModel = new StateModel();
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.setMinimumSize(new Dimension(100, 10));
        this.header = new Widget(scene);
        this.header.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)8));
        this.addChild(this.header);
        this.minimizeWidget = new ImageWidget(scene, this.scheme.getMinimizeWidgetImage(this));
        this.minimizeWidget.setCursor(Cursor.getPredefinedCursor(12));
        this.minimizeWidget.getActions().addAction((WidgetAction)new ToggleMinimizedAction());
        this.header.addChild((Widget)this.minimizeWidget);
        this.imageWidget = new ImageWidget(scene);
        this.header.addChild((Widget)this.imageWidget);
        this.nameWidget = new LabelWidget(scene);
        this.nameWidget.setFont(scene.getFont().deriveFont(1));
        this.nameWidget.setForeground(Color.BLACK);
        this.header.addChild((Widget)this.nameWidget);
        this.glyphSetWidget = new GlyphSetWidget((Scene)scene);
        this.glyphSetWidget.setMinimumSize(new Dimension(16, 16));
        this.header.addChild((Widget)this.glyphSetWidget);
        Widget topLayer = new Widget(scene);
        this.addChild(topLayer);
        this.stateModel.addListener((StateModel.Listener)this);
        this.commentWidget = new CommentWidget(scene);
        this.scheme.installUI(this);
    }

    protected void notifyAdded() {
        this.scene.addSceneListener(this.sceneListener);
    }

    protected void notifyRemoved() {
        this.scene.removeSceneListener(this.sceneListener);
    }

    protected boolean isMinimizableWidget(Widget widget) {
        return true;
    }

    public boolean isMinimized() {
        return this.stateModel.getBooleanState();
    }

    public void setMinimized(boolean minimized) {
        this.stateModel.setBooleanState(minimized);
    }

    public void toggleMinimized() {
        this.stateModel.toggleBooleanState();
    }

    public void stateChanged() {
        boolean minimized = this.stateModel.getBooleanState();
        Rectangle rectangle = minimized ? new Rectangle() : null;
        for (Widget widget : this.getChildren()) {
            if (widget == this.header) continue;
            this.getScene().getSceneAnimator().animatePreferredBounds(widget, minimized && this.isMinimizableWidget(widget) ? rectangle : null);
        }
        this.minimizeWidget.setImage(this.scheme.getMinimizeWidgetImage(this));
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        if (!previousState.isSelected() && state.isSelected() || !previousState.isHovered() && state.isHovered()) {
            this.bringToFront();
            this.commentWidget.bringToFront();
        }
        this.scheme.updateUI(this);
    }

    public void setNodeImage(Image image) {
        this.imageWidget.setImage(image);
        this.revalidate();
    }

    public String getNodeName() {
        return this.nameWidget.getLabel();
    }

    public void setNodeName(String nodeName) {
        this.nameWidget.setLabel(nodeName);
    }

    public void attachPinWidget(Widget widget) {
        widget.setCheckClipping(true);
        this.addChild(widget);
        if (this.stateModel.getBooleanState() && this.isMinimizableWidget(widget)) {
            widget.setPreferredBounds(new Rectangle());
        }
    }

    public void setGlyphs(List<Image> glyphs) {
        this.glyphSetWidget.setGlyphs(glyphs);
    }

    public LabelWidget getNodeNameWidget() {
        return this.nameWidget;
    }

    @Override
    public void collapseWidget() {
        this.stateModel.setBooleanState(true);
    }

    @Override
    public void expandWidget() {
        this.stateModel.setBooleanState(false);
    }

    public Widget getHeader() {
        return this.header;
    }

    public Widget getMinimizeButton() {
        return this.minimizeWidget;
    }

    public void setComment(String comment) {
        if (comment == null || comment.trim().isEmpty()) {
            this.commentWidget.setText("");
            this.commentWidget.setVisible(false);
            this.commentWidget.removeFromParent();
        } else {
            if (this.commentWidget.getParentWidget() == null) {
                this.getParentWidget().addChild((Widget)this.commentWidget);
            }
            this.commentWidget.setText(comment);
            this.commentWidget.setVisible(true);
        }
        this.scheme.updateUI(this);
    }

    public String getComment() {
        return this.commentWidget.getText();
    }

    private void positionComment() {
        if (!this.commentWidget.isVisible()) {
            return;
        }
        Point loc = this.getLocation();
        Rectangle bounds = this.getBounds();
        Rectangle commentBounds = this.commentWidget.getBounds();
        if (loc == null || bounds == null || commentBounds == null) {
            return;
        }
        int offset = this.commentWidget.getBorder().getInsets().left;
        this.commentWidget.setPreferredLocation(new Point(loc.x + offset, loc.y - commentBounds.height - 4));
        this.commentWidget.setMinimumSize(new Dimension(bounds.width, 15));
    }

    protected void paintChildren() {
        if (this.isBelowLODThreshold()) {
            return;
        }
        super.paintChildren();
    }

    public boolean isBelowLODThreshold() {
        return this.scene.isBelowLODThreshold();
    }

    public Widget getCommentWidget() {
        return this.commentWidget;
    }

    public void setSchemeColors(LAFScheme.Colors colors) {
        this.schemeColors = colors;
        this.revalidate();
    }

    public LAFScheme.Colors getSchemeColors() {
        return this.schemeColors == null ? this.scene.getSchemeColors() : this.schemeColors;
    }

    private class SceneListenerImpl
    implements Scene.SceneListener {
        private SceneListenerImpl() {
        }

        public void sceneRepaint() {
        }

        public void sceneValidating() {
            NodeWidget.this.scheme.updateUI(NodeWidget.this);
        }

        public void sceneValidated() {
            NodeWidget.this.positionComment();
        }
    }

    private class ToggleMinimizedAction
    extends WidgetAction.Adapter {
        private ToggleMinimizedAction() {
        }

        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
            if (event.getButton() == 1 || event.getButton() == 2) {
                NodeWidget.this.stateModel.toggleBooleanState();
            }
            return WidgetAction.State.REJECTED;
        }
    }
}

