/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.io.OutputStreamWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import org.netbeans.api.actions.Openable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.praxislive.ide.pxr.graph.Bundle;
import org.praxislive.ide.pxr.graph.GraphEditor;

class SharedCodeComponent
extends JPanel
implements ExplorerManager.Provider {
    private final ExplorerManager em;
    private final FileView fileView;

    SharedCodeComponent(GraphEditor editor, FileObject parent) {
        this.setOpaque(false);
        this.em = new ExplorerManager();
        FolderNode rootNode = new FolderNode(DataFolder.findFolder((FileObject)parent).getNodeDelegate(), true);
        this.em.setRootContext((Node)rootNode);
        this.fileView = new FileView();
        this.fileView.setPreferredSize(new Dimension(200, 400));
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.fileView));
        Paint p = editor.getScene().getBackground();
        if (p instanceof Color) {
            this.setBackground((Color)p);
            this.fileView.updateBG((Color)p);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }

    private static class FolderNode
    extends FilterNode {
        private final boolean root;
        private final NewFileAction newFileAction;

        public FolderNode(Node original, boolean root) {
            super(original, (Children)new FolderChildren(original));
            this.root = root;
            this.newFileAction = new NewFileAction((Node)this);
        }

        public Action getPreferredAction() {
            return null;
        }

        public Action[] getActions(boolean context) {
            return new Action[]{this.newFileAction};
        }

        public boolean canRename() {
            return !this.root;
        }
    }

    private static class FileView
    extends BeanTreeView {
        private FileView() {
        }

        private void updateBG(Color bg) {
            super.setBackground(bg);
            this.tree.setBackground(bg);
        }
    }

    private static class NewFileAction
    extends AbstractAction {
        private final Node node;

        private NewFileAction(Node node) {
            super(Bundle.ACT_NewSharedType());
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block8: {
                try {
                    NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(Bundle.DLG_EnterTypeName(), Bundle.TTL_NewType());
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) != NotifyDescriptor.OK_OPTION) break block8;
                    String typeName = input.getInputText().trim();
                    if (typeName.isBlank() || typeName.contains("/")) {
                        return;
                    }
                    String source = "package SHARED;\n\npublic class " + typeName + " {\n\n}";
                    String fileName = typeName + ".java";
                    FileObject folder = (FileObject)this.node.getLookup().lookup(FileObject.class);
                    FileObject file = FileUtil.createData((FileObject)folder, (String)fileName);
                    try (OutputStreamWriter writer = new OutputStreamWriter(file.getOutputStream());){
                        writer.append(source);
                    }
                    DataObject dob = DataObject.find((FileObject)file);
                    EditorCookie editor = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
                    editor.open();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static class DeleteAction
    extends AbstractAction {
        private final Node node;

        private DeleteAction(Node node) {
            super(Bundle.ACT_Delete());
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = this.node.getDisplayName();
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.DLG_DeleteType(name), 2)) == NotifyDescriptor.OK_OPTION) {
                try {
                    FileObject fob = (FileObject)this.node.getLookup().lookup(FileObject.class);
                    if (fob != null) {
                        fob.delete();
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static class OpenAction
    extends AbstractAction {
        private final Node node;

        private OpenAction(Node node) {
            super(Bundle.ACT_Open());
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Openable openable = (Openable)this.node.getLookup().lookup(Openable.class);
            if (openable != null) {
                openable.open();
            }
        }
    }

    private static class FileNode
    extends FilterNode {
        private final OpenAction openAction = new OpenAction((Node)this);
        private final DeleteAction deleteAction = new DeleteAction((Node)this);

        public FileNode(Node original) {
            super(original);
        }

        public Action getPreferredAction() {
            return this.openAction;
        }

        public Action[] getActions(boolean context) {
            return new Action[]{this.openAction, this.deleteAction};
        }

        public String getDisplayName() {
            String ret = super.getDisplayName();
            if (ret.endsWith(".java")) {
                return ret.substring(0, ret.lastIndexOf(46));
            }
            return ret;
        }
    }

    private static class FolderChildren
    extends FilterNode.Children {
        public FolderChildren(Node parent) {
            super(parent);
        }

        protected Node[] createNodes(Node original) {
            if (original.isLeaf()) {
                FileObject file = (FileObject)original.getLookup().lookup(FileObject.class);
                if (file != null && file.hasExt("java")) {
                    return new Node[]{new FileNode(original)};
                }
                return new Node[0];
            }
            return new Node[]{new FolderNode(original, false)};
        }
    }
}

