/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import javax.imageio.ImageIO;
import javax.swing.Timer;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Exceptions;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.Watch;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PBytes;
import org.praxislive.core.types.PMap;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.model.ContainerProxy;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.graph.scene.LAFScheme;
import org.praxislive.ide.pxr.graph.scene.PraxisGraphScene;

abstract class WatchDisplay
extends Widget {
    private static final long FORCE_REFRESH_TIME = 5000000000L;
    private final ComponentProxy cmp;
    private final String control;
    private final Timer timer;
    private CompletionStage<?> pending;
    private long pendingSent;

    WatchDisplay(Scene scene, ComponentProxy cmp, String control, String relatedPort) {
        super(scene);
        this.cmp = Objects.requireNonNull(cmp);
        this.control = Objects.requireNonNull(control);
        this.timer = new Timer(100, this::timerListener);
        this.setOpaque(true);
        this.setForeground(null);
        this.setBorder(BorderFactory.createRoundedBorder((int)4, (int)4, (int)2, (int)2, (Color)LAFScheme.NODE_BACKGROUND, null));
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.addChild(this.createLabel(scene, (String)(relatedPort.isBlank() ? control : relatedPort + " (watch)")));
    }

    private Widget createLabel(Scene scene, String text) {
        LabelWidget label = new LabelWidget(scene, text);
        label.setForeground(null);
        label.setBorder((Border)new LabelBorderImpl());
        return label;
    }

    protected void notifyAdded() {
        super.notifyAdded();
        this.pendingSent = System.nanoTime() - 5000000000L;
        this.timer.start();
    }

    protected void notifyRemoved() {
        super.notifyRemoved();
        this.timer.stop();
    }

    private void timerListener(ActionEvent e) {
        PraxisGraphScene pgs;
        Scene scene = this.getScene();
        if (scene instanceof PraxisGraphScene && (pgs = (PraxisGraphScene)scene).isBelowLODThreshold()) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (this.pending != null && System.nanoTime() - this.pendingSent < 5000000000L) {
            return;
        }
        CompletionStage staged = this.cmp.send(this.control, List.of());
        staged.whenComplete((args, ex) -> {
            assert (EventQueue.isDispatchThread());
            if (args != null && !args.isEmpty()) {
                this.update((Value)args.get(0));
            }
            if (this.pending == staged) {
                this.pending = null;
            }
        });
        this.pending = staged;
        this.pendingSent = System.nanoTime();
    }

    private boolean isRunning() {
        for (ContainerProxy parent = this.cmp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof RootProxy)) continue;
            RootProxy root = (RootProxy)parent;
            PraxisProperty running = root.getProperty("is-running");
            if (running != null) {
                return PBoolean.from((Value)running.getValue()).orElse(PBoolean.FALSE).value();
            }
            return true;
        }
        return false;
    }

    abstract void update(Value var1);

    static WatchDisplay createWidget(PraxisGraphScene<?> scene, ComponentProxy cmp, String control) {
        ControlInfo info = cmp.getInfo().controlInfo(control);
        if (info == null || !Watch.isWatch((ControlInfo)info)) {
            return null;
        }
        PMap watchInfo = PMap.from((Value)info.properties().get("watch")).orElse(PMap.EMPTY);
        String mime = watchInfo.getString("mime", "application/octet-stream");
        String port = watchInfo.getString("related-port", "");
        if ("image/png".equals(mime)) {
            return new ImageDisplay((Scene)scene, cmp, control, port);
        }
        return new TextDisplay((Scene)scene, cmp, control, port);
    }

    private class LabelBorderImpl
    implements Border {
        private final Insets INSETS = new Insets(1, 1, 1, 1);

        private LabelBorderImpl() {
        }

        public Insets getInsets() {
            return this.INSETS;
        }

        public void paint(Graphics2D g, Rectangle bounds) {
            g.setColor(WatchDisplay.this.getParentWidget().getForeground());
            int y = bounds.y + bounds.height - 1;
            g.drawLine(bounds.x, y, bounds.x + bounds.width, y);
        }

        public boolean isOpaque() {
            return false;
        }
    }

    private static class ImageDisplay
    extends WatchDisplay {
        private final ScaledImageWidget imageWidget;
        private PBytes data;
        private BufferedImage image;

        ImageDisplay(Scene scene, ComponentProxy cmp, String control, String relatedPort) {
            super(scene, cmp, control, relatedPort);
            this.imageWidget = new ScaledImageWidget(scene);
            this.addChild(this.imageWidget);
        }

        @Override
        void update(Value value) {
            PBytes newData = PBytes.from((Value)value).orElse(PBytes.EMPTY);
            if (!Objects.equals(this.data, newData)) {
                this.data = newData;
                if (this.data.isEmpty()) {
                    this.image = null;
                    this.imageWidget.setImage(null);
                } else {
                    try {
                        this.image = ImageIO.read(this.data.asInputStream());
                        this.imageWidget.setImage(this.image);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        this.image = null;
                        this.imageWidget.setImage(null);
                    }
                }
            }
            this.getScene().validate();
        }
    }

    private static class TextDisplay
    extends WatchDisplay {
        private final List<LabelWidget> lines = List.of(this.createLineWidget(), this.createLineWidget(), this.createLineWidget(), this.createLineWidget(), this.createLineWidget());
        private String text = "";

        TextDisplay(Scene scene, ComponentProxy cmp, String control, String relatedPort) {
            super(scene, cmp, control, relatedPort);
            for (LabelWidget line : this.lines) {
                line.setVisible(false);
                this.addChild((Widget)line);
            }
        }

        @Override
        void update(Value value) {
            String newText = value.toString();
            if (!Objects.equals(this.text, newText)) {
                this.text = newText;
                List<String> ll = this.text.lines().limit(this.lines.size()).map(this::truncate).toList();
                for (LabelWidget line : this.lines) {
                    line.setVisible(false);
                }
                for (int i = 0; i < ll.size(); ++i) {
                    String txt = ll.get(i);
                    LabelWidget widget = this.lines.get(i);
                    widget.setLabel(txt);
                    widget.setVisible(true);
                }
                this.getScene().validate();
            }
        }

        private LabelWidget createLineWidget() {
            LabelWidget lineWidget = new LabelWidget(this.getScene());
            lineWidget.setForeground(null);
            return lineWidget;
        }

        private String truncate(String line) {
            return line.length() > 40 ? line.substring(0, 38) + "..." : line;
        }
    }

    private static class ScaledImageWidget
    extends Widget {
        private static final int DEFAULT_SIZE = 140;
        private BufferedImage image;

        ScaledImageWidget(Scene scene) {
            super(scene);
        }

        void setImage(BufferedImage image) {
            this.image = image;
            this.revalidate();
        }

        protected Rectangle calculateClientArea() {
            if (this.image == null) {
                return super.calculateClientArea();
            }
            double width = this.image.getWidth();
            double height = this.image.getHeight();
            double maxDim = Math.max(width, height);
            double scale = 140.0 / maxDim;
            return new Rectangle((int)(scale * width + 0.5), (int)(scale * height + 0.5));
        }

        protected void paintWidget() {
            if (this.image == null) {
                return;
            }
            Graphics2D g = this.getGraphics();
            Rectangle area = this.getClientArea();
            RenderingHints renderingHints = g.getRenderingHints();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(this.image, area.x, area.y, area.width, area.height, null);
            g.setRenderingHints(renderingHints);
        }
    }
}

