/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Objects;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Widget;
import org.praxislive.ide.pxr.graph.scene.LAFScheme;
import org.praxislive.ide.pxr.graph.scene.PraxisGraphScene;

final class CommentWidget
extends Widget {
    private final PraxisGraphScene<?> scene;
    private String text;
    private EditProvider editProvider;

    CommentWidget(PraxisGraphScene<?> scene) {
        super(scene);
        this.scene = scene;
        this.setOpaque(true);
        this.setBackground(scene.getBackground());
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.setMinimumSize(new Dimension(100, 10));
        this.setBorder(BorderFactory.createRoundedBorder((int)4, (int)4, (int)2, (int)2, (Color)LAFScheme.BACKGROUND, null));
        this.text = "";
        this.getActions().addAction(ActionFactory.createEditAction(widget -> {
            if (this.editProvider != null) {
                this.editProvider.edit(widget);
            }
        }));
    }

    final void setText(String text) {
        if (this.text.equals(text)) {
            return;
        }
        this.text = Objects.requireNonNull(text);
        String[] lines = text.split("\n");
        this.removeChildren();
        for (String line : lines) {
            LabelWidget lw = new LabelWidget(this.getScene(), line);
            lw.setForeground(null);
            this.addChild((Widget)lw);
        }
    }

    final String getText() {
        return this.text;
    }

    final void setEditProvider(EditProvider editProvider) {
        this.editProvider = editProvider;
    }

    protected void paintChildren() {
        if (this.scene.isBelowLODThreshold()) {
            return;
        }
        super.paintChildren();
    }

    public boolean isHitAt(Point localLocation) {
        if (this.scene.isBelowLODThreshold()) {
            return false;
        }
        return super.isHitAt(localLocation);
    }
}

