/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.ConnectDecorator;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.CycleFocusProvider;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.router.ConnectionWidgetCollisionsCollector;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.praxislive.ide.pxr.graph.scene.Alignment;
import org.praxislive.ide.pxr.graph.scene.CommentWidget;
import org.praxislive.ide.pxr.graph.scene.EdgeID;
import org.praxislive.ide.pxr.graph.scene.EdgeWidget;
import org.praxislive.ide.pxr.graph.scene.LAFScheme;
import org.praxislive.ide.pxr.graph.scene.NodeWidget;
import org.praxislive.ide.pxr.graph.scene.PinID;
import org.praxislive.ide.pxr.graph.scene.PinWidget;
import org.praxislive.ide.pxr.graph.scene.PraxisConnectDecorator;
import org.praxislive.ide.pxr.graph.scene.PraxisCycleFocusProvider;
import org.praxislive.ide.pxr.graph.scene.PraxisGraphLayout;
import org.praxislive.ide.pxr.graph.scene.PraxisKeyboardMoveAction;
import org.praxislive.ide.pxr.graph.scene.PraxisMoveProvider;

public final class PraxisGraphScene<N>
extends GraphPinScene<N, EdgeID<N>, PinID<N>> {
    private static final double LOD_ZOOM = 0.75;
    private final LayerWidget backgroundLayer = new LayerWidget((Scene)this);
    private final LayerWidget mainLayer = new LayerWidget((Scene)this);
    private final LayerWidget connectionLayer = new LayerWidget((Scene)this);
    private final LayerWidget upperLayer = new LayerWidget((Scene)this);
    private final CommentWidget commentWidget;
    private boolean animate;
    private boolean orthogonal;
    private boolean minimizeConnectedPins;
    private Router router;
    private final WidgetAction moveAction;
    private final PraxisKeyboardMoveAction keyboardMoveAction;
    private final SceneLayout sceneLayout;
    private LAFScheme scheme = new LAFScheme();
    private WidgetAction menuAction;
    private WidgetAction connectAction;
    private LAFScheme.Colors schemeColors;

    public PraxisGraphScene() {
        this(null, null);
    }

    public PraxisGraphScene(ConnectProvider connectProvider, PopupMenuProvider popupProvider) {
        this.setFont(this.scheme.getDefaultFont());
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.addChild((Widget)this.backgroundLayer);
        this.addChild((Widget)this.mainLayer);
        this.addChild((Widget)this.connectionLayer);
        this.addChild((Widget)this.upperLayer);
        PraxisMoveProvider mover = new PraxisMoveProvider(this, this.backgroundLayer);
        this.moveAction = ActionFactory.createMoveAction((MoveStrategy)mover, (MoveProvider)mover);
        this.keyboardMoveAction = new PraxisKeyboardMoveAction(mover, mover);
        this.commentWidget = new CommentWidget(this);
        this.commentWidget.setPreferredLocation(new Point(32, 32));
        this.commentWidget.setFont(this.scheme.getCommentFont());
        this.commentWidget.setBorder(BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)8, (Color)LAFScheme.NODE_BACKGROUND, null));
        this.commentWidget.setVisible(false);
        this.mainLayer.addChild((Widget)this.commentWidget);
        this.setBackground(this.scheme.getBackgroundColor());
        this.router = RouterFactory.createDirectRouter();
        this.getActions().addAction(ActionFactory.createWheelPanAction());
        this.getActions().addAction(ActionFactory.createMouseCenteredZoomAction((double)1.2));
        this.getActions().addAction(ActionFactory.createPanAction());
        this.getActions().addAction(ActionFactory.createCycleFocusAction((CycleFocusProvider)new PraxisCycleFocusProvider()));
        if (connectProvider != null) {
            this.connectAction = ActionFactory.createConnectAction((ConnectDecorator)new PraxisConnectDecorator(), (LayerWidget)this.connectionLayer, (ConnectProvider)connectProvider);
        }
        if (popupProvider != null) {
            this.menuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)popupProvider);
            this.getActions().addAction(this.menuAction);
        }
        this.getActions().addAction(ActionFactory.createRectangularSelectAction((ObjectScene)this, (LayerWidget)this.backgroundLayer));
        this.addSceneListener(new ZoomCorrector());
        this.sceneLayout = LayoutFactory.createSceneGraphLayout((GraphPinScene)this, new PraxisGraphLayout(true));
    }

    public NodeWidget addNode(N node, String name) {
        NodeWidget nodeWidget = (NodeWidget)super.addNode(node);
        nodeWidget.setNodeName(name);
        return nodeWidget;
    }

    public PinWidget addPin(N node, String name) {
        return this.addPin(new PinID<N>(node, name), Alignment.Center);
    }

    public PinWidget addPin(N node, String name, Alignment alignment) {
        return this.addPin(new PinID<N>(node, name), alignment);
    }

    public PinWidget addPin(PinID<N> pin, Alignment alignment) {
        if (pin == null || alignment == null) {
            throw new NullPointerException();
        }
        PinWidget p = (PinWidget)super.addPin(pin.getParent(), pin);
        p.setAlignment(alignment);
        return p;
    }

    public EdgeWidget connect(N node1, String pin1, N node2, String pin2) {
        return this.connect(new PinID<N>(node1, pin1), new PinID<N>(node2, pin2));
    }

    public EdgeWidget connect(PinID<N> p1, PinID<N> p2) {
        EdgeID<N> d = new EdgeID<N>(p1, p2);
        EdgeWidget e = (EdgeWidget)this.addEdge(d);
        this.setEdgeSource(d, p1);
        this.setEdgeTarget(d, p2);
        return e;
    }

    public void disconnect(N node1, String pin1, N node2, String pin2) {
        PinID<N> p1 = new PinID<N>(node1, pin1);
        PinID<N> p2 = new PinID<N>(node2, pin2);
        EdgeID<N> d = new EdgeID<N>(p1, p2);
        this.removeEdge(d);
    }

    public LAFScheme getLookAndFeel() {
        return this.scheme;
    }

    public void setSchemeColors(LAFScheme.Colors schemeColors) {
        this.schemeColors = schemeColors;
        this.revalidate();
    }

    public LAFScheme.Colors getSchemeColors() {
        return this.schemeColors;
    }

    public void setOrthogonalRouting(boolean orthogonal) {
        if (this.orthogonal != orthogonal) {
            this.orthogonal = orthogonal;
            this.setRouter(orthogonal ? RouterFactory.createOrthogonalSearchRouter((LayerWidget[])new LayerWidget[]{this.mainLayer, this.upperLayer}) : RouterFactory.createDirectRouter());
        }
    }

    public boolean isOrthogonalRouting() {
        return this.orthogonal;
    }

    private void setRouter(Router router) {
        this.router = router;
        for (EdgeID e : this.getEdges()) {
            ((ConnectionWidget)this.findWidget(e)).setRouter(router);
        }
        this.revalidate();
    }

    public void setMinimizeConnectedPins(boolean minimizeConnected) {
        this.minimizeConnectedPins = minimizeConnected;
    }

    public boolean isMinimizeConnectedPins() {
        return this.minimizeConnectedPins;
    }

    public void userSelectionSuggested(Set<?> suggestedSelectedObjects, boolean invertSelection) {
        if (suggestedSelectedObjects.size() == 1 && this.isPin(suggestedSelectedObjects.iterator().next())) {
            suggestedSelectedObjects = Collections.emptySet();
        } else if (!suggestedSelectedObjects.isEmpty()) {
            LinkedHashSet<Object> selection = new LinkedHashSet<Object>(suggestedSelectedObjects.size());
            for (Object obj : suggestedSelectedObjects) {
                if (this.isPin(obj)) continue;
                selection.add(obj);
            }
            suggestedSelectedObjects = selection;
        }
        super.userSelectionSuggested(suggestedSelectedObjects, invertSelection);
    }

    protected Widget attachNodeWidget(N node) {
        NodeWidget widget = new NodeWidget(this);
        this.mainLayer.addChild((Widget)widget);
        this.mainLayer.addChild((Widget)widget.getCommentWidget());
        this.mainLayer.addChild((Widget)widget.getToolContainerWidget());
        widget.getHeader().getActions().addAction(this.createObjectHoverAction());
        widget.getActions().addAction(this.createSelectAction());
        widget.getActions().addAction(this.moveAction);
        widget.getActions().addAction((WidgetAction)this.keyboardMoveAction);
        if (this.menuAction != null) {
            widget.getActions().addAction(this.menuAction);
        }
        return widget;
    }

    protected Widget attachPinWidget(N node, PinID<N> pin) {
        NodeWidget nodeWidget = (NodeWidget)this.findWidget(node);
        PinWidget widget = new PinWidget(this, nodeWidget, pin.getName());
        nodeWidget.attachPinWidget(widget);
        widget.getActions().addAction(this.createObjectHoverAction());
        if (this.connectAction != null) {
            widget.getActions().addAction(this.connectAction);
        }
        if (this.menuAction != null) {
            widget.getActions().addAction(this.menuAction);
        }
        return widget;
    }

    boolean hasConnections(PinWidget pinWidget) {
        Object obj = this.findObject(pinWidget);
        if (obj instanceof PinID) {
            PinID pin = (PinID)obj;
            return !this.findPinEdges(pin, true, true).isEmpty();
        }
        return false;
    }

    protected Widget attachEdgeWidget(EdgeID<N> edge) {
        PinWidget src = (PinWidget)this.findWidget(edge.getPin1());
        PinWidget dst = (PinWidget)this.findWidget(edge.getPin2());
        EdgeWidget edgeWidget = new EdgeWidget(this, src, dst);
        edgeWidget.setRouter(this.router);
        this.connectionLayer.addChild((Widget)edgeWidget);
        edgeWidget.getActions().addAction(this.createObjectHoverAction());
        edgeWidget.getActions().addAction(this.createSelectAction());
        if (this.menuAction != null) {
            edgeWidget.getActions().addAction(this.menuAction);
        }
        src.notifyEdgeAttached();
        dst.notifyEdgeAttached();
        return edgeWidget;
    }

    protected void attachEdgeSourceAnchor(EdgeID<N> edge, PinID<N> oldSourcePin, PinID<N> sourcePin) {
        ((EdgeWidget)this.findWidget(edge)).setSourceAnchor(this.getPinAnchor(sourcePin));
    }

    protected void attachEdgeTargetAnchor(EdgeID<N> edge, PinID<N> oldTargetPin, PinID<N> targetPin) {
        ((EdgeWidget)this.findWidget(edge)).setTargetAnchor(this.getPinAnchor(targetPin));
    }

    protected void detachNodeWidget(N node, Widget widget) {
        ((NodeWidget)widget).getCommentWidget().removeFromParent();
        ((NodeWidget)widget).getToolContainerWidget().removeFromParent();
        super.detachNodeWidget(node, widget);
    }

    protected void detachEdgeWidget(EdgeID<N> edge, Widget widget) {
        PinWidget src = (PinWidget)this.findWidget(edge.getPin1());
        PinWidget dst = (PinWidget)this.findWidget(edge.getPin2());
        src.notifyEdgeDetached();
        dst.notifyEdgeDetached();
        super.detachEdgeWidget(edge, widget);
    }

    private Anchor getPinAnchor(PinID<N> pin) {
        if (pin == null) {
            return null;
        }
        PinWidget p = (PinWidget)this.findWidget(pin);
        return p.createAnchor();
    }

    public boolean isBelowLODThreshold() {
        return this.getZoomFactor() < 0.75;
    }

    public void setComment(String comment) {
        if (comment == null || comment.trim().isEmpty()) {
            this.commentWidget.setText("");
            this.commentWidget.setVisible(false);
        } else {
            this.commentWidget.setText(comment);
            this.commentWidget.setVisible(true);
        }
    }

    public String getComment() {
        return this.commentWidget.getText();
    }

    public void setCommentEditProvider(EditProvider provider) {
        this.commentWidget.setEditProvider(provider);
    }

    public void layoutScene() {
        this.sceneLayout.invokeLayout();
    }

    public void setAnimateChanges(boolean animate) {
        this.animate = animate;
    }

    public boolean isAnimateChanges() {
        return this.animate;
    }

    void animatePreferredBounds(Widget widget, Rectangle bounds) {
        if (this.animate && widget.isValidated()) {
            this.getSceneAnimator().animatePreferredBounds(widget, bounds);
        } else {
            widget.setPreferredBounds(bounds);
            this.revalidate();
        }
    }

    private class ZoomCorrector
    implements Scene.SceneListener {
        private final double minZoom = 0.2;
        private final double maxZoom = 2.5;

        private ZoomCorrector() {
        }

        public void sceneRepaint() {
        }

        public void sceneValidating() {
            double zoom = PraxisGraphScene.this.getZoomFactor();
            zoom = zoom > 0.9 && zoom < 1.1 ? 1.0 : (zoom < 0.2 ? 0.2 : (zoom > 2.5 ? 2.5 : (double)Math.round(zoom * 10.0) * 0.1));
            PraxisGraphScene.this.setZoomFactor(zoom);
        }

        public void sceneValidated() {
        }
    }

    private static class WidgetCollector
    implements ConnectionWidgetCollisionsCollector {
        private WidgetCollector() {
        }

        public void collectCollisions(ConnectionWidget connectionWidget, List<Rectangle> verticalCollisions, List<Rectangle> horizontalCollisions) {
            Widget w1 = connectionWidget.getSourceAnchor().getRelatedWidget().getParentWidget();
            Widget w2 = connectionWidget.getTargetAnchor().getRelatedWidget().getParentWidget();
            Rectangle rect = w1.getBounds();
            rect = w1.convertLocalToScene(rect);
            rect.grow(10, 10);
            verticalCollisions.add(rect);
            horizontalCollisions.add(rect);
            rect = w2.getBounds();
            rect = w2.convertLocalToScene(rect);
            rect.grow(10, 10);
            verticalCollisions.add(rect);
            horizontalCollisions.add(rect);
        }
    }
}

