/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.Point;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

class PraxisKeyboardMoveAction
extends WidgetAction.Adapter {
    private static final int MOVEMENT = 10;
    private final MoveStrategy strategy;
    private final MoveProvider provider;
    private Widget movingWidget;

    PraxisKeyboardMoveAction(MoveStrategy strategy, MoveProvider provider) {
        this.strategy = strategy;
        this.provider = provider;
    }

    public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent event) {
        if (!this.isArrowKey(event)) {
            return WidgetAction.State.REJECTED;
        }
        int x = 0;
        int y = 0;
        switch (event.getKeyCode()) {
            case 38: {
                y -= 10;
                break;
            }
            case 40: {
                y += 10;
                break;
            }
            case 37: {
                x -= 10;
                break;
            }
            case 39: {
                x += 10;
            }
        }
        if (this.movingWidget != widget) {
            this.movingWidget = widget;
            this.provider.movementStarted(widget);
        }
        Point location = this.provider.getOriginalLocation(widget);
        Point suggested = new Point(location);
        suggested.x += x;
        suggested.y += y;
        this.provider.setNewLocation(widget, this.strategy.locationSuggested(widget, location, suggested));
        return WidgetAction.State.CONSUMED;
    }

    public WidgetAction.State keyReleased(Widget widget, WidgetAction.WidgetKeyEvent event) {
        if (widget == this.movingWidget && this.isArrowKey(event)) {
            this.movingWidget = null;
            this.provider.movementFinished(widget);
            return WidgetAction.State.CONSUMED;
        }
        return WidgetAction.State.REJECTED;
    }

    private boolean isArrowKey(WidgetAction.WidgetKeyEvent event) {
        int code = event.getKeyCode();
        return code == 38 || code == 40 || code == 37 || code == 39;
    }
}

