/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.AlignWithMoveDecorator;
import org.netbeans.api.visual.action.AlignWithWidgetCollector;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.praxislive.ide.pxr.graph.scene.AlignWithSupport;
import org.praxislive.ide.pxr.graph.scene.PraxisGraphScene;

class PraxisMoveProvider
extends AlignWithSupport
implements MoveProvider,
MoveStrategy {
    private final Map<Widget, Point> locations;
    private final MoveProvider defaultProvider;
    private final PraxisGraphScene<?> scene;
    private final boolean outerBounds = false;

    PraxisMoveProvider(PraxisGraphScene<?> scene, LayerWidget interactionLayer) {
        super(new NodeCollector(scene), interactionLayer, new Decorator());
        this.scene = scene;
        this.locations = new HashMap<Widget, Point>();
        this.defaultProvider = ActionFactory.createDefaultMoveProvider();
    }

    public void movementStarted(Widget widget) {
        this.show();
    }

    public void movementFinished(Widget widget) {
        this.hide();
        this.locations.clear();
    }

    public Point getOriginalLocation(Widget widget) {
        this.locations.put(widget, this.defaultProvider.getOriginalLocation(widget));
        for (Object obj : this.scene.getSelectedObjects()) {
            Widget additional;
            if (!this.scene.isNode(obj) || (additional = this.scene.findWidget(obj)) == widget) continue;
            this.locations.put(additional, this.defaultProvider.getOriginalLocation(additional));
        }
        return this.defaultProvider.getOriginalLocation(widget);
    }

    public void setNewLocation(Widget widget, Point location) {
        this.defaultProvider.setNewLocation(widget, location);
        Point primary = this.locations.get(widget);
        if (primary == null || this.locations.size() == 1) {
            return;
        }
        int dx = location.x - primary.x;
        int dy = location.y - primary.y;
        for (Map.Entry<Widget, Point> loc : this.locations.entrySet()) {
            Widget additional = loc.getKey();
            if (additional == widget) continue;
            Point pt = new Point(loc.getValue());
            pt.translate(dx, dy);
            this.defaultProvider.setNewLocation(additional, pt);
        }
    }

    public Point locationSuggested(Widget widget, Point originalLocation, Point suggestedLocation) {
        Point widgetLocation = widget.getLocation();
        Rectangle widgetBounds = widget.getClientArea();
        Rectangle bounds = widget.convertLocalToScene(widgetBounds);
        bounds.translate(suggestedLocation.x - widgetLocation.x, suggestedLocation.y - widgetLocation.y);
        Insets insets = widget.getBorder().getInsets();
        suggestedLocation.x += insets.left;
        suggestedLocation.y += insets.top;
        Point point = super.locationSuggested(widget, bounds, widget.getParentWidget().convertLocalToScene(suggestedLocation), true, true, true, true);
        point.x -= insets.left;
        point.y -= insets.top;
        return widget.getParentWidget().convertSceneToLocal(point);
    }

    static class NodeCollector
    implements AlignWithWidgetCollector {
        private final PraxisGraphScene<?> scene;

        public NodeCollector(PraxisGraphScene<?> scene) {
            this.scene = scene;
        }

        public List<Rectangle> getRegions(Widget movingWidget) {
            ArrayList<Rectangle> regions = new ArrayList<Rectangle>();
            ArrayList nodes = new ArrayList(this.scene.getNodes());
            nodes.removeAll(this.scene.getSelectedObjects());
            for (Object node : nodes) {
                Widget widget = this.scene.findWidget(node);
                if (widget == null || widget == movingWidget) continue;
                regions.add(widget.convertLocalToScene(widget.getClientArea()));
            }
            return regions;
        }
    }

    private static class Decorator
    implements AlignWithMoveDecorator {
        private static final BasicStroke STROKE = new BasicStroke(1.0f, 2, 0, 5.0f, new float[]{2.0f, 2.0f}, 0.0f);
        private static final Color COLOR = new Color(127, 127, 127);

        private Decorator() {
        }

        public ConnectionWidget createLineWidget(Scene scene) {
            ConnectionWidget widget = new ConnectionWidget(scene);
            widget.setStroke((Stroke)STROKE);
            widget.setForeground(COLOR);
            return widget;
        }
    }
}

