/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Action;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PBytes;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PResource;
import org.praxislive.ide.core.api.Syncable;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.pxr.graph.SuggestFieldInplaceEditor;
import org.praxislive.ide.pxr.graph.SuggestFieldInplaceEditorProvider;
import org.praxislive.ide.pxr.graph.scene.LAFScheme;

class ExposedControls
extends Widget {
    private static final Object SYNC_KEY = new Object();
    private static final Border LABEL_BORDER = BorderFactory.createEmptyBorder((int)1);
    private final Map<String, ControlWidget> controlWidgets = new LinkedHashMap<String, ControlWidget>();
    private final Node node;
    private final Syncable sync;
    private final Listener listener;

    public ExposedControls(Scene scene, ComponentProxy cmp, List<String> controls) {
        super(scene);
        this.node = cmp.getNodeDelegate();
        this.sync = (Syncable)this.node.getLookup().lookup(Syncable.class);
        this.listener = new Listener();
        this.setOpaque(true);
        this.setForeground(null);
        this.setBorder(BorderFactory.createRoundedBorder((int)4, (int)4, (int)2, (int)2, (Color)LAFScheme.BACKGROUND, null));
        this.setLayout(new TableLayout());
        ComponentInfo info = cmp.getInfo();
        this.getActions().addAction((WidgetAction)new MouseCapture());
        for (String control : controls) {
            ControlWidget controlWidget;
            ControlInfo controlInfo = info.controlInfo(control);
            if (controlInfo == null || (controlWidget = this.createControl(scene, this.node, control, controlInfo)) == null) continue;
            this.addChild(this.createLabel(scene, control));
            this.controlWidgets.put(control, controlWidget);
            this.addChild((Widget)controlWidget);
        }
    }

    protected void notifyAdded() {
        super.notifyAdded();
        this.controlWidgets.values().forEach(cw -> cw.updateText());
        this.node.addPropertyChangeListener((PropertyChangeListener)this.listener);
        if (this.sync != null) {
            this.sync.addKey(SYNC_KEY);
        }
    }

    protected void notifyRemoved() {
        super.notifyRemoved();
        this.node.removePropertyChangeListener((PropertyChangeListener)this.listener);
        if (this.sync != null) {
            this.sync.removeKey(SYNC_KEY);
        }
    }

    private ControlWidget createControl(Scene scene, Node node, String controlID, ControlInfo controlInfo) {
        if (controlInfo.controlType() == ControlInfo.Type.Action) {
            Action action = this.findAction(node, controlID);
            if (action != null) {
                return new ControlWidget(scene, controlInfo, node, action);
            }
        } else {
            Node.Property<?> property = this.findProperty(node, controlID);
            if (property != null) {
                return new ControlWidget(scene, controlInfo, node, property);
            }
        }
        return null;
    }

    private Widget createLabel(Scene scene, String id) {
        LabelWidget label = new LabelWidget(scene, id + " :");
        label.setForeground(null);
        label.setAlignment(LabelWidget.Alignment.RIGHT);
        label.setBorder(LABEL_BORDER);
        return label;
    }

    private Action findAction(Node node, String id) {
        for (Action action : node.getActions(false)) {
            if (action == null || !id.equals(action.getValue("Name"))) continue;
            return action;
        }
        return null;
    }

    private Node.Property<?> findProperty(Node node, String id) {
        for (Node.PropertySet propSet : node.getPropertySets()) {
            for (Node.Property prop : propSet.getProperties()) {
                if (!id.equals(prop.getName())) continue;
                if (prop.isHidden()) {
                    return null;
                }
                return prop;
            }
        }
        return null;
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String control = evt.getPropertyName();
            if (control == null) {
                ExposedControls.this.controlWidgets.values().forEach(cw -> cw.updateText());
            } else {
                ControlWidget cw2 = ExposedControls.this.controlWidgets.get(control);
                if (cw2 != null) {
                    cw2.updateText();
                }
            }
        }
    }

    private static class TableLayout
    implements Layout {
        private final int HORIZONTAL_GAP = 4;
        private final int VERTICAL_GAP = 4;

        private TableLayout() {
        }

        public void layout(Widget widget) {
            Widget label;
            int i;
            List children = widget.getChildren();
            int y = 0;
            int labelWidth = 0;
            for (i = 0; i < children.size(); i += 2) {
                label = (Widget)children.get(i);
                Rectangle labelBounds = label.getPreferredBounds();
                labelWidth = Math.max(labelWidth, labelBounds.width);
            }
            for (i = 0; i < children.size(); i += 2) {
                label = (Widget)children.get(i);
                Widget property = (Widget)children.get(i + 1);
                Rectangle labelBounds = label.getPreferredBounds();
                Rectangle propBounds = property.getPreferredBounds();
                int height = Math.max(labelBounds.height, propBounds.height);
                labelBounds.width = labelWidth;
                labelBounds.height = height;
                label.resolveBounds(new Point(0, y), labelBounds);
                propBounds.height = height;
                property.resolveBounds(new Point(labelBounds.width + 4, y), propBounds);
                y += height + 4;
            }
        }

        public boolean requiresJustification(Widget widget) {
            return true;
        }

        public void justify(Widget widget) {
            Rectangle bounds = widget.getClientArea();
            int x = bounds.x;
            int y = bounds.y;
            List children = widget.getChildren();
            for (int i = 0; i < children.size(); i += 2) {
                int height;
                Widget label = (Widget)children.get(i);
                Widget property = (Widget)children.get(i + 1);
                Rectangle labelBounds = label.getBounds();
                Rectangle propBounds = property.getBounds();
                labelBounds.height = height = Math.max(labelBounds.height, propBounds.height);
                label.resolveBounds(new Point(x - labelBounds.x, y - labelBounds.y), labelBounds);
                propBounds.height = height;
                propBounds.width = bounds.width - 4 - labelBounds.width;
                property.resolveBounds(new Point(x - propBounds.x + labelBounds.width + 4, y - propBounds.y), propBounds);
                y += height + 4;
            }
        }
    }

    private static class MouseCapture
    extends WidgetAction.Adapter {
        private MouseCapture() {
        }

        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
            return WidgetAction.State.CONSUMED;
        }
    }

    private static class ControlWidget
    extends LabelWidget {
        private static final DecimalFormat FORMATTER = new DecimalFormat("####0.0####");
        private final Scene scene;
        private final ControlInfo info;
        private final Node node;
        private final Node.Property<Object> property;
        private final Action action;
        private final Value.Type<?> valueType;

        private ControlWidget(Scene scene, ControlInfo info, Node node, Action action) {
            this(scene, info, node, null, action);
        }

        private ControlWidget(Scene scene, ControlInfo info, Node node, Node.Property<?> property) {
            this(scene, info, node, property, null);
        }

        private ControlWidget(Scene scene, ControlInfo info, Node node, Node.Property<?> property, Action action) {
            super(scene);
            List args;
            Object object;
            this.scene = scene;
            this.info = Objects.requireNonNull(info);
            this.node = node;
            this.property = property;
            this.action = action;
            this.setBorder(new BorderImpl());
            if (action != null && (object = action.getValue("Name")) instanceof String) {
                String id = (String)object;
                this.setLabel(id);
            }
            this.valueType = (args = info.outputs()).size() != 1 ? Value.Type.of(Value.class) : Value.Type.fromName((String)((ArgumentInfo)args.get(0)).argumentType()).orElse(Value.Type.of(Value.class));
            this.getActions().addAction(scene.createWidgetHoverAction());
            if (action != null) {
                this.initActionTrigger();
            } else if (info.controlType() == ControlInfo.Type.Function) {
                this.initFunctionEdit();
            } else {
                this.initPropertyEdit();
            }
            if (info.controlType() != ControlInfo.Type.ReadOnlyProperty) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        private void initActionTrigger() {
            this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)new SelectProvider(){

                public boolean isAimingAllowed(Widget widget, Point point, boolean bln) {
                    return true;
                }

                public boolean isSelectionAllowed(Widget widget, Point point, boolean bln) {
                    return true;
                }

                public void select(Widget widget, Point point, boolean bln) {
                    action.actionPerformed(new ActionEvent(widget, 1001, "trigger"));
                }
            }, (boolean)false));
        }

        private void initFunctionEdit() {
            final WidgetAction inplaceEditorAction = ActionFactory.createInplaceEditorAction((InplaceEditorProvider)new SuggestFieldInplaceEditorProvider(new InplaceEditor(List.of())));
            final InplaceEditorProvider.EditorController inplaceEditorController = ActionFactory.getInplaceEditorController((WidgetAction)inplaceEditorAction);
            this.getActions().addAction((WidgetAction)new WidgetAction.Adapter(this){

                public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent event) {
                    if (event.getButton() == 1 && event.getClickCount() == 1) {
                        inplaceEditorController.openEditor(widget);
                        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)inplaceEditorAction);
                    }
                    return WidgetAction.State.REJECTED;
                }
            });
            this.getActions().addAction(inplaceEditorAction);
        }

        private void initPropertyEdit() {
            boolean readOnly = this.info.controlType() != ControlInfo.Type.Property;
            Class type = this.valueType.asClass();
            List<String> suggested = List.of();
            boolean inplace = false;
            if (!readOnly) {
                Value allowed;
                if (PNumber.class == type) {
                    inplace = true;
                } else if (!this.info.inputs().isEmpty() && (allowed = ((ArgumentInfo)this.info.inputs().get(0)).properties().get("allowed-values")) != null) {
                    suggested = PArray.from((Value)allowed).map(a -> a.stream().map(Value::toString).toList()).orElse(List.of());
                    boolean bl = inplace = !suggested.isEmpty();
                }
            }
            if (inplace) {
                final WidgetAction inplaceEditorAction = ActionFactory.createInplaceEditorAction((InplaceEditorProvider)new SuggestFieldInplaceEditorProvider(new InplaceEditor(suggested)));
                final InplaceEditorProvider.EditorController inplaceEditorController = ActionFactory.getInplaceEditorController((WidgetAction)inplaceEditorAction);
                this.getActions().addAction((WidgetAction)new WidgetAction.Adapter(this){

                    public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent event) {
                        if (event.getButton() == 1 && event.getClickCount() == 1) {
                            inplaceEditorController.openEditor(widget);
                            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)inplaceEditorAction);
                        }
                        return WidgetAction.State.REJECTED;
                    }
                });
                this.getActions().addAction(inplaceEditorAction);
            } else {
                Object editHandler = PBoolean.class == type ? new BooleanEditHandler() : new PropertyEditHandler();
                this.getActions().addAction((WidgetAction)new WidgetAction.Adapter(this, (EditProvider)editHandler){
                    final /* synthetic */ EditProvider val$editHandler;
                    {
                        this.val$editHandler = editProvider;
                    }

                    public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent event) {
                        if (event.getButton() == 1 && event.getClickCount() == 1) {
                            this.val$editHandler.edit(widget);
                            return WidgetAction.State.CONSUMED;
                        }
                        return WidgetAction.State.REJECTED;
                    }
                });
            }
        }

        private void updateText() {
            if (this.property == null) {
                return;
            }
            try {
                Object value = this.property.getValue();
                if (this.valueType.asClass() == PNumber.class) {
                    PNumber num = PNumber.from((Value)((Value)value)).orElse(PNumber.ZERO);
                    if (num.isInteger()) {
                        this.setLabel(num.toString());
                    } else {
                        this.setLabel(FORMATTER.format(num.value()));
                    }
                } else if (this.valueType.asClass() == PBytes.class) {
                    this.setLabel("<bytes>");
                } else if (this.valueType.asClass() == PResource.class) {
                    String txt = value.toString();
                    int lastSlash = txt.lastIndexOf("/");
                    if (lastSlash > 0) {
                        txt = txt.substring(lastSlash);
                    }
                    this.setLabel(txt);
                } else {
                    PropertyEditor ed = this.property.getPropertyEditor();
                    ed.setValue(this.property.getValue());
                    String text = ed.getAsText();
                    if (text != null) {
                        this.setLabel(text);
                    } else {
                        this.setLabel(String.valueOf(ed.getValue()));
                    }
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.setLabel("");
            }
            this.scene.validate();
        }

        protected Rectangle calculateClientArea() {
            Rectangle r = super.calculateClientArea();
            r.width = Math.min(120, Math.max(80, r.width));
            return r;
        }

        protected void paintWidget() {
            PropertyEditor ed;
            if (this.info.controlType() == ControlInfo.Type.Function && (ed = this.property.getPropertyEditor()).isPaintable()) {
                ed.paintValue(this.getGraphics(), this.getClientArea());
                return;
            }
            super.paintWidget();
        }

        protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
            if (previousState.isHovered() != state.isHovered() || previousState.isWidgetAimed() != state.isWidgetAimed()) {
                this.repaint();
            }
        }

        private class BorderImpl
        implements Border {
            private BorderImpl() {
            }

            public Insets getInsets() {
                return LABEL_BORDER.getInsets();
            }

            public void paint(Graphics2D g, Rectangle bounds) {
                if (ControlWidget.this.getState().isHovered() && ControlWidget.this.info.controlType() != ControlInfo.Type.ReadOnlyProperty) {
                    g.setColor(ControlWidget.this.getParentWidget().getForeground());
                    int y = bounds.y + bounds.height - 1;
                    g.drawLine(bounds.x, y, bounds.x + bounds.width, y);
                }
            }

            public boolean isOpaque() {
                return false;
            }
        }

        private class InplaceEditor
        implements SuggestFieldInplaceEditor {
            private final List<String> suggested;

            private InplaceEditor(List<String> suggested) {
                this.suggested = suggested;
            }

            @Override
            public List<String> getSuggestedValues(Widget widget) {
                return this.suggested;
            }

            public boolean isEnabled(Widget widget) {
                return true;
            }

            public String getText(Widget widget) {
                try {
                    PropertyEditor ed = ControlWidget.this.property.getPropertyEditor();
                    ed.setValue(ControlWidget.this.property.getValue());
                    String text = ed.getAsText();
                    if (text != null) {
                        return text;
                    }
                    return "";
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return "";
                }
            }

            public void setText(Widget widget, String string) {
                try {
                    PropertyEditor ed = ControlWidget.this.property.getPropertyEditor();
                    ed.setAsText(string);
                    ControlWidget.this.property.setValue(ed.getValue());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        private class BooleanEditHandler
        implements EditProvider {
            private BooleanEditHandler() {
            }

            public void edit(Widget widget) {
                try {
                    boolean isBoolean;
                    boolean bl = isBoolean = ControlWidget.this.property.getValueType() == Boolean.class;
                    if (isBoolean) {
                        boolean value = (Boolean)ControlWidget.this.property.getValue();
                        value = !value;
                        ControlWidget.this.property.setValue((Object)value);
                    } else {
                        PropertyEditor ed = ControlWidget.this.property.getPropertyEditor();
                        boolean value = "true".equalsIgnoreCase(ed.getAsText());
                        value = !value;
                        ed.setAsText("" + value);
                        ControlWidget.this.property.setValue(ed.getValue());
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        private class PropertyEditHandler
        implements EditProvider {
            private PropertyEditHandler() {
            }

            public void edit(Widget widget) {
                PropertyEditor ed = ControlWidget.this.property.getPropertyEditor();
                PropertyPanel panel = ed.supportsCustomEditor() ? new PropertyPanel(ControlWidget.this.property, 2) : new PropertyPanel(ControlWidget.this.property);
                panel.setChangeImmediate(false);
                DialogDescriptor descriptor = new DialogDescriptor((Object)panel, ControlWidget.this.property.getDisplayName(), true, e -> {
                    if (e.getSource() == DialogDescriptor.OK_OPTION) {
                        panel.updateValue();
                    }
                });
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)descriptor);
            }
        }
    }
}

