/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.border.LineBorder;
import org.netbeans.api.visual.action.AcceptProvider;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Connection;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.PortInfo;
import org.praxislive.core.Value;
import org.praxislive.core.Watch;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PNumber;
import org.praxislive.ide.core.api.Disposable;
import org.praxislive.ide.core.api.Syncable;
import org.praxislive.ide.core.api.Task;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.model.ContainerProxy;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.pxr.api.ActionSupport;
import org.praxislive.ide.pxr.api.Attributes;
import org.praxislive.ide.pxr.api.EditorUtils;
import org.praxislive.ide.pxr.graph.AddPortToParentAction;
import org.praxislive.ide.pxr.graph.ExposedControls;
import org.praxislive.ide.pxr.graph.PositionTransform;
import org.praxislive.ide.pxr.graph.Utils;
import org.praxislive.ide.pxr.graph.WatchDisplay;
import org.praxislive.ide.pxr.graph.scene.Alignment;
import org.praxislive.ide.pxr.graph.scene.EdgeID;
import org.praxislive.ide.pxr.graph.scene.EdgeWidget;
import org.praxislive.ide.pxr.graph.scene.NodeWidget;
import org.praxislive.ide.pxr.graph.scene.ObjectSceneAdaptor;
import org.praxislive.ide.pxr.graph.scene.PinID;
import org.praxislive.ide.pxr.graph.scene.PinWidget;
import org.praxislive.ide.pxr.graph.scene.PraxisGraphScene;
import org.praxislive.ide.pxr.spi.RootEditor;

public final class GraphEditor
implements RootEditor {
    private static final Logger LOG = Logger.getLogger(GraphEditor.class.getName());
    static final String ATTR_GRAPH_X = "graph.x";
    static final String ATTR_GRAPH_Y = "graph.y";
    static final String ATTR_GRAPH_MINIMIZED = "graph.minimized";
    static final String ATTR_GRAPH_COMMENT = "graph.comment";
    private final PraxisProject project;
    private final FileObject file;
    private final RootProxy root;
    private final Map<String, ComponentProxy> knownChildren;
    private final Set<Connection> knownConnections;
    private final ContainerListener containerListener;
    private final ComponentListener componentListener;
    private final SelectionListener selectionListener;
    private final Map<String, PArray> exposedTools;
    private final PraxisGraphScene<String> scene;
    private final ExplorerManager manager;
    private final Lookup lookup;
    private final LocationAction location;
    private final Action addAction;
    private final Action exposeControlAction;
    private final Action goUpAction;
    private final Action deleteAction;
    private final Action sceneCommentAction;
    private final Action exportAction;
    private final Action copyAction;
    private final Action pasteAction;
    private final Action duplicateAction;
    private final Action sharedCodeAction;
    private JComponent panel;
    private ContainerProxy container;
    private final Point activePoint = new Point();
    private boolean sync;
    private boolean ignoreAttributeChanges;

    public GraphEditor(RootProxy proxy, RootEditor.Context context) {
        this.project = (PraxisProject)context.project().orElseThrow();
        this.file = (FileObject)context.file().orElseThrow();
        this.root = proxy;
        this.knownChildren = new LinkedHashMap<String, ComponentProxy>();
        this.knownConnections = new LinkedHashSet<Connection>();
        this.exposedTools = new HashMap<String, PArray>();
        this.scene = new PraxisGraphScene(new ConnectProviderImpl(), new MenuProviderImpl());
        this.scene.setOrthogonalRouting(false);
        this.scene.setMinimizeConnectedPins(false);
        this.manager = context.explorerManager();
        RootProxy rootProxy = this.root;
        if (rootProxy instanceof ContainerProxy) {
            ContainerProxy c;
            this.container = c = (ContainerProxy)rootProxy;
        }
        this.deleteAction = new DeleteAction();
        this.copyAction = ActionSupport.createCopyAction((RootEditor)this, (ExplorerManager)this.manager);
        this.pasteAction = ActionSupport.createPasteAction((RootEditor)this, (ExplorerManager)this.manager);
        this.duplicateAction = ActionSupport.createDuplicateAction((RootEditor)this, (ExplorerManager)this.manager);
        this.exportAction = ActionSupport.createExportAction((RootEditor)this, (ExplorerManager)this.manager);
        this.sharedCodeAction = context.sharedCodeAction().orElse(null);
        Node rootNode = this.root.getNodeDelegate();
        this.manager.setRootContext(rootNode);
        this.manager.setExploredContext(rootNode, new Node[]{rootNode});
        this.lookup = Lookups.fixed((Object[])new Object[]{new PositionTransform.CopyExport(this), new PositionTransform.ImportPaste(this)});
        this.addAction = Actions.forID((String)"PXR", (String)"org.praxislive.ide.pxr.AddChildAction");
        this.exposeControlAction = Actions.forID((String)"PXR", (String)"org.praxislive.ide.pxr.ExposeControlsAction");
        this.selectionListener = new SelectionListener();
        this.scene.addObjectSceneListener(this.selectionListener, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
        this.manager.addPropertyChangeListener((PropertyChangeListener)this.selectionListener);
        this.goUpAction = new GoUpAction();
        this.location = new LocationAction();
        this.containerListener = new ContainerListener();
        this.componentListener = new ComponentListener();
        this.sceneCommentAction = new CommentAction((Widget)this.scene);
        this.setupSceneActions();
    }

    private ActionMap buildActionMap(ActionMap parent) {
        ActionMap am = new ActionMap();
        am.setParent(parent);
        this.deleteAction.setEnabled(false);
        am.put("delete", this.deleteAction);
        am.put("copy-to-clipboard", this.copyAction);
        am.put("paste-from-clipboard", this.pasteAction);
        am.put("duplicate", this.duplicateAction);
        am.put("select-all", new SelectPerformer(true));
        am.put("select-none", new SelectPerformer(false));
        am.put("zoom-in", new ZoomPerformer(1));
        am.put("zoom-out", new ZoomPerformer(-1));
        am.put("zoom-reset", new ZoomPerformer(0));
        return am;
    }

    private void setupSceneActions() {
        this.scene.getActions().addAction(ActionFactory.createAcceptAction((AcceptProvider)new AcceptProviderImpl()));
        this.scene.setCommentEditProvider(widget -> this.sceneCommentAction.actionPerformed(new ActionEvent(this.scene, 1001, "edit")));
    }

    private JPopupMenu getComponentPopup(NodeWidget widget) {
        ArrayList<Action> actions = new ArrayList<Action>();
        Object obj = this.scene.findObject(widget);
        if (obj instanceof String) {
            String id = (String)obj;
            ComponentProxy cmp = this.container.getChild(id);
            if (cmp instanceof ContainerProxy) {
                ContainerProxy container = (ContainerProxy)cmp;
                actions.add(new ContainerOpenAction(container));
                actions.add(null);
            }
            if (cmp != null) {
                actions.addAll(Arrays.asList(cmp.getNodeDelegate().getActions(false)));
            }
        }
        actions.add(null);
        actions.add(this.exposeControlAction);
        actions.add(null);
        actions.add(this.copyAction);
        actions.add(this.duplicateAction);
        actions.add(this.deleteAction);
        actions.add(null);
        actions.add(this.exportAction);
        actions.add(null);
        actions.add(new CommentAction(widget));
        return Utilities.actionsToPopup((Action[])((Action[])actions.toArray(Action[]::new)), (Component)this.getEditorComponent());
    }

    private JPopupMenu getConnectionPopup() {
        return Utilities.actionsToPopup((Action[])new Action[]{this.deleteAction}, (Component)this.getEditorComponent());
    }

    private JPopupMenu getPinPopup(PinWidget widget) {
        PinID pin = (PinID)this.scene.findObject(widget);
        boolean enabled = this.container.getInfo().controls().contains("ports");
        AddPortToParentAction action = new AddPortToParentAction(this, pin);
        action.setEnabled(enabled);
        return Utilities.actionsToPopup((Action[])new Action[]{action}, (Component)this.getEditorComponent());
    }

    private JPopupMenu getScenePopup() {
        Node containerNode = this.container.getNodeDelegate();
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.addAction);
        actions.add(this.pasteAction);
        actions.add(null);
        Action[] containerActions = containerNode.getActions(true);
        if (containerActions.length != 0) {
            actions.addAll(Arrays.asList(containerActions));
            actions.add(null);
        }
        actions.add(null);
        actions.add(this.exposeControlAction);
        actions.add(null);
        if (this.sharedCodeAction != null) {
            actions.add(this.sharedCodeAction);
            actions.add(null);
        }
        actions.add(new CommentAction((Widget)this.scene));
        return Utilities.actionsToPopup((Action[])((Action[])actions.toArray(Action[]::new)), (Lookup)containerNode.getLookup());
    }

    PraxisGraphScene<String> getScene() {
        return this.scene;
    }

    ContainerProxy getContainer() {
        return this.container;
    }

    Point getActivePoint() {
        return new Point(this.activePoint);
    }

    void resetActivePoint() {
        this.activePoint.x = 100;
        this.activePoint.y = 100;
    }

    ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void componentActivated() {
        this.requestFocus();
    }

    public void dispose() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this.selectionListener);
        Disposable.dispose((Object)this.addAction);
        Disposable.dispose((Object)this.copyAction);
        Disposable.dispose((Object)this.duplicateAction);
        Disposable.dispose((Object)this.exportAction);
        Disposable.dispose((Object)this.pasteAction);
    }

    public JComponent getEditorComponent() {
        if (this.panel == null) {
            JPanel viewPanel = new JPanel(new BorderLayout());
            JComponent sceneView = this.scene.createView();
            sceneView.addMouseListener(new ActivePointListener());
            JScrollPane scroll = new JScrollPane(sceneView, 20, 30);
            viewPanel.add((Component)scroll, "Center");
            JPanel overlayPanel = new JPanel();
            overlayPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(0, 0, 20, 20);
            gbc.anchor = 14;
            JPanel satellitePanel = new JPanel(new BorderLayout());
            satellitePanel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
            satellitePanel.add(this.scene.createSatelliteView());
            overlayPanel.add((Component)satellitePanel, gbc);
            overlayPanel.setOpaque(false);
            JLayeredPane layered = new JLayeredPane();
            layered.setLayout(new OverlayLayout(layered));
            layered.add((Component)viewPanel, JLayeredPane.DEFAULT_LAYER);
            layered.add((Component)overlayPanel, JLayeredPane.PALETTE_LAYER);
            this.panel = new JPanel(new BorderLayout());
            this.panel.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    GraphEditor.this.scene.getView().requestFocusInWindow();
                }
            });
            this.panel.add((Component)layered, "Center");
            if (this.sharedCodeAction != null) {
                JToggleButton sharedCodeButton = new JToggleButton(this.sharedCodeAction);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.insets = new Insets(0, 20, 20, 0);
                gbc.anchor = 16;
                overlayPanel.add((Component)sharedCodeButton, gbc);
            }
            InputMap im = this.panel.getInputMap(1);
            ActionMap am = this.buildActionMap(this.panel.getActionMap());
            im.put(KeyStroke.getKeyStroke("alt shift F"), "format");
            am.put("format", new AbstractAction("format"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphEditor.this.scene.layoutScene();
                }
            });
            im.put(KeyStroke.getKeyStroke(27, 0, true), "escape");
            am.put("escape", this.goUpAction);
            this.panel.setActionMap(am);
            if (this.container != null) {
                this.buildScene();
            }
        }
        return this.panel;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public List<Action> getActions() {
        return List.of(this.goUpAction, this.location);
    }

    public boolean requestFocus() {
        if (this.panel == null) {
            return false;
        }
        return this.scene.getView().requestFocusInWindow();
    }

    public Set<RootEditor.ToolAction> supportedToolActions() {
        return EnumSet.allOf(RootEditor.ToolAction.class);
    }

    public void sync() {
        this.syncAllAttributes();
    }

    private void clearScene() {
        this.syncAllAttributes();
        this.container.removePropertyChangeListener((PropertyChangeListener)this.containerListener);
        Syncable syncable = (Syncable)this.container.getLookup().lookup(Syncable.class);
        if (syncable != null) {
            syncable.removeKey((Object)this);
        }
        for (Map.Entry<String, ComponentProxy> child : this.knownChildren.entrySet()) {
            this.removeChild(child.getKey(), child.getValue());
        }
        this.activePoint.setLocation(0, 0);
        this.knownChildren.clear();
        this.exposedTools.clear();
        this.knownConnections.clear();
        this.location.address.setText("");
    }

    private void buildScene() {
        this.container.addPropertyChangeListener((PropertyChangeListener)this.containerListener);
        this.manager.setExploredContext(this.container.getNodeDelegate());
        Syncable syncable = (Syncable)this.container.getLookup().lookup(Syncable.class);
        if (syncable != null) {
            syncable.addKey((Object)this);
        }
        this.container.getNodeDelegate().getChildren().getNodes();
        this.syncGraph(true);
        this.goUpAction.setEnabled(this.container.getParent() != null);
        this.location.address.setText(this.container.getAddress().toString());
        this.scene.setComment(Attributes.get((ComponentProxy)this.container, (String)ATTR_GRAPH_COMMENT, (String)""));
        this.configureExposedSceneTools();
        this.scene.validate();
    }

    private void buildChild(String id, ComponentProxy cmp) {
        Object name = cmp instanceof ContainerProxy ? id + "/.." : id;
        NodeWidget widget = this.scene.addNode(id, (String)name);
        widget.setSchemeColors(Utils.colorsForComponent(cmp));
        widget.setToolTipText(cmp.getType().toString());
        this.configureWidgetFromAttributes(widget, cmp);
        if (cmp instanceof ContainerProxy) {
            ContainerOpenAction containerOpenAction = new ContainerOpenAction((ContainerProxy)cmp);
            widget.getActions().addAction(ActionFactory.createEditAction(w -> {
                AWTEvent current = EventQueue.getCurrentEvent();
                if (current instanceof InputEvent && ((InputEvent)current).isShiftDown()) {
                    cmp.getNodeDelegate().getPreferredAction().actionPerformed(new ActionEvent(this, 1001, "edit", 1));
                } else {
                    containerOpenAction.actionPerformed(new ActionEvent(this, 1001, "edit"));
                }
            }));
        } else {
            widget.getActions().addAction(ActionFactory.createEditAction(w -> {
                AWTEvent current = EventQueue.getCurrentEvent();
                int modifiers = current instanceof InputEvent ? ((InputEvent)current).getModifiers() : 0;
                cmp.getNodeDelegate().getPreferredAction().actionPerformed(new ActionEvent(this, 1001, "edit", modifiers));
            }));
        }
        CommentAction commentAction = new CommentAction(widget);
        widget.setCommentEditProvider(w -> commentAction.actionPerformed(new ActionEvent(w, 1001, "edit")));
        ComponentInfo info = cmp.getInfo();
        for (String portID : info.ports()) {
            PortInfo pi = info.portInfo(portID);
            this.buildPin(id, cmp, portID, pi);
        }
        cmp.addPropertyChangeListener((PropertyChangeListener)this.componentListener);
        this.syncConnections();
        this.configureExposedTools(widget, cmp);
    }

    private void rebuildChild(String id, ComponentProxy cmp) {
        Iterator<Connection> itr = this.knownConnections.iterator();
        while (itr.hasNext()) {
            Connection con = itr.next();
            if (!con.sourceComponent().equals(id) && !con.targetComponent().equals(id)) continue;
            itr.remove();
        }
        ArrayList pins = new ArrayList(this.scene.getNodePins(id));
        for (Object pin : pins) {
            this.scene.removePinWithEdges(pin);
        }
        ComponentInfo info = cmp.getInfo();
        for (String portID : info.ports()) {
            PortInfo pi = info.portInfo(portID);
            this.buildPin(id, cmp, portID, pi);
        }
        this.syncConnections();
        Widget w = this.scene.findWidget(cmp.getAddress().componentID());
        if (w instanceof NodeWidget) {
            NodeWidget node = (NodeWidget)w;
            this.configureWidgetFromAttributes(node, cmp);
            this.configureExposedTools(node, cmp);
        }
    }

    private void removeChild(String id, ComponentProxy cmp) {
        cmp.removePropertyChangeListener((PropertyChangeListener)this.componentListener);
        this.scene.removeNodeWithEdges(id);
        this.activePoint.x = 0;
        this.activePoint.y = 0;
    }

    private void configureExposedSceneTools() {
        List<String> watches;
        String id = "<ROOT>";
        String key = "expose";
        PArray expose = (PArray)Attributes.get((ComponentProxy)this.container, PArray.class, (String)key, null);
        if (expose == null) {
            expose = Optional.ofNullable(this.container.getInfo().properties().get(key)).flatMap(PArray::from).orElse(PArray.EMPTY);
        }
        if (Objects.equals(expose, this.exposedTools.get(id))) {
            return;
        }
        this.exposedTools.put(key, expose);
        this.scene.clearToolWidgets();
        ComponentInfo info = this.container.getInfo();
        Map<Boolean, List<String>> partitioned = expose.stream().map(Value::toString).filter(c -> info.controls().contains(c)).collect(Collectors.partitioningBy(c -> {
            ControlInfo ci;
            ControlInfo patt0$temp = info.controlInfo(c);
            return patt0$temp instanceof ControlInfo && Watch.isWatch((ControlInfo)(ci = patt0$temp));
        }));
        List<String> controls = partitioned.get(false);
        if (!controls.isEmpty()) {
            this.scene.addToolWidget(new ExposedControls((Scene)this.scene, (ComponentProxy)this.container, controls));
        }
        if (!(watches = partitioned.get(true)).isEmpty()) {
            for (String watch : watches) {
                WatchDisplay watchDisplay = WatchDisplay.createWidget(this.scene, (ComponentProxy)this.container, watch);
                if (watchDisplay == null) continue;
                this.scene.addToolWidget(watchDisplay);
            }
        }
    }

    private void configureExposedTools(NodeWidget widget, ComponentProxy cmp) {
        List<String> watches;
        String id = cmp.getID();
        String key = "expose";
        PArray expose = (PArray)Attributes.get((ComponentProxy)cmp, PArray.class, (String)key, null);
        if (expose == null) {
            expose = Optional.ofNullable(cmp.getInfo().properties().get(key)).flatMap(PArray::from).orElse(PArray.EMPTY);
        }
        if (Objects.equals(expose, this.exposedTools.get(id))) {
            return;
        }
        this.exposedTools.put(key, expose);
        widget.clearToolWidgets();
        ComponentInfo info = cmp.getInfo();
        Map<Boolean, List<String>> partitioned = expose.stream().map(Value::toString).filter(c -> info.controls().contains(c)).collect(Collectors.partitioningBy(c -> {
            ControlInfo ci;
            ControlInfo patt0$temp = info.controlInfo(c);
            return patt0$temp instanceof ControlInfo && Watch.isWatch((ControlInfo)(ci = patt0$temp));
        }));
        List<String> controls = partitioned.get(false);
        if (!controls.isEmpty()) {
            widget.addToolWidget(new ExposedControls((Scene)this.scene, cmp, controls));
        }
        if (!(watches = partitioned.get(true)).isEmpty()) {
            for (String watch : watches) {
                WatchDisplay watchDisplay = WatchDisplay.createWidget(this.scene, cmp, watch);
                if (watchDisplay == null) continue;
                widget.addToolWidget(watchDisplay);
            }
        }
    }

    private void configureWidgetFromAttributes(NodeWidget widget, ComponentProxy cmp) {
        widget.setPreferredLocation(this.resolveLocation(cmp));
        if (((PBoolean)Attributes.get((ComponentProxy)cmp, PBoolean.class, (String)ATTR_GRAPH_MINIMIZED, (Value)PBoolean.FALSE)).value()) {
            widget.setMinimized(true);
        }
        this.updateWidgetComment(widget, Attributes.get((ComponentProxy)cmp, (String)ATTR_GRAPH_COMMENT, (String)""), cmp instanceof ContainerProxy);
        this.scene.validate();
    }

    private Point resolveLocation(ComponentProxy cmp) {
        int x = ((PNumber)Attributes.get((ComponentProxy)cmp, PNumber.class, (String)ATTR_GRAPH_X, (Value)PNumber.of((int)this.activePoint.x))).toIntValue();
        int y = ((PNumber)Attributes.get((ComponentProxy)cmp, PNumber.class, (String)ATTR_GRAPH_Y, (Value)PNumber.of((int)this.activePoint.y))).toIntValue();
        return new Point(x, y);
    }

    private void buildPin(String cmpID, ComponentProxy cmp, String pinID, PortInfo info) {
        String category;
        boolean primary = !info.portType().startsWith("Control");
        PinWidget pin = this.scene.addPin(cmpID, pinID, this.getPinAlignment(info));
        pin.setSchemeColors(Utils.colorsForPortType(info.portType()));
        Font font = pin.getFont();
        if (primary) {
            pin.setFont(font.deriveFont(1));
        }
        if ((category = info.properties().getString("category", "")).isEmpty()) {
            pin.setToolTipText(pinID + " : " + info.portType());
        } else {
            pin.setToolTipText(pinID + " : " + info.portType() + " : " + category);
        }
    }

    private Alignment getPinAlignment(PortInfo info) {
        switch (info.direction()) {
            case IN: {
                return Alignment.Left;
            }
            case OUT: {
                return Alignment.Right;
            }
        }
        return Alignment.Center;
    }

    private boolean buildConnection(Connection connection) {
        PinID<String> p1 = new PinID<String>(connection.sourceComponent(), connection.sourcePort());
        PinID<String> p2 = new PinID<String>(connection.targetComponent(), connection.targetPort());
        if (this.scene.isPin(p1) && this.scene.isPin(p2)) {
            PinWidget pw1 = (PinWidget)this.scene.findWidget(p1);
            PinWidget pw2 = (PinWidget)this.scene.findWidget(p2);
            if (pw1.getAlignment() == Alignment.Left && pw2.getAlignment() == Alignment.Right) {
                EdgeWidget widget = this.scene.connect(connection.targetComponent(), connection.targetPort(), connection.sourceComponent(), connection.sourcePort());
                widget.setToolTipText(connection.targetComponent() + "!" + connection.targetPort() + " -> " + connection.sourceComponent() + "!" + connection.sourcePort());
            } else {
                EdgeWidget widget = this.scene.connect(connection.sourceComponent(), connection.sourcePort(), connection.targetComponent(), connection.targetPort());
                widget.setToolTipText(connection.sourceComponent() + "!" + connection.sourcePort() + " -> " + connection.targetComponent() + "!" + connection.targetPort());
            }
            return true;
        }
        return false;
    }

    private boolean removeConnection(Connection connection) {
        EdgeID<String> edge = new EdgeID<String>(new PinID<String>(connection.sourceComponent(), connection.sourcePort()), new PinID<String>(connection.targetComponent(), connection.targetPort()));
        if (this.scene.isEdge(edge)) {
            this.scene.disconnect(connection.sourceComponent(), connection.sourcePort(), connection.targetComponent(), connection.targetPort());
            return true;
        }
        return false;
    }

    private void syncChildren(boolean updateSelection) {
        ComponentProxy cmp;
        if (this.container == null) {
            return;
        }
        List ch = this.container.children().collect(Collectors.toList());
        LinkedHashSet<String> tmp = new LinkedHashSet<String>(this.knownChildren.keySet());
        tmp.removeAll(ch);
        for (String id : tmp) {
            cmp = this.knownChildren.remove(id);
            this.removeChild(id, cmp);
        }
        tmp.clear();
        tmp.addAll(ch);
        tmp.removeAll(this.knownChildren.keySet());
        for (String id : tmp) {
            cmp = this.container.getChild(id);
            if (cmp == null) continue;
            this.buildChild(id, cmp);
            this.knownChildren.put(id, cmp);
        }
        if (updateSelection && !tmp.isEmpty()) {
            this.scene.userSelectionSuggested(tmp, false);
            this.scene.setFocusedObject(tmp.iterator().next());
        }
        this.scene.validate();
    }

    private void syncConnections() {
        if (this.container == null) {
            return;
        }
        List cons = this.container.connections().collect(Collectors.toList());
        LinkedHashSet<Connection> tmp = new LinkedHashSet<Connection>(this.knownConnections);
        tmp.removeAll(cons);
        for (Connection con : tmp) {
            this.removeConnection(con);
            this.knownConnections.remove(con);
        }
        tmp.clear();
        tmp.addAll(cons);
        tmp.removeAll(this.knownConnections);
        for (Connection con : tmp) {
            if (!this.buildConnection(con)) continue;
            this.knownConnections.add(con);
        }
        this.scene.validate();
    }

    void syncGraph(boolean sync) {
        this.syncGraph(sync, false);
    }

    void syncGraph(boolean sync, boolean updateSelection) {
        if (sync) {
            this.sync = true;
            this.scene.setAnimateChanges(false);
            this.syncChildren(updateSelection);
            this.syncConnections();
            this.scene.setAnimateChanges(true);
        } else {
            this.sync = false;
        }
    }

    private void updateWidgetComment(NodeWidget widget, String text, boolean container) {
        if (!container) {
            widget.setComment(text);
            return;
        }
        int delim = text.indexOf("\n\n");
        if (delim >= 0) {
            widget.setComment(text.substring(0, delim) + "...");
        } else {
            widget.setComment(text);
        }
        this.scene.revalidate();
    }

    private ComponentProxy findComponent(Widget widget) {
        if (widget == this.scene) {
            return this.container;
        }
        return this.findComponent(this.scene.findObject(widget));
    }

    private ComponentProxy findComponent(Object obj) {
        if (obj instanceof Widget) {
            return this.findComponent((Widget)obj);
        }
        if (obj instanceof String) {
            return this.container.getChild(obj.toString());
        }
        return null;
    }

    private void syncAllAttributes() {
        if (this.container == null) {
            return;
        }
        this.container.children().map(id -> this.container.getChild(id)).forEach(this::syncAttributes);
    }

    private void syncAttributes(ComponentProxy cmp) {
        this.ignoreAttributeChanges = true;
        Widget widget = this.scene.findWidget(cmp.getAddress().componentID());
        if (widget instanceof NodeWidget) {
            NodeWidget nodeWidget = (NodeWidget)widget;
            int x = (int)nodeWidget.getLocation().getX();
            int y = (int)nodeWidget.getLocation().getY();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Setting position attributes of {0} to x:{1} y:{2}", new Object[]{cmp.getAddress(), x, y});
            }
            Attributes.set((ComponentProxy)cmp, (String)ATTR_GRAPH_X, (Value)PNumber.of((int)x));
            Attributes.set((ComponentProxy)cmp, (String)ATTR_GRAPH_Y, (Value)PNumber.of((int)y));
            if (nodeWidget.isMinimized()) {
                Attributes.set((ComponentProxy)cmp, (String)ATTR_GRAPH_MINIMIZED, (Value)PBoolean.TRUE);
            } else {
                Attributes.clear((ComponentProxy)cmp, (String)ATTR_GRAPH_MINIMIZED);
            }
        }
        this.ignoreAttributeChanges = false;
    }

    void acceptComponentType(ComponentType type) {
        NotifyDescriptor.InputLine dlg = new NotifyDescriptor.InputLine("ID:", "Enter an ID for " + String.valueOf(type));
        dlg.setInputText(this.getFreeID(type));
        Object retval = DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg);
        if (retval == NotifyDescriptor.OK_OPTION) {
            String id = dlg.getInputText();
            this.container.addChild(id, type).thenRun(() -> this.syncGraph(true, true)).exceptionally(ex -> {
                this.syncGraph(true);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Error creating component", 0));
                return null;
            });
            this.syncGraph(false);
        }
    }

    void acceptImport(FileObject file) {
        Task task = ActionSupport.createImportTask((RootEditor)this, (ContainerProxy)this.container, (FileObject)file);
        task.addPropertyChangeListener(e -> {
            if (task.getState() == Task.State.ERROR) {
                List log = task.log();
                if (log.isEmpty()) {
                    String msg = "Import error";
                } else {
                    String msg = log.stream().collect(Collectors.joining("\n"));
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
                }
            }
        });
        task.execute();
    }

    private String getFreeID(ComponentType type) {
        Set existing = this.container.children().collect(Collectors.toSet());
        return EditorUtils.findFreeID(existing, (String)EditorUtils.extractBaseID((ComponentType)type), (boolean)true);
    }

    private class ConnectProviderImpl
    implements ConnectProvider {
        private ConnectProviderImpl() {
        }

        public boolean isSourceWidget(Widget sourceWidget) {
            return sourceWidget instanceof PinWidget;
        }

        public ConnectorState isTargetWidget(Widget sourceWidget, Widget targetWidget) {
            if (sourceWidget instanceof PinWidget && targetWidget instanceof PinWidget) {
                return ConnectorState.ACCEPT;
            }
            return ConnectorState.REJECT;
        }

        public boolean hasCustomTargetWidgetResolver(Scene scene) {
            return false;
        }

        public Widget resolveTargetWidget(Scene scene, Point sceneLocation) {
            return null;
        }

        public void createConnection(Widget sourceWidget, Widget targetWidget) {
            PinWidget pw1 = (PinWidget)sourceWidget;
            PinWidget pw2 = (PinWidget)targetWidget;
            if (pw1.getAlignment() == Alignment.Left || pw2.getAlignment() == Alignment.Right) {
                PinWidget tmp = pw2;
                pw2 = pw1;
                pw1 = tmp;
            }
            PinID p1 = (PinID)GraphEditor.this.scene.findObject(pw1);
            PinID p2 = (PinID)GraphEditor.this.scene.findObject(pw2);
            GraphEditor.this.container.connect(Connection.of((String)((String)p1.getParent()), (String)p1.getName(), (String)((String)p2.getParent()), (String)p2.getName()));
        }
    }

    private class MenuProviderImpl
    implements PopupMenuProvider {
        private MenuProviderImpl() {
        }

        public JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
            if (widget instanceof NodeWidget) {
                return GraphEditor.this.getComponentPopup((NodeWidget)widget);
            }
            if (widget instanceof EdgeWidget) {
                return GraphEditor.this.getConnectionPopup();
            }
            if (widget instanceof PinWidget) {
                return GraphEditor.this.getPinPopup((PinWidget)widget);
            }
            if (widget == GraphEditor.this.scene) {
                return GraphEditor.this.getScenePopup();
            }
            return null;
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
            super("Delete");
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DeleteAction.this.actionPerformed(e);
                    }
                });
                return;
            }
            assert (EventQueue.isDispatchThread());
            Set sel = GraphEditor.this.scene.getSelectedObjects();
            if (sel.isEmpty()) {
                return;
            }
            List<String> children = sel.stream().filter(String.class::isInstance).map(String.class::cast).toList();
            List<Connection> connections = sel.stream().filter(EdgeID.class::isInstance).map(o -> {
                EdgeID edge = (EdgeID)o;
                PinID p1 = edge.getPin1();
                PinID p2 = edge.getPin2();
                return Connection.of((String)p1.getParent().toString(), (String)p1.getName(), (String)p2.getParent().toString(), (String)p2.getName());
            }).toList();
            Task.run((Task)ActionSupport.createDeleteTask((RootEditor)GraphEditor.this, (ContainerProxy)GraphEditor.this.container, children, connections));
        }
    }

    private class SelectionListener
    extends ObjectSceneAdaptor
    implements PropertyChangeListener {
        private boolean ignoreChanges;

        private SelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void selectionChanged(ObjectSceneEvent event, Set<Object> previousSelection, Set<Object> newSelection) {
            for (Object obj : previousSelection) {
                String id;
                ComponentProxy cmp;
                if (newSelection.contains(obj) || !(obj instanceof String) || (cmp = GraphEditor.this.container.getChild(id = (String)obj)) == null) continue;
                GraphEditor.this.syncAttributes(cmp);
            }
            if (this.ignoreChanges) {
                return;
            }
            try {
                this.ignoreChanges = true;
                if (newSelection.isEmpty()) {
                    if (GraphEditor.this.container != null) {
                        GraphEditor.this.manager.setSelectedNodes(new Node[]{GraphEditor.this.container.getNodeDelegate()});
                    } else {
                        GraphEditor.this.manager.setSelectedNodes(new Node[]{GraphEditor.this.manager.getRootContext()});
                    }
                    GraphEditor.this.deleteAction.setEnabled(false);
                } else {
                    ArrayList<Node> sel = new ArrayList<Node>();
                    for (Object obj : newSelection) {
                        String id;
                        ComponentProxy cmp;
                        if (!(obj instanceof String) || (cmp = GraphEditor.this.container.getChild(id = (String)obj)) == null) continue;
                        sel.add(cmp.getNodeDelegate());
                        GraphEditor.this.syncAttributes(cmp);
                    }
                    if (sel.isEmpty()) {
                        GraphEditor.this.manager.setSelectedNodes(new Node[]{GraphEditor.this.manager.getRootContext()});
                    } else {
                        GraphEditor.this.manager.setSelectedNodes(sel.toArray(new Node[sel.size()]));
                    }
                    GraphEditor.this.deleteAction.setEnabled(true);
                }
            }
            catch (PropertyVetoException ex) {
                LOG.log(Level.FINEST, "Received PropertyVetoException trying to set selected nodes", ex);
            }
            finally {
                this.ignoreChanges = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.ignoreChanges) {
                return;
            }
            try {
                this.ignoreChanges = true;
                Node context = GraphEditor.this.manager.getExploredContext();
                Node[] selection = GraphEditor.this.manager.getSelectedNodes();
                ContainerProxy container = (ContainerProxy)context.getLookup().lookup(ContainerProxy.class);
                if (GraphEditor.this.container != container) {
                    if (GraphEditor.this.container != null) {
                        GraphEditor.this.clearScene();
                    }
                    GraphEditor.this.container = container;
                    if (container == null) {
                        return;
                    }
                    GraphEditor.this.buildScene();
                }
                Set selectedChildren = Stream.of(selection).map(n -> (ComponentProxy)n.getLookup().lookup(ComponentProxy.class)).filter(c -> c != null && c != container).map(c -> c.getID()).filter(id -> id != null).collect(Collectors.toCollection(LinkedHashSet::new));
                GraphEditor.this.scene.userSelectionSuggested(selectedChildren, false);
                if (!selectedChildren.isEmpty()) {
                    GraphEditor.this.scene.setFocusedObject(selectedChildren.iterator().next());
                } else {
                    GraphEditor.this.scene.setFocusedObject(null);
                }
                GraphEditor.this.deleteAction.setEnabled(!selectedChildren.isEmpty());
            }
            finally {
                this.ignoreChanges = false;
            }
        }
    }

    private class GoUpAction
    extends AbstractAction {
        private GoUpAction() {
            super("Go Up", ImageUtilities.loadImageIcon((String)"org/praxislive/ide/pxr/graph/resources/go-up.png", (boolean)true));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContainerProxy parent = GraphEditor.this.container.getParent();
            if (parent != null) {
                GraphEditor.this.clearScene();
                String childID = GraphEditor.this.container.getAddress().componentID();
                GraphEditor.this.container = parent;
                GraphEditor.this.buildScene();
                GraphEditor.this.scene.setSelectedObjects(Collections.singleton(childID));
                GraphEditor.this.scene.setFocusedObject(childID);
            }
        }
    }

    private class LocationAction
    extends AbstractAction
    implements Presenter.Toolbar {
        private final JLabel address = new JLabel();

        private LocationAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public Component getToolbarPresenter() {
            return this.address;
        }
    }

    private class ContainerListener
    implements PropertyChangeListener {
        private ContainerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (GraphEditor.this.sync) {
                if ("children".equals(evt.getPropertyName())) {
                    GraphEditor.this.syncChildren(false);
                } else if ("connections".equals(evt.getPropertyName())) {
                    GraphEditor.this.syncConnections();
                } else if ("meta".equals(evt.getPropertyName())) {
                    String comment = Attributes.get((ComponentProxy)GraphEditor.this.container, (String)GraphEditor.ATTR_GRAPH_COMMENT, (String)"");
                    if (!comment.equals(GraphEditor.this.scene.getComment())) {
                        GraphEditor.this.scene.setComment(comment);
                    }
                    GraphEditor.this.configureExposedSceneTools();
                    GraphEditor.this.scene.validate();
                }
            }
        }
    }

    private class ComponentListener
    implements PropertyChangeListener {
        private ComponentListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("info".equals(evt.getPropertyName())) {
                Object src = evt.getSource();
                assert (src instanceof ComponentProxy);
                if (src instanceof ComponentProxy) {
                    ComponentProxy cmp = (ComponentProxy)src;
                    String id = cmp.getAddress().componentID();
                    GraphEditor.this.rebuildChild(id, cmp);
                    GraphEditor.this.scene.validate();
                }
            } else if ("meta".equals(evt.getPropertyName()) && !GraphEditor.this.ignoreAttributeChanges) {
                ComponentProxy cmp;
                Widget w;
                Object src = evt.getSource();
                assert (src instanceof ComponentProxy);
                if (src instanceof ComponentProxy && (w = GraphEditor.this.scene.findWidget((cmp = (ComponentProxy)src).getAddress().componentID())) instanceof NodeWidget) {
                    NodeWidget node = (NodeWidget)w;
                    GraphEditor.this.configureWidgetFromAttributes(node, cmp);
                    GraphEditor.this.configureExposedTools(node, cmp);
                    GraphEditor.this.scene.validate();
                }
            }
        }
    }

    private class CommentAction
    extends AbstractAction {
        private final Widget widget;

        private CommentAction(Widget widget) {
            super("Comment...");
            this.widget = widget;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String comment = CommentAction.this.findInitialText(CommentAction.this.widget);
                    JTextArea editor = new JTextArea(comment);
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.add(new JScrollPane(editor));
                    panel.setPreferredSize(new Dimension(400, 300));
                    DialogDescriptor dlg = new DialogDescriptor((Object)panel, "Comment");
                    editor.selectAll();
                    editor.requestFocusInWindow();
                    Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg);
                    if (result != NotifyDescriptor.OK_OPTION) {
                        return;
                    }
                    comment = editor.getText();
                    if (CommentAction.this.widget == GraphEditor.this.scene) {
                        GraphEditor.this.scene.setComment(comment);
                        if (comment.isEmpty()) {
                            Attributes.clear((ComponentProxy)GraphEditor.this.container, (String)GraphEditor.ATTR_GRAPH_COMMENT);
                        } else {
                            Attributes.set((ComponentProxy)GraphEditor.this.container, (String)GraphEditor.ATTR_GRAPH_COMMENT, (String)comment);
                        }
                    } else if (CommentAction.this.widget instanceof NodeWidget) {
                        ComponentProxy cmp = GraphEditor.this.findComponent(CommentAction.this.widget);
                        GraphEditor.this.updateWidgetComment((NodeWidget)CommentAction.this.widget, comment, cmp instanceof ContainerProxy);
                        if (comment.isEmpty()) {
                            Attributes.clear((ComponentProxy)cmp, (String)GraphEditor.ATTR_GRAPH_COMMENT);
                        } else {
                            Attributes.set((ComponentProxy)cmp, (String)GraphEditor.ATTR_GRAPH_COMMENT, (String)comment);
                        }
                        for (Object obj : GraphEditor.this.scene.getSelectedObjects()) {
                            NodeWidget n;
                            ComponentProxy additional = GraphEditor.this.findComponent(obj);
                            if (additional == null || (n = (NodeWidget)GraphEditor.this.scene.findWidget(obj)) == CommentAction.this.widget) continue;
                            GraphEditor.this.updateWidgetComment(n, comment, cmp instanceof ContainerProxy);
                            if (comment.isEmpty()) {
                                Attributes.clear((ComponentProxy)additional, (String)GraphEditor.ATTR_GRAPH_COMMENT);
                                continue;
                            }
                            Attributes.set((ComponentProxy)additional, (String)GraphEditor.ATTR_GRAPH_COMMENT, (String)comment);
                        }
                    }
                    GraphEditor.this.scene.validate();
                }
            };
            EventQueue.invokeLater(runnable);
        }

        private String findInitialText(Widget widget) {
            ComponentProxy cmp = GraphEditor.this.findComponent(widget);
            if (cmp != null) {
                return Attributes.get((ComponentProxy)cmp, (String)GraphEditor.ATTR_GRAPH_COMMENT, (String)"");
            }
            return "";
        }
    }

    private class SelectPerformer
    extends AbstractAction {
        private final boolean select;

        private SelectPerformer(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Node context = GraphEditor.this.container.getNodeDelegate();
                Node[] selection = this.select ? context.getChildren().getNodes() : new Node[]{};
                GraphEditor.this.manager.setExploredContextAndSelection(context, selection);
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class ZoomPerformer
    extends AbstractAction {
        private final int direction;

        private ZoomPerformer(int direction) {
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.direction == 0) {
                GraphEditor.this.scene.setZoomFactor(1.0);
            } else if (this.direction > 0) {
                GraphEditor.this.scene.setZoomFactor(1.2 * GraphEditor.this.scene.getZoomFactor());
            } else {
                GraphEditor.this.scene.setZoomFactor(GraphEditor.this.scene.getZoomFactor() / 1.2);
            }
        }
    }

    private class AcceptProviderImpl
    implements AcceptProvider {
        private AcceptProviderImpl() {
        }

        public ConnectorState isAcceptable(Widget widget, Point point, Transferable transferable) {
            if (this.extractType(transferable) != null || this.extractFile(transferable) != null) {
                return ConnectorState.ACCEPT;
            }
            return ConnectorState.REJECT;
        }

        public void accept(Widget widget, Point point, Transferable transferable) {
            GraphEditor.this.activePoint.setLocation(point);
            ComponentType type = this.extractType(transferable);
            if (type != null) {
                EventQueue.invokeLater(() -> GraphEditor.this.acceptComponentType(type));
                return;
            }
            FileObject file = this.extractFile(transferable);
            if (file != null) {
                EventQueue.invokeLater(() -> GraphEditor.this.acceptImport(file));
            }
        }

        private ComponentType extractType(Transferable transferable) {
            ComponentType t;
            Node n = NodeTransfer.node((Transferable)transferable, (int)3);
            if (n != null && (t = (ComponentType)n.getLookup().lookup(ComponentType.class)) != null) {
                return t;
            }
            return null;
        }

        private FileObject extractFile(Transferable transferable) {
            FileObject dob;
            Node n = NodeTransfer.node((Transferable)transferable, (int)3);
            if (n != null && (dob = (FileObject)n.getLookup().lookup(FileObject.class)) != null) {
                return dob;
            }
            return null;
        }
    }

    private class ContainerOpenAction
    extends AbstractAction {
        private final ContainerProxy container;

        private ContainerOpenAction(ContainerProxy container) {
            super("Open");
            this.container = container;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphEditor.this.clearScene();
            GraphEditor.this.container = this.container;
            GraphEditor.this.buildScene();
        }
    }

    private class ActivePointListener
    extends MouseAdapter {
        private ActivePointListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.updateActivePoint(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.updateActivePoint(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.updateActivePoint(e);
        }

        private void updateActivePoint(MouseEvent e) {
            GraphEditor.this.activePoint.setLocation(GraphEditor.this.scene.convertViewToScene(e.getPoint()));
            LOG.log(Level.FINEST, "Updated active point : {0}", GraphEditor.this.activePoint);
        }
    }
}

