/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph;

import java.util.Locale;
import org.praxislive.ide.core.ui.api.TypeColor;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.model.ContainerProxy;
import org.praxislive.ide.pxr.graph.scene.LAFScheme;

class Utils {
    private Utils() {
    }

    static LAFScheme.Colors colorsForPortType(String type) {
        return LAFScheme.Colors.forTypeColor(Utils.typeColorForString(type, true));
    }

    static LAFScheme.Colors colorsForComponent(ComponentProxy cmp) {
        if (cmp instanceof ContainerProxy) {
            return LAFScheme.Colors.forTypeColor(TypeColor.Orange);
        }
        return LAFScheme.Colors.forTypeColor(Utils.typeColorForString(cmp.getType().toString(), false));
    }

    private static TypeColor typeColorForString(String string, boolean port) {
        String test = string.toLowerCase(Locale.ROOT);
        if (test.startsWith("audio")) {
            return TypeColor.Green;
        }
        if (test.startsWith("video")) {
            return TypeColor.Purple;
        }
        if (port) {
            if (test.startsWith("control")) {
                return TypeColor.Blue;
            }
            if (test.startsWith("ref")) {
                return TypeColor.Cyan;
            }
        } else {
            if (test.startsWith("core")) {
                return TypeColor.Blue;
            }
            if (test.startsWith("data")) {
                return TypeColor.Red;
            }
        }
        return TypeColor.Magenta;
    }
}

