/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.UIManager;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.PointShape;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.ImageUtilities;
import org.praxislive.ide.core.ui.api.TypeColor;
import org.praxislive.ide.pxr.graph.scene.CommentWidget;
import org.praxislive.ide.pxr.graph.scene.EdgeWidget;
import org.praxislive.ide.pxr.graph.scene.NodeWidget;
import org.praxislive.ide.pxr.graph.scene.PinWidget;
import org.praxislive.ide.pxr.graph.scene.ToolContainerWidget;

public final class LAFScheme {
    private static final boolean IS_DARK = UIManager.getBoolean("nb.dark.theme");
    public static final Color FOREGROUND = LAFScheme.findColor("praxis.graph.foreground", IS_DARK ? new Color(0xF2F2F2) : new Color(0x191919));
    public static final Color BACKGROUND = LAFScheme.findColor("praxis.graph.background", IS_DARK ? new Color(0x191919) : new Color(0xF0F0F0));
    public static final Color NODE_BACKGROUND = LAFScheme.findColor("praxis.graph.node.background", IS_DARK ? new Color(0x121212) : new Color(0xF7F7F7));
    public static final Colors DEFAULT_COLORS = Colors.TYPE_COLOR_MAP.get(TypeColor.Cyan);
    private static final Border BORDER_MINIMIZE = BorderFactory.createOpaqueBorder((int)2, (int)2, (int)2, (int)2);
    private final Font defaultFont;
    private final Font commentFont;
    private final Font toolsFont;
    private final Font pinFont;

    public LAFScheme() {
        Font font = UIManager.getFont("controlFont");
        if (font == null) {
            font = Font.decode(null);
        }
        this.defaultFont = font;
        this.pinFont = this.toolsFont = font.deriveFont(font.getSize2D() * 0.9f);
        this.commentFont = this.toolsFont.deriveFont(2);
    }

    protected Font getDefaultFont() {
        return this.defaultFont;
    }

    protected Font getPinFont() {
        return this.pinFont;
    }

    protected Font getCommentFont() {
        return this.commentFont;
    }

    protected Font getToolsFont() {
        return this.toolsFont;
    }

    protected void installUI(NodeWidget widget) {
        widget.setOpaque(false);
        widget.getHeader().setOpaque(false);
        widget.getMinimizeButton().setBorder(BORDER_MINIMIZE);
        this.updateUI(widget);
    }

    protected void updateUI(NodeWidget widget) {
        ObjectState state = widget.getState();
        Colors colors = widget.getSchemeColors();
        if (colors == null) {
            colors = DEFAULT_COLORS;
        }
        if (widget.isBelowLODThreshold()) {
            if (state.isSelected()) {
                if (state.isFocused()) {
                    widget.setBorder(colors.BORDER_SMALL_NODE_SELECTED_FOCUSED);
                } else {
                    widget.setBorder(colors.BORDER_SMALL_NODE_SELECTED);
                }
            } else if (state.isFocused()) {
                widget.setBorder(colors.BORDER_SMALL_NODE_FOCUSED);
            } else {
                widget.setBorder(colors.BORDER_SMALL_NODE);
            }
        } else if (state.isSelected()) {
            if (state.isFocused()) {
                widget.setBorder(colors.BORDER_NODE_SELECTED_FOCUSED);
            } else {
                widget.setBorder(colors.BORDER_NODE_SELECTED);
            }
        } else if (state.isFocused()) {
            widget.setBorder(colors.BORDER_NODE_FOCUSED);
        } else {
            widget.setBorder(colors.BORDER_NODE);
        }
        Widget header = widget.getHeader();
        header.setBorder(state.isSelected() || state.isHovered() ? colors.BORDER_HEADER_SELECTED : colors.BORDER_HEADER);
        Color auxFG = colors.COLOR_TEXT;
        CommentWidget comment = widget.getCommentWidget();
        comment.setForeground(auxFG);
        comment.setFont(this.commentFont);
        ToolContainerWidget tools = widget.getToolContainerWidget();
        tools.setForeground(auxFG);
        tools.setFont(this.toolsFont);
    }

    protected boolean isNodeMinimizeButtonOnRight(NodeWidget widget) {
        return false;
    }

    protected Image getMinimizeWidgetImage(NodeWidget widget) {
        return widget.isMinimized() ? ImageUtilities.loadImage((String)"org/praxislive/ide/pxr/graph/scene/resources/vmd-expand.png") : ImageUtilities.loadImage((String)"org/praxislive/ide/pxr/graph/scene/resources/vmd-collapse.png");
    }

    protected void installUI(EdgeWidget widget) {
        widget.setSourceAnchorShape(AnchorShape.NONE);
        widget.setTargetAnchorShape(AnchorShape.NONE);
        widget.setPaintControlPoints(true);
        widget.setForeground(FOREGROUND);
        this.updateUI(widget);
    }

    protected void updateUI(EdgeWidget widget) {
        ObjectState state = widget.getState();
        Colors colors = widget.getSchemeColors();
        if (colors == null) {
            colors = DEFAULT_COLORS;
        }
        if (state.isHovered() || state.isSelected()) {
            widget.setEndPointShape(PointShape.SQUARE_FILLED_BIG);
        } else {
            widget.setControlPointShape(PointShape.NONE);
            widget.setEndPointShape(PointShape.SQUARE_FILLED_SMALL);
        }
        if (state.isHovered() || state.isSelected()) {
            widget.bringToFront();
            widget.setForeground(colors.COLOR_SELECTED);
            widget.setStroke(new BasicStroke(4.0f));
        } else {
            widget.setForeground(colors.COLOR_SELECTED);
            widget.setStroke(new BasicStroke(2.0f));
        }
        widget.setControlPointCutDistance(5);
    }

    protected void installUI(PinWidget widget) {
        widget.setOpaque(false);
        widget.setFont(this.pinFont);
        this.updateUI(widget);
    }

    protected void updateUI(PinWidget widget) {
        ObjectState state = widget.getState();
        Colors colors = widget.getSchemeColors();
        if (colors == null) {
            colors = DEFAULT_COLORS;
        }
        widget.getPinNameWidget().setForeground(colors.COLOR_TEXT);
        if (state.isHovered()) {
            widget.setBorder(colors.BORDER_PIN_SELECTED);
        } else {
            widget.setBorder(colors.BORDER_PIN);
        }
    }

    protected int getAnchorGap() {
        return 8;
    }

    protected Color getBackgroundColor() {
        return BACKGROUND;
    }

    private static Color findColor(String uiKey, Color fallback) {
        Color color = UIManager.getColor(uiKey);
        return color == null ? fallback : color;
    }

    public static class Colors {
        private static final Map<TypeColor, Colors> TYPE_COLOR_MAP = Map.copyOf(Stream.of(TypeColor.values()).collect(Collectors.toMap(Function.identity(), Colors::new)));
        private final Color COLOR_SELECTED;
        private final Color COLOR_NORMAL;
        private final Color COLOR_TEXT;
        private final Border BORDER_NODE;
        private final Border BORDER_NODE_FOCUSED;
        private final Border BORDER_NODE_SELECTED;
        private final Border BORDER_NODE_SELECTED_FOCUSED;
        private final Border BORDER_HEADER;
        private final Border BORDER_HEADER_SELECTED;
        private final Border BORDER_SMALL_NODE;
        private final Border BORDER_SMALL_NODE_FOCUSED;
        private final Border BORDER_SMALL_NODE_SELECTED;
        private final Border BORDER_SMALL_NODE_SELECTED_FOCUSED;
        private final Border BORDER_PIN;
        private final Border BORDER_PIN_SELECTED;

        public Colors(TypeColor typeColor) {
            this.COLOR_SELECTED = typeColor.selection();
            this.COLOR_NORMAL = typeColor.shade();
            this.COLOR_TEXT = typeColor.text();
            this.BORDER_NODE = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createEmptyBorder((int)2), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)NODE_BACKGROUND, (Color)this.COLOR_NORMAL)});
            this.BORDER_NODE_FOCUSED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createResizeBorder((int)2, (Color)FOREGROUND, (boolean)true), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)NODE_BACKGROUND, (Color)this.COLOR_NORMAL)});
            this.BORDER_NODE_SELECTED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createEmptyBorder((int)2), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)NODE_BACKGROUND, (Color)this.COLOR_SELECTED)});
            this.BORDER_NODE_SELECTED_FOCUSED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createResizeBorder((int)2, (Color)FOREGROUND, (boolean)true), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)NODE_BACKGROUND, (Color)this.COLOR_SELECTED)});
            this.BORDER_HEADER = BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)4, (Color)this.COLOR_NORMAL, (Color)this.COLOR_NORMAL);
            this.BORDER_HEADER_SELECTED = BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)4, (Color)this.COLOR_SELECTED, (Color)this.COLOR_SELECTED);
            this.BORDER_SMALL_NODE = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createEmptyBorder((int)3), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)this.COLOR_NORMAL, null)});
            this.BORDER_SMALL_NODE_FOCUSED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createResizeBorder((int)3, (Color)FOREGROUND, (boolean)true), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)this.COLOR_NORMAL, null)});
            this.BORDER_SMALL_NODE_SELECTED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createEmptyBorder((int)3), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)this.COLOR_SELECTED, null)});
            this.BORDER_SMALL_NODE_SELECTED_FOCUSED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createResizeBorder((int)3, (Color)FOREGROUND, (boolean)true), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)this.COLOR_SELECTED, null)});
            this.BORDER_PIN = BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)4, null, null);
            this.BORDER_PIN_SELECTED = BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)4, null, (Color)this.COLOR_NORMAL);
        }

        public static Colors forTypeColor(TypeColor typeColor) {
            return TYPE_COLOR_MAP.getOrDefault(typeColor, DEFAULT_COLORS);
        }
    }
}

