/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;
import org.praxislive.ide.pxr.graph.scene.EdgeID;
import org.praxislive.ide.pxr.graph.scene.PinID;
import org.praxislive.ide.pxr.graph.scene.PraxisGraphScene;

class PraxisGraphLayout<N>
extends GraphLayout<N, EdgeID<N>> {
    public static final boolean TRACE = false;
    public static final boolean CHECK = false;
    public static final int SWEEP_ITERATIONS = 3;
    public static final int CROSSING_ITERATIONS = 3;
    public static final int DUMMY_WIDTH = 10;
    public static final int X_OFFSET = 30;
    public static final int LAYER_OFFSET = 40;
    private int dummyWidth = 10;
    private int yOffset;
    private int layerOffset;
    private int layerCount;
    private PraxisGraphScene<N> graph;
    private List<LayoutNode> nodes;
    private Collection<N> nodesSubset = null;
    private HashMap<N, LayoutNode> vertexToLayoutNode;
    private Set<EdgeID<N>> reversedLinks;
    private List<LayoutNode>[] layers;
    private boolean animate = false;
    private boolean invert = true;
    private Comparator<LayoutNode> crossingNodeComparator = new Comparator<LayoutNode>(this){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            float f = n1.crossingNumber - n2.crossingNumber;
            if (f < 0.0f) {
                return -1;
            }
            if (f > 0.0f) {
                return 1;
            }
            return 0;
        }
    };
    private final Comparator<LayoutNode> nodePositionComparator = new Comparator<LayoutNode>(this){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            int res = n1.pos - n2.pos;
            if (res == 0) {
                res = n1.toString().compareTo(n2.toString());
            }
            return res;
        }
    };
    private final Comparator<LayoutNode> nodeProcessingDownComparator = new Comparator<LayoutNode>(this){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            if (n1.vertex == null && n2.vertex == null) {
                int res = n1.toString().compareTo(n2.toString());
                return res;
            }
            if (n1.vertex == null) {
                return -1;
            }
            if (n2.vertex == null) {
                return 1;
            }
            int res = n1.preds.size() - n2.preds.size();
            if (res == 0 && !n1.preds.isEmpty()) {
                res = n1.toString().compareTo(n2.toString());
            }
            return res;
        }
    };
    private final Comparator<LayoutNode> nodeProcessingUpComparator = new Comparator<LayoutNode>(this){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            if (n1.vertex == null && n2.vertex == null) {
                int res = n1.toString().compareTo(n2.toString());
                return res;
            }
            if (n1.vertex == null) {
                return -1;
            }
            if (n2.vertex == null) {
                return 1;
            }
            int res = n1.succs.size() - n2.succs.size();
            if (res == 0) {
                res = n1.toString().compareTo(n2.toString());
            }
            return res;
        }
    };

    public PraxisGraphLayout(boolean animate, boolean inverted, int xOffset, int layerOffset) {
        this.animate = animate;
        this.yOffset = xOffset > 0 ? xOffset : 30;
        this.layerOffset = layerOffset > 0 ? layerOffset : 40;
        this.invert = inverted;
    }

    public PraxisGraphLayout(boolean animate, boolean inverted) {
        this(animate, inverted, 30, 40);
    }

    public PraxisGraphLayout(boolean animate) {
        this(animate, false);
    }

    public PraxisGraphLayout() {
        this(false);
    }

    protected void performGraphLayout(UniversalGraph<N, EdgeID<N>> graph) {
        this.graph = (PraxisGraphScene)graph.getScene();
        this.vertexToLayoutNode = new HashMap();
        this.reversedLinks = new HashSet<EdgeID<N>>();
        this.nodes = new ArrayList<LayoutNode>();
        new BuildDatastructure().start();
        new ReverseEdges().start();
        new AssignLayers().start();
        new CreateDummyNodes().start();
        new CrossingReduction().start();
        new AssignYCoordinates().start();
        new AssignXCoordinates().start();
        new WriteResult().start();
    }

    protected void performNodesLayout(UniversalGraph<N, EdgeID<N>> arg0, Collection<N> arg1) {
        this.nodesSubset = arg1;
        this.performGraphLayout(arg0);
    }

    private class BuildDatastructure
    extends AlgorithmPart {
        private BuildDatastructure() {
            super(PraxisGraphLayout.this);
        }

        @Override
        protected void run() {
            Collection vertices = PraxisGraphLayout.this.nodesSubset == null ? PraxisGraphLayout.this.graph.getNodes() : PraxisGraphLayout.this.nodesSubset;
            for (Object v : vertices) {
                LayoutNode node = new LayoutNode(PraxisGraphLayout.this);
                Widget w = PraxisGraphLayout.this.graph.findWidget(v);
                assert (w != null);
                Rectangle r = w.getBounds();
                if (r == null) {
                    r = w.getPreferredBounds();
                }
                Dimension size = r.getSize();
                node.width = (int)size.getWidth();
                node.height = (int)size.getHeight();
                node.vertex = v;
                PraxisGraphLayout.this.nodes.add(node);
                PraxisGraphLayout.this.vertexToLayoutNode.put(v, node);
            }
            Collection links = PraxisGraphLayout.this.graph.getEdges();
            for (EdgeID l : links) {
                LayoutEdge edge = new LayoutEdge(PraxisGraphLayout.this);
                assert (PraxisGraphLayout.this.vertexToLayoutNode.containsKey(((PinID)PraxisGraphLayout.this.graph.getEdgeSource(l)).getParent()));
                assert (PraxisGraphLayout.this.vertexToLayoutNode.containsKey(((PinID)PraxisGraphLayout.this.graph.getEdgeTarget(l)).getParent()));
                if (PraxisGraphLayout.this.invert) {
                    edge.to = PraxisGraphLayout.this.vertexToLayoutNode.get(((PinID)PraxisGraphLayout.this.graph.getEdgeSource(l)).getParent());
                    edge.from = PraxisGraphLayout.this.vertexToLayoutNode.get(((PinID)PraxisGraphLayout.this.graph.getEdgeTarget(l)).getParent());
                } else {
                    edge.from = PraxisGraphLayout.this.vertexToLayoutNode.get(((PinID)PraxisGraphLayout.this.graph.getEdgeSource(l)).getParent());
                    edge.to = PraxisGraphLayout.this.vertexToLayoutNode.get(((PinID)PraxisGraphLayout.this.graph.getEdgeTarget(l)).getParent());
                }
                Widget w = PraxisGraphLayout.this.graph.findWidget(((PinID)PraxisGraphLayout.this.graph.getEdgeSource(l)).getParent());
                assert (w != null);
                Rectangle r = w.getBounds();
                if (r == null) {
                    r = w.getPreferredBounds();
                }
                Dimension size = r.getSize();
                edge.relativeFrom = size.height / 2;
                edge.indexFrom = new ArrayList(PraxisGraphLayout.this.graph.getNodePins(((PinID)PraxisGraphLayout.this.graph.getEdgeSource(l)).getParent())).indexOf(PraxisGraphLayout.this.graph.getEdgeSource(l));
                w = PraxisGraphLayout.this.graph.findWidget(((PinID)PraxisGraphLayout.this.graph.getEdgeTarget(l)).getParent());
                assert (w != null);
                r = w.getBounds();
                if (r == null) {
                    r = w.getPreferredBounds();
                }
                size = r.getSize();
                edge.relativeTo = size.height / 2;
                edge.indexTo = new ArrayList(PraxisGraphLayout.this.graph.getNodePins(((PinID)PraxisGraphLayout.this.graph.getEdgeTarget(l)).getParent())).indexOf(PraxisGraphLayout.this.graph.getEdgeTarget(l));
                edge.link = l;
                edge.from.succs.add(edge);
                edge.to.preds.add(edge);
            }
        }

        @Override
        public void postCheck() {
            assert (PraxisGraphLayout.this.vertexToLayoutNode.keySet().size() == PraxisGraphLayout.this.nodes.size());
            assert (PraxisGraphLayout.this.nodes.size() == PraxisGraphLayout.this.graph.getNodes().size());
            for (Object v : PraxisGraphLayout.this.graph.getNodes()) {
                LayoutNode node = PraxisGraphLayout.this.vertexToLayoutNode.get(v);
                assert (node != null);
                for (LayoutEdge e : node.succs) {
                    assert (e.from == node);
                }
                for (LayoutEdge e : node.preds) {
                    assert (e.to == node);
                }
            }
        }
    }

    private class ReverseEdges
    extends AlgorithmPart {
        private HashSet<LayoutNode> visited;
        private HashSet<LayoutNode> active;

        private ReverseEdges() {
            super(PraxisGraphLayout.this);
        }

        @Override
        protected void run() {
            for (LayoutNode node : PraxisGraphLayout.this.nodes) {
                ArrayList<LayoutEdge> succs = new ArrayList<LayoutEdge>(node.succs);
                for (LayoutEdge e : succs) {
                    assert (e.from == node);
                    if (e.to != node) continue;
                    node.succs.remove(e);
                    node.preds.remove(e);
                }
            }
            this.visited = new HashSet();
            this.active = new HashSet();
            for (LayoutNode node : PraxisGraphLayout.this.nodes) {
                this.DFS(node);
            }
        }

        private void DFS(LayoutNode startNode) {
            if (this.visited.contains(startNode)) {
                return;
            }
            Stack<LayoutNode> stack = new Stack<LayoutNode>();
            stack.push(startNode);
            while (!stack.empty()) {
                LayoutNode node = (LayoutNode)stack.pop();
                if (this.visited.contains(node)) {
                    this.active.remove(node);
                    continue;
                }
                stack.push(node);
                this.visited.add(node);
                this.active.add(node);
                ArrayList<LayoutEdge> succs = new ArrayList<LayoutEdge>(node.succs);
                for (LayoutEdge e : succs) {
                    if (this.active.contains(e.to)) {
                        assert (this.visited.contains(e.to));
                        this.reverseEdge(e);
                        continue;
                    }
                    if (this.visited.contains(e.to)) continue;
                    stack.push(e.to);
                }
            }
        }

        private void reverseAllInputs(LayoutNode node) {
            for (LayoutEdge e : node.preds) {
                assert (!PraxisGraphLayout.this.reversedLinks.contains(e.link));
                PraxisGraphLayout.this.reversedLinks.add(e.link);
                node.succs.add(e);
                e.from.preds.add(e);
                e.from.succs.remove(e);
                int oldRelativeFrom = e.relativeFrom;
                int oldRelativeTo = e.relativeTo;
                e.to = e.from;
                e.from = node;
                e.relativeFrom = oldRelativeTo;
                e.relativeTo = oldRelativeFrom;
            }
            node.preds.clear();
        }

        private void reverseEdge(LayoutEdge e) {
            assert (!PraxisGraphLayout.this.reversedLinks.contains(e.link));
            PraxisGraphLayout.this.reversedLinks.add(e.link);
            LayoutNode oldFrom = e.from;
            LayoutNode oldTo = e.to;
            int oldRelativeFrom = e.relativeFrom;
            int oldRelativeTo = e.relativeTo;
            e.from = oldTo;
            e.to = oldFrom;
            e.relativeFrom = oldRelativeTo;
            e.relativeTo = oldRelativeFrom;
            oldFrom.succs.remove(e);
            oldFrom.preds.add(e);
            oldTo.preds.remove(e);
            oldTo.succs.add(e);
        }

        @Override
        public void postCheck() {
            for (LayoutNode n : PraxisGraphLayout.this.nodes) {
                LinkedList<LayoutNode> queue = new LinkedList<LayoutNode>();
                for (LayoutEdge e : n.succs) {
                    LayoutNode s = e.to;
                    queue.add(s);
                    this.visited.add(s);
                }
                HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
                while (!queue.isEmpty()) {
                    LayoutNode curNode = (LayoutNode)queue.remove();
                    for (LayoutEdge e : curNode.succs) {
                        assert (e.to != n);
                        if (visited.contains(e.to)) continue;
                        queue.add(e.to);
                        visited.add(e.to);
                    }
                }
            }
        }
    }

    private class AssignLayers
    extends AlgorithmPart {
        private AssignLayers() {
            super(PraxisGraphLayout.this);
        }

        @Override
        public void preCheck() {
            for (LayoutNode n : PraxisGraphLayout.this.nodes) {
                assert (n.layer == -1);
            }
        }

        @Override
        protected void run() {
            HashSet<LayoutNode> set = new HashSet<LayoutNode>();
            for (LayoutNode n : PraxisGraphLayout.this.nodes) {
                if (n.preds.size() != 0) continue;
                set.add(n);
                n.layer = 0;
            }
            int z = 1;
            HashSet<Object> newSet = new HashSet();
            HashSet<LayoutNode> failed = new HashSet<LayoutNode>();
            while (!set.isEmpty()) {
                newSet.clear();
                failed.clear();
                for (LayoutNode layoutNode : set) {
                    for (LayoutEdge se : layoutNode.succs) {
                        LayoutNode s = se.to;
                        if (newSet.contains(s) || failed.contains(s)) continue;
                        boolean ok = true;
                        for (LayoutEdge pe : s.preds) {
                            LayoutNode p = pe.from;
                            if (p.layer != -1) continue;
                            ok = false;
                            break;
                        }
                        if (ok) {
                            newSet.add(s);
                            continue;
                        }
                        failed.add(s);
                    }
                }
                for (LayoutNode layoutNode : newSet) {
                    layoutNode.layer = z;
                }
                HashSet<LayoutNode> tmp = set;
                set = newSet;
                newSet = tmp;
                ++z;
            }
            this.optimize(set);
            PraxisGraphLayout.this.layerCount = z - 1;
        }

        public void optimize(HashSet<LayoutNode> set) {
            for (LayoutNode n : set) {
                if (n.preds.size() != 0 || n.succs.size() <= 0) continue;
                int minLayer = n.succs.get((int)0).to.layer;
                for (LayoutEdge e : n.succs) {
                    minLayer = Math.min(minLayer, e.to.layer);
                }
                n.layer = minLayer - 1;
            }
        }

        @Override
        public void printStatistics() {
        }

        @Override
        public void postCheck() {
            for (LayoutNode n : PraxisGraphLayout.this.nodes) {
                assert (n.layer >= 0);
                assert (n.layer < PraxisGraphLayout.this.layerCount);
                for (LayoutEdge e : n.succs) {
                    assert (e.from.layer < e.to.layer);
                }
            }
        }
    }

    private class CreateDummyNodes
    extends AlgorithmPart {
        private int oldNodeCount;

        private CreateDummyNodes() {
            super(PraxisGraphLayout.this);
        }

        @Override
        protected void preCheck() {
            for (LayoutNode n : PraxisGraphLayout.this.nodes) {
                for (LayoutEdge e : n.succs) {
                    assert (e.from != null);
                    assert (e.from == n);
                    assert (e.from.layer < e.to.layer);
                }
                for (LayoutEdge e : n.preds) {
                    assert (e.to != null);
                    assert (e.to == n);
                }
            }
        }

        @Override
        protected void run() {
            this.oldNodeCount = PraxisGraphLayout.this.nodes.size();
            ArrayList<LayoutNode> currentNodes = new ArrayList<LayoutNode>(PraxisGraphLayout.this.nodes);
            for (LayoutNode n : currentNodes) {
                for (LayoutEdge e : n.succs) {
                    this.processSingleEdge(e);
                }
            }
        }

        private void processSingleEdge(LayoutEdge e) {
            LayoutNode n = e.from;
            if (e.to.layer > n.layer + 1) {
                LayoutEdge last = e;
                for (int i = n.layer + 1; i < last.to.layer; ++i) {
                    last = this.addBetween(last, i);
                }
            }
        }

        private LayoutEdge addBetween(LayoutEdge e, int layer) {
            LayoutNode n = new LayoutNode(PraxisGraphLayout.this);
            n.width = 0;
            n.height = PraxisGraphLayout.this.dummyWidth;
            n.layer = layer;
            n.preds.add(e);
            PraxisGraphLayout.this.nodes.add(n);
            LayoutEdge result = new LayoutEdge(PraxisGraphLayout.this);
            n.succs.add(result);
            result.from = n;
            result.relativeFrom = n.height / 2;
            result.to = e.to;
            result.relativeTo = e.relativeTo;
            e.relativeTo = n.height / 2;
            e.to.preds.remove(e);
            e.to.preds.add(result);
            e.to = n;
            return result;
        }

        @Override
        public void printStatistics() {
            System.out.println("Dummy nodes created: " + (PraxisGraphLayout.this.nodes.size() - this.oldNodeCount));
        }

        @Override
        public void postCheck() {
            ArrayList<LayoutNode> currentNodes = new ArrayList<LayoutNode>(PraxisGraphLayout.this.nodes);
            for (LayoutNode n : currentNodes) {
                for (LayoutEdge e : n.succs) {
                    assert (e.from.layer == e.to.layer - 1);
                }
            }
            for (int i = 0; i < PraxisGraphLayout.this.layers.length; ++i) {
                assert (PraxisGraphLayout.this.layers[i].size() > 0);
                for (LayoutNode n : PraxisGraphLayout.this.layers[i]) {
                    assert (n.layer == i);
                }
            }
        }
    }

    private class CrossingReduction
    extends AlgorithmPart {
        private CrossingReduction() {
            super(PraxisGraphLayout.this);
        }

        @Override
        public void preCheck() {
            for (LayoutNode n : PraxisGraphLayout.this.nodes) {
                assert (n.layer < PraxisGraphLayout.this.layerCount);
            }
        }

        @Override
        protected void run() {
            int i;
            PraxisGraphLayout.this.layers = new List[PraxisGraphLayout.this.layerCount];
            for (int i2 = 0; i2 < PraxisGraphLayout.this.layerCount; ++i2) {
                PraxisGraphLayout.this.layers[i2] = new ArrayList<LayoutNode>();
            }
            HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
            for (LayoutNode n : PraxisGraphLayout.this.nodes) {
                if (n.layer == 0) {
                    PraxisGraphLayout.this.layers[0].add(n);
                    visited.add(n);
                    continue;
                }
                if (n.preds.size() != 0) continue;
                PraxisGraphLayout.this.layers[n.layer].add(n);
                visited.add(n);
            }
            for (i = 0; i < PraxisGraphLayout.this.layers.length - 1; ++i) {
                for (LayoutNode n : PraxisGraphLayout.this.layers[i]) {
                    for (LayoutEdge e : n.succs) {
                        if (visited.contains(e.to)) continue;
                        visited.add(e.to);
                        PraxisGraphLayout.this.layers[i + 1].add(e.to);
                    }
                }
            }
            this.updatePositions();
            for (i = 0; i < 3; ++i) {
                this.upSweep();
                this.downSweep();
            }
        }

        private void updatePositions() {
            for (int i = 0; i < PraxisGraphLayout.this.layers.length; ++i) {
                int z = 0;
                for (LayoutNode n : PraxisGraphLayout.this.layers[i]) {
                    n.pos = z++;
                }
            }
        }

        private void downSweep() {
            for (int i = 1; i < PraxisGraphLayout.this.layerCount; ++i) {
                for (LayoutNode n : PraxisGraphLayout.this.layers[i]) {
                    float sum = 0.0f;
                    for (LayoutEdge e : n.preds) {
                        float cur = e.from.pos;
                        if (e.from.height != 0 && e.relativeFrom != 0) {
                            cur += (float)e.relativeFrom / (float)e.from.height;
                        }
                        sum += cur;
                    }
                    if (n.preds.size() > 0) {
                        n.crossingNumber = sum /= (float)n.preds.size();
                        continue;
                    }
                    n.crossingNumber = 2.1474836E9f;
                }
                Collections.sort(PraxisGraphLayout.this.layers[i], PraxisGraphLayout.this.crossingNodeComparator);
                int z = 0;
                for (LayoutNode n : PraxisGraphLayout.this.layers[i]) {
                    n.pos = z++;
                }
            }
        }

        private void upSweep() {
            for (int i = PraxisGraphLayout.this.layerCount - 1; i >= 0; --i) {
                for (LayoutNode n : PraxisGraphLayout.this.layers[i]) {
                    float sum = 0.0f;
                    for (LayoutEdge e : n.succs) {
                        float cur = e.to.pos;
                        if (e.to.height != 0 && e.relativeTo != 0) {
                            cur += ((float)e.relativeTo - (float)(e.indexTo * 20)) / (float)e.to.height;
                        }
                        sum += cur;
                    }
                    if (n.succs.size() > 0) {
                        n.crossingNumber = sum /= (float)n.succs.size();
                        continue;
                    }
                    n.crossingNumber = 2.1474836E9f;
                }
                Collections.sort(PraxisGraphLayout.this.layers[i], PraxisGraphLayout.this.crossingNodeComparator);
                int z = 0;
                for (LayoutNode n : PraxisGraphLayout.this.layers[i]) {
                    n.pos = z++;
                }
            }
        }

        private int evaluate() {
            return 0;
        }

        @Override
        public void postCheck() {
            HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
            for (int i = 0; i < PraxisGraphLayout.this.layers.length; ++i) {
                for (LayoutNode n : PraxisGraphLayout.this.layers[i]) {
                    assert (!visited.contains(n));
                    assert (n.layer == i);
                    visited.add(n);
                }
            }
        }
    }

    private class AssignYCoordinates
    extends AlgorithmPart {
        private ArrayList<Integer>[] space;
        private ArrayList<LayoutNode>[] downProcessingOrder;
        private ArrayList<LayoutNode>[] upProcessingOrder;

        private AssignYCoordinates() {
            super(PraxisGraphLayout.this);
        }

        private void initialPositions() {
            for (LayoutNode n : PraxisGraphLayout.this.nodes) {
                n.y = this.space[n.layer].get(n.pos);
            }
        }

        @Override
        protected void run() {
            int i;
            this.space = new ArrayList[PraxisGraphLayout.this.layers.length];
            this.downProcessingOrder = new ArrayList[PraxisGraphLayout.this.layers.length];
            this.upProcessingOrder = new ArrayList[PraxisGraphLayout.this.layers.length];
            for (i = 0; i < PraxisGraphLayout.this.layers.length; ++i) {
                this.space[i] = new ArrayList();
                this.downProcessingOrder[i] = new ArrayList();
                this.upProcessingOrder[i] = new ArrayList();
                int curY = 0;
                for (LayoutNode n : PraxisGraphLayout.this.layers[i]) {
                    this.space[i].add(curY);
                    curY += n.height + PraxisGraphLayout.this.yOffset;
                    this.downProcessingOrder[i].add(n);
                    this.upProcessingOrder[i].add(n);
                }
                Collections.sort(this.downProcessingOrder[i], PraxisGraphLayout.this.nodeProcessingDownComparator);
                Collections.sort(this.upProcessingOrder[i], PraxisGraphLayout.this.nodeProcessingUpComparator);
            }
            this.initialPositions();
            for (i = 0; i < 3; ++i) {
            }
        }

        private int calculateOptimalDown(LayoutNode n) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            if (n.preds.size() == 0) {
                return n.y;
            }
            for (LayoutEdge e : n.preds) {
                int cur = e.from.y + e.relativeFrom - e.relativeTo;
                values.add(cur);
            }
            return this.median(values);
        }

        private int calculateOptimalUp(LayoutNode n) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            if (n.succs.size() == 0) {
                return n.y;
            }
            for (LayoutEdge e : n.succs) {
                int cur = e.to.y + e.relativeTo - e.relativeFrom;
                values.add(cur);
            }
            return this.median(values);
        }

        private int median(List<Integer> values) {
            Collections.sort(values);
            if (values.size() % 2 == 0) {
                return (values.get(values.size() / 2 - 1) + values.get(values.size() / 2)) / 2;
            }
            return values.get(values.size() / 2);
        }

        private void sweepUp() {
            for (int i = PraxisGraphLayout.this.layers.length - 2; i >= 0; --i) {
                NodeColumn r = new NodeColumn(PraxisGraphLayout.this, this.space[i]);
                for (LayoutNode n : this.upProcessingOrder[i]) {
                    int optimal = this.calculateOptimalUp(n);
                    r.insert(n, optimal);
                }
            }
        }

        private void sweepDown() {
            for (int i = 1; i < PraxisGraphLayout.this.layers.length; ++i) {
                NodeColumn r = new NodeColumn(PraxisGraphLayout.this, this.space[i]);
                for (LayoutNode n : this.downProcessingOrder[i]) {
                    int optimal = this.calculateOptimalDown(n);
                    r.insert(n, optimal);
                }
            }
        }
    }

    private class AssignXCoordinates
    extends AlgorithmPart {
        private AssignXCoordinates() {
            super(PraxisGraphLayout.this);
        }

        @Override
        protected void run() {
            int curX = 0;
            for (int i = 0; i < PraxisGraphLayout.this.layers.length; ++i) {
                int maxWidth = 0;
                int baseLine = 0;
                int bottomBaseLine = 0;
                for (LayoutNode n : PraxisGraphLayout.this.layers[i]) {
                    maxWidth = Math.max(maxWidth, n.width - n.xOffset - n.bottomYOffset);
                    baseLine = Math.max(baseLine, n.xOffset);
                }
                for (LayoutNode n : PraxisGraphLayout.this.layers[i]) {
                    if (n.vertex == null) {
                        n.x = curX;
                        n.width = maxWidth + baseLine + bottomBaseLine;
                        continue;
                    }
                    n.x = curX + baseLine + (maxWidth - (n.width - n.xOffset - n.bottomYOffset)) / 2 - n.xOffset;
                }
                curX += maxWidth + baseLine + bottomBaseLine;
                curX += PraxisGraphLayout.this.layerOffset;
            }
        }
    }

    private class WriteResult
    extends AlgorithmPart {
        private int pointCount;

        private WriteResult() {
            super(PraxisGraphLayout.this);
        }

        @Override
        protected void run() {
            Point p;
            HashMap vertexPositions = new HashMap();
            HashMap linkPositions = new HashMap();
            for (Object v : PraxisGraphLayout.this.graph.getNodes()) {
                LayoutNode n = PraxisGraphLayout.this.vertexToLayoutNode.get(v);
                assert (!vertexPositions.containsKey(v));
                vertexPositions.put(v, new Point(n.x + n.xOffset, n.y + n.yOffset));
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            for (Object v : vertexPositions.keySet()) {
                p = (Point)vertexPositions.get(v);
                minX = Math.min(minX, p.x);
                minY = Math.min(minY, p.y);
            }
            for (Object v : vertexPositions.keySet()) {
                p = (Point)vertexPositions.get(v);
                p.x -= minX;
                p.y -= minY;
                p.x += 50;
                p.y += 50;
                Widget w = PraxisGraphLayout.this.graph.findWidget(v);
                if (PraxisGraphLayout.this.animate) {
                    PraxisGraphLayout.this.graph.getSceneAnimator().animatePreferredLocation(w, p);
                    continue;
                }
                w.setPreferredLocation(p);
            }
            PraxisGraphLayout.this.graph.getScene().validate();
            PraxisGraphLayout.this.graph.getScene().repaint();
            PraxisGraphLayout.this.graph.getScene().revalidate();
        }

        @Override
        protected void printStatistics() {
            System.out.println("Number of nodes: " + PraxisGraphLayout.this.nodes.size());
            int edgeCount = 0;
            for (LayoutNode n : PraxisGraphLayout.this.nodes) {
                edgeCount += n.succs.size();
            }
            System.out.println("Number of edges: " + edgeCount);
            System.out.println("Number of points: " + this.pointCount);
        }
    }

    private class NodeColumn {
        private TreeSet<LayoutNode> treeSet;
        private ArrayList<Integer> space;

        public NodeColumn(PraxisGraphLayout praxisGraphLayout, ArrayList<Integer> space) {
            this.treeSet = new TreeSet<LayoutNode>(praxisGraphLayout.nodePositionComparator);
            this.space = space;
        }

        public int offset(LayoutNode n1, LayoutNode n2) {
            int v1 = this.space.get(n1.pos) + n1.height;
            int v2 = this.space.get(n2.pos);
            return v2 - v1;
        }

        public void insert(LayoutNode n, int pos) {
            SortedSet<LayoutNode> headSet = this.treeSet.headSet(n);
            SortedSet<LayoutNode> tailSet = this.treeSet.tailSet(n);
            LayoutNode topNeighbour = null;
            int minY = Integer.MIN_VALUE;
            if (!headSet.isEmpty()) {
                topNeighbour = headSet.last();
                minY = topNeighbour.y + topNeighbour.height + this.offset(topNeighbour, n);
            }
            LayoutNode bottomNeighbour = null;
            int maxY = Integer.MAX_VALUE;
            if (!tailSet.isEmpty()) {
                bottomNeighbour = tailSet.first();
                maxY = bottomNeighbour.y - this.offset(n, bottomNeighbour) - n.height;
            }
            assert (minY <= maxY);
            if (pos >= minY && pos <= maxY) {
                n.y = pos;
            } else if (Math.abs((long)pos - (long)minY) < Math.abs((long)pos - (long)maxY)) {
                assert (minY != Integer.MIN_VALUE);
                n.y = minY;
            } else {
                assert (maxY != Integer.MAX_VALUE);
                n.y = maxY;
            }
            this.treeSet.add(n);
        }
    }

    private abstract class AlgorithmPart {
        private AlgorithmPart(PraxisGraphLayout praxisGraphLayout) {
        }

        public void start() {
            long start = 0L;
            this.run();
        }

        protected abstract void run();

        protected void printStatistics() {
        }

        protected void postCheck() {
        }

        protected void preCheck() {
        }
    }

    private class LayoutEdge {
        public LayoutNode from;
        public LayoutNode to;
        public int relativeFrom;
        public int relativeTo;
        public EdgeID<N> link;
        private int indexFrom;
        private int indexTo;

        private LayoutEdge(PraxisGraphLayout praxisGraphLayout) {
        }
    }

    private class LayoutNode {
        public int x;
        public int y;
        public int width;
        public int height;
        public int layer = -1;
        public int xOffset;
        public int yOffset;
        public int bottomYOffset;
        public N vertex;
        public List<LayoutEdge> preds = new ArrayList<LayoutEdge>();
        public List<LayoutEdge> succs = new ArrayList<LayoutEdge>();
        public int pos = -1;
        public float crossingNumber;

        private LayoutNode(PraxisGraphLayout praxisGraphLayout) {
        }

        public String toString() {
            return "Node " + String.valueOf(this.vertex);
        }
    }
}

