/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.praxislive.core.PortAddress;
import org.praxislive.core.Value;
import org.praxislive.core.types.PMap;
import org.praxislive.ide.model.ContainerProxy;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.graph.Bundle;
import org.praxislive.ide.pxr.graph.GraphEditor;
import org.praxislive.ide.pxr.graph.scene.PinID;

class AddPortToParentAction
extends AbstractAction {
    private final GraphEditor editor;
    private final PinID<String> pin;

    AddPortToParentAction(GraphEditor editor, PinID<String> pin) {
        super(Bundle.LBL_addPortToParent());
        this.editor = editor;
        this.pin = pin;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        EventQueue.invokeLater(this::addPortToParent);
    }

    private void addPortToParent() {
        Object suggestedID;
        PraxisProperty<Value> portProp = this.findPortsProperty();
        if (portProp == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_noPortsProperty(), 0));
            return;
        }
        PMap ports = PMap.from((Value)portProp.getValue()).orElse(PMap.EMPTY);
        if (ports.get((String)(suggestedID = this.pin.getParent() + "-" + this.pin.getName())) != null) {
            suggestedID = "";
        }
        NotifyDescriptor.InputLine dlg = new NotifyDescriptor.InputLine("ID:", Bundle.LBL_enterPortID());
        dlg.setInputText((String)suggestedID);
        Object retval = DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg);
        if (retval == NotifyDescriptor.OK_OPTION) {
            String id = dlg.getInputText();
            if (!PortAddress.isValidID((String)id)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_invalidPortID(), 0));
                return;
            }
            if (ports.get(id) != null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_existingPortID(), 0));
                return;
            }
            PMap.Builder bld = PMap.builder();
            for (String key : ports.keys()) {
                bld.put(key, ports.get(key));
            }
            bld.put(id, this.pin.getParent() + "!" + this.pin.getName());
            portProp.setValue((Value)bld.build());
        }
    }

    private PraxisProperty<Value> findPortsProperty() {
        ContainerProxy container = this.editor.getContainer();
        for (Node.PropertySet props : container.getNodeDelegate().getPropertySets()) {
            for (Node.Property prop : props.getProperties()) {
                if (!"ports".equals(prop.getName()) || !(prop instanceof PraxisProperty)) continue;
                return (PraxisProperty)prop;
            }
        }
        return null;
    }
}

