/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EnumSet;
import java.util.List;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.praxislive.ide.pxr.graph.JSuggestField;
import org.praxislive.ide.pxr.graph.SuggestFieldInplaceEditor;

final class SuggestFieldInplaceEditorProvider
implements InplaceEditorProvider<JSuggestField> {
    private SuggestFieldInplaceEditor editor;
    private EnumSet<InplaceEditorProvider.ExpansionDirection> expansionDirections;
    private KeyListener keyListener;
    private FocusListener focusListener;
    private DocumentListener documentListener;

    public SuggestFieldInplaceEditorProvider(SuggestFieldInplaceEditor editor) {
        this(editor, null);
    }

    SuggestFieldInplaceEditorProvider(SuggestFieldInplaceEditor editor, EnumSet<InplaceEditorProvider.ExpansionDirection> expansionDirections) {
        this.editor = editor;
        this.expansionDirections = expansionDirections;
    }

    public JSuggestField createEditorComponent(InplaceEditorProvider.EditorController controller, Widget widget) {
        if (!this.editor.isEnabled(widget)) {
            return null;
        }
        JSuggestField field = new JSuggestField();
        List<String> suggestedValues = this.editor.getSuggestedValues(widget);
        if (suggestedValues != null && !suggestedValues.isEmpty()) {
            field.setSuggestData(new Vector<String>(suggestedValues));
            field.showSuggest();
        } else {
            field.setText(this.editor.getText(widget));
            field.selectAll();
        }
        Scene scene = widget.getScene();
        double zoomFactor = scene.getZoomFactor();
        if (zoomFactor > 1.0) {
            Font font = scene.getDefaultFont();
            font = font.deriveFont((float)((double)font.getSize2D() * zoomFactor));
            field.setFont(font);
        }
        return field;
    }

    public void notifyOpened(final InplaceEditorProvider.EditorController controller, Widget widget, JSuggestField editor) {
        editor.setMinimumSize(new Dimension(64, 19));
        this.keyListener = new KeyAdapter(this){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case '\u001b': {
                        e.consume();
                        controller.closeEditor(false);
                        break;
                    }
                    case '\n': {
                        e.consume();
                        controller.closeEditor(true);
                    }
                }
            }
        };
        this.focusListener = new FocusAdapter(this){

            @Override
            public void focusLost(FocusEvent e) {
                controller.closeEditor(true);
            }
        };
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                controller.notifyEditorComponentBoundsChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                controller.notifyEditorComponentBoundsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                controller.notifyEditorComponentBoundsChanged();
            }
        };
        editor.addKeyListener(this.keyListener);
        editor.addFocusListener(this.focusListener);
        editor.getDocument().addDocumentListener(this.documentListener);
    }

    public void notifyClosing(InplaceEditorProvider.EditorController controller, Widget widget, JSuggestField editor, boolean commit) {
        editor.getDocument().removeDocumentListener(this.documentListener);
        editor.removeFocusListener(this.focusListener);
        editor.removeKeyListener(this.keyListener);
        if (commit) {
            this.editor.setText(widget, editor.getText());
            if (widget != null) {
                widget.getScene().validate();
            }
        }
    }

    public Rectangle getInitialEditorComponentBounds(InplaceEditorProvider.EditorController controller, Widget widget, JSuggestField editor, Rectangle viewBounds) {
        return null;
    }

    public EnumSet<InplaceEditorProvider.ExpansionDirection> getExpansionDirections(InplaceEditorProvider.EditorController controller, Widget widget, JSuggestField editor) {
        return this.expansionDirections;
    }
}

