/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.praxislive.ide.pxr.graph.scene.CommentWidget;
import org.praxislive.ide.pxr.graph.scene.GlyphSetWidget;
import org.praxislive.ide.pxr.graph.scene.LAFScheme;
import org.praxislive.ide.pxr.graph.scene.MinimizeAbility;
import org.praxislive.ide.pxr.graph.scene.PinWidget;
import org.praxislive.ide.pxr.graph.scene.PraxisGraphScene;
import org.praxislive.ide.pxr.graph.scene.ToolContainerWidget;

public class NodeWidget
extends Widget
implements StateModel.Listener,
MinimizeAbility {
    private final Widget header;
    private final ImageWidget minimizeWidget;
    private final ImageWidget imageWidget;
    private final LabelWidget nameWidget;
    private final GlyphSetWidget glyphSetWidget;
    private final StateModel stateModel;
    private final LAFScheme scheme;
    private final PraxisGraphScene scene;
    private final SceneListenerImpl sceneListener;
    private final CommentWidget commentWidget;
    private final ToolContainerWidget toolsWidget;
    private LAFScheme.Colors schemeColors;

    NodeWidget(PraxisGraphScene<?> scene) {
        super(scene);
        this.scene = scene;
        this.sceneListener = new SceneListenerImpl();
        this.scheme = scene.getLookAndFeel();
        this.stateModel = new StateModel();
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.setMinimumSize(new Dimension(100, 10));
        this.header = new Widget(scene);
        this.header.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)8));
        this.addChild(this.header);
        this.minimizeWidget = new ImageWidget(scene, this.scheme.getMinimizeWidgetImage(this));
        this.minimizeWidget.setCursor(Cursor.getPredefinedCursor(12));
        this.minimizeWidget.getActions().addAction((WidgetAction)new ToggleMinimizedAction());
        this.header.addChild((Widget)this.minimizeWidget);
        this.imageWidget = new ImageWidget(scene);
        this.header.addChild((Widget)this.imageWidget);
        this.nameWidget = new LabelWidget(scene);
        this.nameWidget.setForeground(Color.BLACK);
        this.header.addChild((Widget)this.nameWidget);
        this.glyphSetWidget = new GlyphSetWidget((Scene)scene);
        this.glyphSetWidget.setMinimumSize(new Dimension(16, 16));
        this.header.addChild((Widget)this.glyphSetWidget);
        this.stateModel.addListener((StateModel.Listener)this);
        this.commentWidget = new CommentWidget(scene);
        this.commentWidget.setVisible(false);
        this.toolsWidget = new ToolContainerWidget(scene);
        this.toolsWidget.setVisible(false);
        this.scheme.installUI(this);
    }

    protected void notifyAdded() {
        this.scene.addSceneListener(this.sceneListener);
    }

    protected void notifyRemoved() {
        this.scene.removeSceneListener(this.sceneListener);
    }

    private boolean isMinimizableWidget(Widget widget) {
        if (this.scene.isMinimizeConnectedPins()) {
            return true;
        }
        if (widget instanceof PinWidget) {
            PinWidget pin = (PinWidget)widget;
            return !this.scene.hasConnections(pin);
        }
        return true;
    }

    public boolean isMinimized() {
        return this.stateModel.getBooleanState();
    }

    public void setMinimized(boolean minimized) {
        this.stateModel.setBooleanState(minimized);
    }

    public void toggleMinimized() {
        this.stateModel.toggleBooleanState();
    }

    public void stateChanged() {
        boolean minimized = this.stateModel.getBooleanState();
        Rectangle rectangle = minimized ? new Rectangle() : null;
        for (Widget widget : this.getChildren()) {
            if (widget == this.header) continue;
            this.scene.animatePreferredBounds(widget, minimized && this.isMinimizableWidget(widget) ? rectangle : null);
        }
        this.minimizeWidget.setImage(this.scheme.getMinimizeWidgetImage(this));
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        if (!previousState.isSelected() && state.isSelected() || !previousState.isHovered() && state.isHovered()) {
            this.bringToFront();
            this.commentWidget.bringToFront();
            this.toolsWidget.bringToFront();
        }
        this.scheme.updateUI(this);
    }

    public void setNodeImage(Image image) {
        this.imageWidget.setImage(image);
        this.revalidate();
    }

    public String getNodeName() {
        return this.nameWidget.getLabel();
    }

    public void setNodeName(String nodeName) {
        this.nameWidget.setLabel(nodeName);
    }

    public void attachPinWidget(Widget widget) {
        widget.setCheckClipping(true);
        this.addChild(widget);
        if (this.stateModel.getBooleanState() && this.isMinimizableWidget(widget)) {
            widget.setPreferredBounds(new Rectangle());
        }
    }

    public void setGlyphs(List<Image> glyphs) {
        this.glyphSetWidget.setGlyphs(glyphs);
    }

    public LabelWidget getNodeNameWidget() {
        return this.nameWidget;
    }

    @Override
    public void collapseWidget() {
        this.stateModel.setBooleanState(true);
    }

    @Override
    public void expandWidget() {
        this.stateModel.setBooleanState(false);
    }

    public Widget getHeader() {
        return this.header;
    }

    public Widget getMinimizeButton() {
        return this.minimizeWidget;
    }

    public void setComment(String comment) {
        if (comment == null || comment.trim().isEmpty()) {
            this.commentWidget.setText("");
            this.commentWidget.setVisible(false);
        } else {
            this.commentWidget.setText(comment);
            this.commentWidget.setVisible(true);
        }
        this.scheme.updateUI(this);
    }

    public String getComment() {
        return this.commentWidget.getText();
    }

    public void setCommentEditProvider(EditProvider provider) {
        this.commentWidget.setEditProvider(provider);
    }

    public void addToolWidget(Widget tool) {
        this.toolsWidget.addChild(tool);
        this.toolsWidget.setVisible(true);
    }

    public void removeToolWidget(Widget tool) {
        this.toolsWidget.removeChild(tool);
        if (this.toolsWidget.getChildren().isEmpty()) {
            this.toolsWidget.setVisible(false);
        }
    }

    public void clearToolWidgets() {
        this.toolsWidget.removeChildren();
        this.toolsWidget.setVisible(false);
    }

    private void positionComment() {
        if (!this.commentWidget.isVisible()) {
            return;
        }
        Point loc = this.getLocation();
        Rectangle bounds = this.getBounds();
        Rectangle commentBounds = this.commentWidget.getBounds();
        if (loc == null || bounds == null || commentBounds == null) {
            return;
        }
        int offset = this.commentWidget.getBorder().getInsets().left;
        this.commentWidget.setPreferredLocation(new Point(loc.x + offset, loc.y - commentBounds.height - 2));
        this.commentWidget.setMinimumSize(new Dimension(bounds.width, 15));
    }

    private void positionTools() {
        if (!this.toolsWidget.isVisible()) {
            return;
        }
        Point loc = this.getLocation();
        Rectangle bounds = this.getBounds();
        if (loc == null || bounds == null) {
            return;
        }
        this.toolsWidget.setPreferredLocation(new Point(loc.x, loc.y + bounds.height + 2));
        this.toolsWidget.setMinimumSize(new Dimension(bounds.width, 15));
    }

    protected void paintChildren() {
        if (this.isBelowLODThreshold()) {
            return;
        }
        super.paintChildren();
    }

    public boolean isBelowLODThreshold() {
        return this.scene.isBelowLODThreshold();
    }

    CommentWidget getCommentWidget() {
        return this.commentWidget;
    }

    ToolContainerWidget getToolContainerWidget() {
        return this.toolsWidget;
    }

    public void setSchemeColors(LAFScheme.Colors colors) {
        this.schemeColors = colors;
        this.revalidate();
    }

    public LAFScheme.Colors getSchemeColors() {
        return this.schemeColors == null ? this.scene.getSchemeColors() : this.schemeColors;
    }

    private class SceneListenerImpl
    implements Scene.SceneListener {
        private SceneListenerImpl() {
        }

        public void sceneRepaint() {
        }

        public void sceneValidating() {
            NodeWidget.this.scheme.updateUI(NodeWidget.this);
        }

        public void sceneValidated() {
            NodeWidget.this.positionComment();
            NodeWidget.this.positionTools();
        }
    }

    private class ToggleMinimizedAction
    extends WidgetAction.Adapter {
        private ToggleMinimizedAction() {
        }

        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
            block6: {
                List<NodeWidget> selected;
                boolean inSelection;
                block5: {
                    if (event.getButton() == 1) break block5;
                    if (event.getButton() != 2) break block6;
                }
                if (inSelection = (selected = NodeWidget.this.scene.getSelectedObjects().stream().map(obj -> NodeWidget.this.scene.findWidget(obj)).filter(NodeWidget.class::isInstance).map(NodeWidget.class::cast).toList()).contains(NodeWidget.this)) {
                    boolean state = NodeWidget.this.stateModel.getBooleanState();
                    selected.forEach(nw -> nw.stateModel.setBooleanState(!state));
                } else {
                    NodeWidget.this.stateModel.toggleBooleanState();
                }
            }
            return WidgetAction.State.REJECTED;
        }

        public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent event) {
            return WidgetAction.State.CONSUMED;
        }
    }
}

