/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.api.visual.action.CycleFocusProvider;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.praxislive.ide.pxr.graph.scene.PraxisGraphScene;

class PraxisCycleFocusProvider
implements CycleFocusProvider {
    PraxisCycleFocusProvider() {
    }

    public boolean switchPreviousFocus(Widget widget) {
        Scene scene = widget.getScene();
        return scene instanceof PraxisGraphScene && this.switchFocus((PraxisGraphScene)scene, false);
    }

    public boolean switchNextFocus(Widget widget) {
        Scene scene = widget.getScene();
        return scene instanceof PraxisGraphScene && this.switchFocus((PraxisGraphScene)scene, true);
    }

    private boolean switchFocus(PraxisGraphScene<?> scene, boolean forward) {
        boolean changeSelection = false;
        Object focused = scene.getFocusedObject();
        List nodes = scene.getSelectedObjects().stream().filter(arg_0 -> scene.isNode(arg_0)).collect(Collectors.toCollection(ArrayList::new));
        if (nodes.size() < 2) {
            nodes = scene.getNodes().stream().collect(Collectors.toCollection(ArrayList::new));
            changeSelection = true;
        }
        if (nodes.isEmpty()) {
            return false;
        }
        nodes.sort(new LayoutComparator(scene));
        int curIdx = nodes.indexOf(focused);
        focused = forward ? (++curIdx >= nodes.size() ? nodes.get(0) : nodes.get(curIdx)) : (--curIdx < 0 ? nodes.get(nodes.size() - 1) : nodes.get(curIdx));
        scene.setFocusedObject(focused);
        if (changeSelection) {
            scene.setSelectedObjects(Collections.singleton(focused));
        }
        return true;
    }

    static class LayoutComparator
    implements Comparator<Object> {
        private static final int TOLERANCE = 100;
        private final PraxisGraphScene<?> scene;

        LayoutComparator(PraxisGraphScene<?> scene) {
            this.scene = scene;
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            Widget w1 = this.scene.findWidget(o1);
            Widget w2 = this.scene.findWidget(o2);
            Point w1p = w1.getLocation();
            Point w2p = w2.getLocation();
            if (Math.abs(w1p.y - w2p.y) < 100) {
                return w1p.x < w2p.x ? -1 : 1;
            }
            return w1p.y < w2p.y ? -1 : 1;
        }
    }
}

