/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.gui;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.IDEUtil;
import org.praxislive.core.ComponentAddress;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.model.ContainerProxy;
import org.praxislive.ide.model.RootProxy;

class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());

    private Utils() {
    }

    static void enableAll(JComponent component) {
        component.setEnabled(true);
        for (Component cmp : component.getComponents()) {
            if (!(cmp instanceof JComponent)) continue;
            Utils.enableAll((JComponent)cmp);
        }
    }

    static void disableAll(JComponent component) {
        component.setEnabled(false);
        for (Component cmp : component.getComponents()) {
            if (!(cmp instanceof JComponent)) continue;
            Utils.disableAll((JComponent)cmp);
        }
    }

    static ComponentProxy findComponentProxy(RootProxy root, ComponentAddress address) {
        if (address.rootID().equals(root.getAddress().rootID())) {
            RootProxy comp = root;
            for (int i = 1; i < address.depth(); ++i) {
                if (!(comp instanceof ContainerProxy)) {
                    return null;
                }
                comp = ((ContainerProxy)comp).getChild(address.componentID(i));
            }
            return comp;
        }
        return null;
    }

    static ComponentProxy findComponentProxy(RootProxy root, JComponent cmp) {
        Object o = cmp.getClientProperty("Praxis.Address");
        if (o instanceof ComponentAddress) {
            return Utils.findComponentProxy(root, (ComponentAddress)o);
        }
        return null;
    }

    static JComponent findAddressedComponent(Component cmp) {
        do {
            if (!(cmp instanceof JComponent) || ((JComponent)cmp).getClientProperty("Praxis.Address") == null) continue;
            return (JComponent)cmp;
        } while ((cmp = cmp.getParent()) != null);
        return null;
    }

    static ComponentAddress getComponentAddress(Component cmp) {
        Object ad;
        if (cmp instanceof JComponent && (ad = ((JComponent)cmp).getClientProperty("Praxis.Address")) instanceof ComponentAddress) {
            return (ComponentAddress)ad;
        }
        return null;
    }

    static JComponent findContainerComponent(RootProxy root, Component cmp) {
        do {
            ComponentProxy pxy;
            if (!((cmp = Utils.findAddressedComponent(cmp)) instanceof JComponent) || !((pxy = Utils.findComponentProxy(root, (JComponent)cmp)) instanceof ContainerProxy)) continue;
            return (JComponent)cmp;
        } while ((cmp = cmp.getParent()) != null);
        return null;
    }

    static int[] getGridPosition(JComponent container, JComponent component) {
        HashMap gridPositions = IDEUtil.getGridPositions((Object)container);
        if (gridPositions == null) {
            return null;
        }
        int[] result = (int[])gridPositions.get(component);
        if (LOG.isLoggable(Level.FINE)) {
            if (result == null) {
                LOG.log(Level.FINE, "getGridPosition() null for {0} in {1}", new Object[]{Utils.getComponentAddress(component), Utils.getComponentAddress(container)});
            } else {
                LOG.log(Level.FINEST, "getGridPosition() is {0} for {1} in {2}", new Object[]{Arrays.toString(result), Utils.getComponentAddress(component), Utils.getComponentAddress(container)});
            }
        }
        return result;
    }

    static int[] getGridPosition(JComponent container, int mouseX, int mouseY) {
        int i;
        int[] result = new int[]{0, 0};
        int[][] axisSizes = IDEUtil.getColumnSizes((Object)container);
        int[] sizes = axisSizes[1];
        int accum = 0;
        for (i = 0; i < sizes.length && (accum += sizes[i]) <= mouseX; ++i) {
        }
        result[0] = (i /= 2) < axisSizes[0].length ? axisSizes[0][i] : axisSizes[0][axisSizes[0].length - 1] + 1;
        axisSizes = IDEUtil.getRowSizes((Object)container);
        sizes = axisSizes[1];
        accum = 0;
        for (i = 0; i < sizes.length && (accum += sizes[i]) <= mouseY; ++i) {
        }
        result[1] = (i /= 2) < axisSizes[0].length ? axisSizes[0][i] : axisSizes[0][axisSizes[0].length - 1] + 1;
        return result;
    }

    static CC getConstraints(JComponent cmp) {
        Object val = cmp.getClientProperty("Praxis.LayoutConstraint");
        if (val instanceof CC) {
            return (CC)val;
        }
        return new CC();
    }

    static void updateConstraints(JComponent cmp, CC cc) {
        cmp.putClientProperty("Praxis.LayoutConstraint", null);
        cmp.putClientProperty("Praxis.LayoutConstraint", cc);
    }

    static boolean isOccupied(JComponent container, int x, int y, int width, int height, Set<JComponent> ignored) {
        return !Utils.requiredSpace(container, x, y, width, height, ignored).isEmpty();
    }

    static void ensureSpace(JComponent container, int x, int y, int width, int height, Set<JComponent> ignored, boolean vertical) {
        Rectangle space = Utils.requiredSpace(container, x, y, width, height, ignored);
        if (space.isEmpty()) {
            return;
        }
        if (vertical) {
            Utils.moveChildren(container, space.y, y + height - space.y, vertical, ignored);
        } else {
            Utils.moveChildren(container, space.x, x + width - space.x, vertical, ignored);
        }
    }

    static void move(RootProxy root, JComponent cmp, int dx, int dy) {
        Utils.changeBounds(root, cmp, dx, dy, 0, 0, Math.abs(dy) > Math.abs(dx));
    }

    static void resize(RootProxy root, JComponent cmp, int dSpanX, int dSpanY) {
        Utils.changeBounds(root, cmp, 0, 0, dSpanX, dSpanY, Math.abs(dSpanY) > Math.abs(dSpanX));
    }

    private static void changeBounds(RootProxy root, JComponent cmp, int dx, int dy, int dSpanX, int dSpanY, boolean vertical) {
        int[] pos;
        JComponent container = Utils.findContainerComponent(root, cmp);
        if (container == cmp) {
            container = Utils.findContainerComponent(root, cmp.getParent());
        }
        if ((pos = Utils.getGridPosition(container, cmp)) == null) {
            LOG.log(Level.FINE, "changeBounds() can't find component {0} in {1}", new Object[]{Utils.getComponentAddress(cmp), Utils.getComponentAddress(container)});
            return;
        }
        CC cc = Utils.getConstraints(cmp);
        Set<JComponent> ignore = Collections.singleton(cmp);
        int x = pos[0] + dx;
        int y = pos[1] + dy;
        int spanX = pos[2] + dSpanX;
        int spanY = pos[3] + dSpanY;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (spanX < 1) {
            spanX = 1;
        }
        if (spanY < 1) {
            spanY = 1;
        }
        Utils.ensureSpace(container, x, y, spanX, spanY, ignore, vertical);
        cc.setCellX(x);
        cc.setCellY(y);
        cc.setSpanX(spanX);
        cc.setSpanY(spanY);
        Utils.updateConstraints(cmp, cc);
        Utils.compactGrid(container);
    }

    private static Rectangle requiredSpace(JComponent container, int x, int y, int width, int height, Set<JComponent> ignored) {
        HashMap gridPositions = IDEUtil.getGridPositions((Object)container);
        if (gridPositions == null || gridPositions.isEmpty()) {
            return new Rectangle();
        }
        Rectangle space = new Rectangle(x, y, width, height);
        Rectangle intersection = new Rectangle();
        Rectangle cmp = new Rectangle();
        for (Map.Entry entry : gridPositions.entrySet()) {
            int[] pos;
            if (ignored.contains(entry.getKey()) || (pos = (int[])entry.getValue()).length < 4) continue;
            cmp.x = pos[0];
            cmp.y = pos[1];
            cmp.width = pos[2];
            cmp.height = pos[3];
            if (!cmp.intersects(space)) continue;
            if (intersection.isEmpty()) {
                intersection.setBounds(cmp);
                continue;
            }
            intersection.add(cmp);
        }
        return intersection;
    }

    static void compactGrid(JComponent container) {
        container.validate();
        Utils.compactAxis(container, true);
        Utils.compactAxis(container, false);
    }

    private static void compactAxis(JComponent container, boolean vertical) {
        int[] ax = Utils.getAxisIndexes(container, vertical);
        int exp = 0;
        int i = 0;
        int overall = 0;
        while (i < ax.length && overall < 50) {
            ++overall;
            int cur = ax[i];
            if (cur != exp) {
                if (LOG.isLoggable(Level.FINE)) {
                    String orientation = vertical ? "Rows" : "Columns";
                    LOG.fine("Found gap in " + orientation + " , removing " + exp + " -> " + cur);
                }
                Utils.moveChildren(container, cur, exp - cur, vertical, Collections.emptySet());
                ax = Utils.getAxisIndexes(container, vertical);
                exp = 0;
                i = 0;
                continue;
            }
            ++i;
            ++exp;
        }
    }

    private static int[] getAxisIndexes(JComponent container, boolean vertical) {
        Object pos;
        HashMap gridPositions = IDEUtil.getGridPositions((Object)container);
        if (gridPositions == null || gridPositions.isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                String orientation = vertical ? "Rows" : "Columns";
                LOG.log(Level.FINE, "No {0} found in {1}", new Object[]{orientation, Utils.getComponentAddress(container)});
            }
            return new int[0];
        }
        TreeSet<Integer> axes = new TreeSet<Integer>();
        for (Map.Entry entry : gridPositions.entrySet()) {
            reference var5_7;
            reference var4_6;
            pos = (int[])entry.getValue();
            if (((int[])pos).length < 4) continue;
            if (vertical) {
                var4_6 = pos[1];
                var5_7 = pos[3];
            } else {
                var4_6 = pos[0];
                var5_7 = pos[2];
            }
            axes.add((int)var4_6);
            while (var5_7 > true) {
                LOG.fine("Adding span");
                axes.add((int)(++var4_6));
                --var5_7;
            }
        }
        int[] result = new int[axes.size()];
        int i = 0;
        pos = axes.iterator();
        while (pos.hasNext()) {
            Integer ax = (Integer)pos.next();
            result[i++] = ax;
        }
        if (LOG.isLoggable(Level.FINE)) {
            String orientation = vertical ? "Rows" : "Columns";
            LOG.log(Level.FINE, "Found {0} {1} in {2}", new Object[]{orientation, Arrays.toString(result), Utils.getComponentAddress(container)});
        }
        return result;
    }

    private static void moveChildren(JComponent container, int from, int diff, boolean vertical, Set<JComponent> ignored) {
        for (Component cmp : container.getComponents()) {
            JComponent jc;
            Object val;
            if (!(cmp instanceof JComponent) || ignored.contains(cmp) || !((val = (jc = (JComponent)cmp).getClientProperty("Praxis.LayoutConstraint")) instanceof CC)) continue;
            CC cc = (CC)val;
            if (vertical) {
                int y = cc.getCellY();
                if (y >= from) {
                    cc.setCellY(y + diff);
                }
            } else {
                int x = cc.getCellX();
                if (x >= from) {
                    cc.setCellX(x + diff);
                }
            }
            jc.putClientProperty("Praxis.LayoutConstraint", null);
            jc.putClientProperty("Praxis.LayoutConstraint", cc);
        }
        container.validate();
    }
}

