/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.openide.util.Exceptions;
import org.praxislive.base.AbstractRoot;
import org.praxislive.base.FilteredTypes;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Container;
import org.praxislive.core.Info;
import org.praxislive.core.Lookup;
import org.praxislive.core.protocols.ComponentProtocol;
import org.praxislive.core.protocols.ContainerProtocol;
import org.praxislive.core.protocols.StartableProtocol;
import org.praxislive.gui.GuiContext;
import org.praxislive.ide.core.api.AbstractIDERoot;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.pxr.gui.GuiEditor;
import org.praxislive.ide.pxr.gui.Utils;

public class DockableGuiRoot
extends AbstractIDERoot {
    private static final Map<String, DockableGuiRoot> REGISTRY = new HashMap<String, DockableGuiRoot>();
    private static final ComponentInfo INFO = Info.component(cmp -> cmp.merge(ComponentProtocol.API_INFO).merge(ContainerProtocol.API_INFO).control("supported-types", ContainerProtocol.SUPPORTED_TYPES_INFO).merge(StartableProtocol.API_INFO).property("component-type", (Object)ComponentType.of((String)"root:gui")));
    private final PraxisProject project;
    private JFrame frame;
    private JPanel container;
    private MigLayout layout;
    private LayoutChangeListener layoutListener;
    private Context context;
    private Lookup lookup;
    private GuiEditor activeEditor;

    public DockableGuiRoot(PraxisProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public ComponentInfo getInfo() {
        return INFO;
    }

    protected void setup() {
        this.frame = new JFrame();
        this.frame.setTitle("PraxisLIVE : " + String.valueOf(this.getAddress()));
        this.frame.setMinimumSize(new Dimension(150, 50));
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    if (DockableGuiRoot.this.activeEditor == null) {
                        DockableGuiRoot.this.setIdle();
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        this.layout = new MigLayout("", "[fill]");
        this.container = new JPanel((LayoutManager)this.layout);
        this.container.addContainerListener(new ChildrenListener());
        this.container.putClientProperty("Praxis.Address", this.getAddress());
        this.layoutListener = new LayoutChangeListener();
        this.frame.getContentPane().add(new JScrollPane(this.container));
        REGISTRY.put(DockableGuiRoot.computeID(this.project, this.getAddress().rootID()), this);
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.context = new Context();
            FilteredTypes types = FilteredTypes.create((Container)this, type -> type.toString().startsWith("gui:"));
            this.lookup = Lookup.of((Lookup)super.getLookup(), (Object[])new Object[]{this.context, types});
        }
        return this.lookup;
    }

    protected void starting() {
        super.starting();
        Utils.enableAll(this.container);
        if (this.activeEditor == null) {
            this.frame.pack();
            this.frame.setVisible(true);
        }
    }

    protected void stopping() {
        super.stopping();
        Utils.disableAll(this.container);
        if (this.activeEditor == null) {
            this.frame.setVisible(false);
        }
    }

    protected void dispose() {
        super.dispose();
        if (this.activeEditor != null) {
            this.activeEditor.removeRootPanel(this.container);
            this.activeEditor = null;
        }
        this.frame.setVisible(false);
        this.frame.dispose();
        REGISTRY.values().remove((Object)this);
    }

    void requestConnect(GuiEditor editor) {
        if (editor == this.activeEditor) {
            return;
        }
        if (this.activeEditor != null) {
            this.activeEditor.removeRootPanel(this.container);
            this.activeEditor = null;
        } else {
            this.frame.setVisible(false);
            this.container.getParent().remove(this.container);
            this.frame.getContentPane().removeAll();
        }
        this.activeEditor = editor;
        editor.addRootPanel(this.container);
        if (this.getState() != AbstractRoot.State.ACTIVE_RUNNING) {
            Utils.disableAll(this.container);
        }
    }

    void requestDisconnect(GuiEditor editor) {
        if (this.activeEditor == editor) {
            editor.removeRootPanel(this.container);
            this.activeEditor = null;
            this.frame.getContentPane().add(new JScrollPane(this.container));
            if (this.getState() == AbstractRoot.State.ACTIVE_RUNNING) {
                this.frame.pack();
                this.frame.setVisible(true);
                this.frame.requestFocus();
                this.frame.toFront();
            }
        }
    }

    static DockableGuiRoot find(PraxisProject project, String id) {
        return REGISTRY.get(DockableGuiRoot.computeID(project, id));
    }

    private static String computeID(PraxisProject project, String rootID) {
        return project.getProjectDirectory().getPath() + "!" + rootID;
    }

    private void updateLayout(JComponent child) {
        if (child != null) {
            this.layout.setComponentConstraints((Component)child, child.getClientProperty("Praxis.LayoutConstraint"));
        }
        this.container.revalidate();
        this.container.repaint();
    }

    private class ChildrenListener
    implements ContainerListener {
        private ChildrenListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof JComponent) {
                JComponent child = (JComponent)e.getChild();
                child.addPropertyChangeListener("Praxis.LayoutConstraint", DockableGuiRoot.this.layoutListener);
                DockableGuiRoot.this.updateLayout(child);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            if (e.getChild() instanceof JComponent) {
                ((JComponent)e.getChild()).removePropertyChangeListener("Praxis.LayoutConstraint", DockableGuiRoot.this.layoutListener);
            }
            DockableGuiRoot.this.updateLayout(null);
        }
    }

    private class LayoutChangeListener
    implements PropertyChangeListener {
        private LayoutChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof JComponent) {
                JComponent comp = (JComponent)evt.getSource();
                LayoutManager lm = DockableGuiRoot.this.container.getLayout();
                if (lm instanceof MigLayout) {
                    ((MigLayout)lm).setComponentConstraints((Component)comp, evt.getNewValue());
                    DockableGuiRoot.this.container.revalidate();
                }
            }
        }
    }

    private class Context
    extends GuiContext {
        private Context() {
        }

        public JComponent getContainer() {
            return DockableGuiRoot.this.container;
        }
    }
}

