/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.ChangeSupport;
import org.praxislive.core.ComponentType;
import org.praxislive.core.types.PString;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.model.ContainerProxy;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.pxr.gui.GuiEditor;
import org.praxislive.ide.pxr.gui.LayoutAction;
import org.praxislive.ide.pxr.gui.Utils;

class EditLayer
extends JComponent {
    private static final Logger LOG = Logger.getLogger(EditLayer.class.getName());
    private static final Color hoverColor = new Color(143, 171, 196);
    private static final Color selectedColor = hoverColor.brighter();
    private final GuiEditor editor;
    private final RootProxy root;
    private final JPanel rootPanel;
    private final MouseController mouse;
    private final ChangeSupport cs;
    private final SelectedListener selectedListener;
    private JComponent hovered;
    private JComponent selected;

    EditLayer(GuiEditor editor, JPanel rootPanel) {
        this.editor = editor;
        this.rootPanel = rootPanel;
        this.root = editor.getRoot();
        this.cs = new ChangeSupport((Object)this);
        this.mouse = new MouseController();
        this.selectedListener = new SelectedListener();
        this.addMouseListener(this.mouse);
        this.addMouseMotionListener(this.mouse);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.setDropTarget(new DropTarget(this, new DnDController()));
        super.setVisible(false);
    }

    void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    void performLayoutAction(LayoutAction.Type type) {
        if (this.selected == null || this.selected == this.rootPanel) {
            LOG.fine("performLayoutAction() called when shouldn't be enabled");
            return;
        }
        switch (type) {
            case MoveUp: {
                Utils.move(this.root, this.selected, 0, -1);
                break;
            }
            case MoveDown: {
                Utils.move(this.root, this.selected, 0, 1);
                break;
            }
            case MoveLeft: {
                Utils.move(this.root, this.selected, -1, 0);
                break;
            }
            case MoveRight: {
                Utils.move(this.root, this.selected, 1, 0);
                break;
            }
            case IncreaseSpanX: {
                Utils.resize(this.root, this.selected, 1, 0);
                break;
            }
            case DecreaseSpanX: {
                Utils.resize(this.root, this.selected, -1, 0);
                break;
            }
            case IncreaseSpanY: {
                Utils.resize(this.root, this.selected, 0, 1);
                break;
            }
            case DecreaseSpanY: {
                Utils.resize(this.root, this.selected, 0, -1);
            }
        }
    }

    boolean isLayoutActionEnabled(LayoutAction.Type type) {
        return this.selected != null && this.selected != this.rootPanel;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        ComponentProxy pxy = visible && this.selected != null && this.selected != this.rootPanel ? Utils.findComponentProxy(this.root, this.selected) : null;
        try {
            if (pxy == null) {
                this.editor.setSelected(new Node[]{this.root.getNodeDelegate()});
            } else {
                this.editor.setSelected(new Node[]{pxy.getNodeDelegate()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cs.fireChange();
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paintHovered(g);
        this.paintSelected(g);
    }

    private void paintHovered(Graphics g) {
        if (this.hovered == null) {
            return;
        }
        g.setColor(hoverColor);
        Point loc = this.hovered.getLocation();
        loc = SwingUtilities.convertPoint(this.hovered.getParent(), loc, this.rootPanel);
        g.drawRect(loc.x, loc.y, this.hovered.getWidth() - 1, this.hovered.getHeight() - 1);
    }

    private void paintSelected(Graphics g) {
        if (this.selected == null || this.selected == this.rootPanel) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Point loc = this.selected.getLocation();
        loc = SwingUtilities.convertPoint(this.selected.getParent(), loc, this.rootPanel);
        g2d.setColor(selectedColor);
        g2d.setComposite(AlphaComposite.SrcOver.derive(0.2f));
        g2d.fillRect(loc.x, loc.y, this.selected.getWidth(), this.selected.getHeight());
        g2d.setComposite(AlphaComposite.SrcOver);
        g2d.drawRect(loc.x, loc.y, this.selected.getWidth() - 1, this.selected.getHeight() - 1);
    }

    private void clearHoveredComponent() {
        if (this.hovered != null) {
            this.hovered = null;
            this.repaint();
        }
    }

    private void updateHoveredComponent(int x, int y) {
        JComponent cmp = this.findComponentAtPoint(x, y);
        this.updateLabel(cmp, x, y);
        if (cmp == this.rootPanel) {
            cmp = null;
        }
        if (cmp != this.hovered) {
            this.hovered = cmp;
            this.repaint();
        }
    }

    private void updateLabel(JComponent cmp, int x, int y) {
        JComponent cnt = Utils.findContainerComponent(this.editor.getRoot(), cmp);
        if (cnt != this.rootPanel) {
            Point loc = SwingUtilities.convertPoint(this.rootPanel, x, y, cnt);
            x = loc.x;
            y = loc.y;
        }
        int[] position = null;
        if (cnt != null && cnt.getLayout() instanceof MigLayout) {
            position = cnt != cmp ? Utils.getGridPosition(cnt, cmp) : Utils.getGridPosition(cnt, x, y);
        }
        Object text = "";
        if (position == null) {
            text = "Unknown";
        } else if (position.length > 3) {
            text = "X : " + position[0] + " Y : " + position[1] + " Span X : " + position[2] + " Span Y : " + position[3];
        } else if (position.length > 1) {
            text = "X : " + position[0] + " Y : " + position[1];
        }
        this.setToolTipText((String)text);
    }

    private void updateSelectedComponent(int x, int y) {
        JComponent cmp = this.findComponentAtPoint(x, y);
        if (cmp == this.selected) {
            return;
        }
        try {
            if (this.selected != null) {
                this.selected.removeAncestorListener(this.selectedListener);
            }
            this.selected = cmp;
            this.selected.addAncestorListener(this.selectedListener);
            ComponentProxy pxy = Utils.findComponentProxy(this.root, cmp);
            if (pxy == null) {
                this.editor.setSelected(new Node[]{this.root.getNodeDelegate()});
            } else {
                this.editor.setSelected(new Node[]{pxy.getNodeDelegate()});
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, null, ex);
            this.selected.removeAncestorListener(this.selectedListener);
            this.selected = null;
        }
        this.cs.fireChange();
        this.repaint();
    }

    private void addComponent(ComponentType type, int x, int y) throws Exception {
        JComponent dropOver = this.findComponentAtPoint(x, y);
        JComponent container = Utils.findContainerComponent(this.root, dropOver);
        if (container != this.rootPanel) {
            Point loc = SwingUtilities.convertPoint(this.rootPanel, x, y, container);
            x = loc.x;
            y = loc.y;
        }
        ContainerProxy pxy = (ContainerProxy)Utils.findComponentProxy(this.root, container);
        int[] pos = container == dropOver ? (container.getComponentCount() == 0 || !(container.getLayout() instanceof MigLayout) ? new int[]{0, 0} : Utils.getGridPosition(container, x, y)) : Utils.getGridPosition(container, dropOver);
        Utils.ensureSpace(container, pos[0], pos[1], 1, 1, Collections.emptySet(), true);
        PString layout = PString.of((String)("cell " + pos[0] + " " + pos[1]));
        String id = this.getFreeID(pxy, type);
        pxy.addChild(id, type).thenCompose(c -> c.send("layout", List.of(layout))).thenRun(() -> Utils.compactGrid(container)).exceptionally(ex -> {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Error creating component", 0));
            return null;
        });
    }

    private String getFreeID(ContainerProxy container, ComponentType type) {
        String base = type.toString();
        base = base.substring(base.lastIndexOf(":") + 1);
        for (int i = 1; i < 100; ++i) {
            if (container.getChild(base + i) != null) continue;
            return base + i;
        }
        return "";
    }

    private JComponent findComponentAtPoint(int x, int y) {
        Component cmp = SwingUtilities.getDeepestComponentAt(this.rootPanel, x, y);
        return Utils.findAddressedComponent(cmp);
    }

    private class MouseController
    extends MouseAdapter {
        private MouseController() {
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            EditLayer.this.updateHoveredComponent(me.getX(), me.getY());
        }

        @Override
        public void mouseExited(MouseEvent me) {
            EditLayer.this.clearHoveredComponent();
        }

        @Override
        public void mousePressed(MouseEvent me) {
            EditLayer.this.requestFocusInWindow();
            if (!me.isPopupTrigger()) {
                EditLayer.this.updateSelectedComponent(me.getX(), me.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2) {
                EditLayer.this.updateSelectedComponent(me.getX(), me.getY());
                EditLayer.this.editor.performPreferredAction();
            }
        }
    }

    private class SelectedListener
    implements AncestorListener {
        private SelectedListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent ae) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent ae) {
            EditLayer.this.updateSelectedComponent(0, 0);
        }

        @Override
        public void ancestorMoved(AncestorEvent ae) {
        }
    }

    private class DnDController
    extends DropTargetAdapter {
        private DnDController() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (this.extractType(dtde.getTransferable()) == null) {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            EditLayer.this.updateHoveredComponent(dtde.getLocation().x, dtde.getLocation().y);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            ComponentType type = this.extractType(dtde.getTransferable());
            if (type != null) {
                try {
                    EditLayer.this.addComponent(type, dtde.getLocation().x, dtde.getLocation().y);
                    dtde.acceptDrop(3);
                    return;
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
            dtde.rejectDrop();
        }

        private ComponentType extractType(Transferable transferable) {
            ComponentType t;
            Node n = NodeTransfer.node((Transferable)transferable, (int)1);
            if (n != null && (t = (ComponentType)n.getLookup().lookup(ComponentType.class)) != null) {
                return t;
            }
            return null;
        }
    }
}

