/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import org.openide.actions.DeleteAction;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.praxislive.ide.model.ContainerProxy;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.pxr.api.ComponentPalette;
import org.praxislive.ide.pxr.gui.DockableGuiRoot;
import org.praxislive.ide.pxr.gui.EditLayer;
import org.praxislive.ide.pxr.gui.GuiHelper;
import org.praxislive.ide.pxr.gui.LayoutAction;
import org.praxislive.ide.pxr.spi.RootEditor;

public class GuiEditor
implements RootEditor {
    private final PraxisProject project;
    private final FileObject file;
    private final RootProxy root;
    private final GuiHelper helper;
    private final JComponent editorComponent;
    private final JLayeredPane layeredPane;
    private final ExplorerManager em;
    private final Lookup lookup;
    private final InstanceContent content;
    private final ComponentPalette palette;
    private EditAction editAction;
    private EditLayer editLayer;
    private Action[] actions;

    GuiEditor(PraxisProject project, FileObject file, RootProxy root) {
        this.project = project;
        this.file = file;
        this.root = root;
        this.helper = (GuiHelper)((Object)project.getLookup().lookup(GuiHelper.class));
        this.em = new ExplorerManager();
        this.em.setRootContext(root.getNodeDelegate());
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setLayout(new OverlayLayout(this.layeredPane));
        this.layeredPane.setFocusable(true);
        this.editorComponent = new JScrollPane(this.layeredPane);
        this.initActions(this.layeredPane.getInputMap(1), this.layeredPane.getActionMap());
        this.content = new InstanceContent();
        this.palette = ComponentPalette.create((ContainerProxy)(root instanceof ContainerProxy ? (ContainerProxy)root : null));
        this.lookup = new ProxyLookup(new Lookup[]{ExplorerUtils.createLookup((ExplorerManager)this.em, (ActionMap)this.layeredPane.getActionMap()), Lookups.fixed((Object[])new Object[]{this.palette.controller()}), new AbstractLookup((AbstractLookup.Content)this.content)});
    }

    private void initActions(InputMap inputMap, ActionMap actionMap) {
        this.actions = new Action[13];
        this.editAction = new EditAction();
        this.actions[0] = this.editAction;
        this.actions[1] = null;
        this.actions[2] = new LayoutAction(LayoutAction.Type.MoveLeft);
        this.actions[3] = new LayoutAction(LayoutAction.Type.MoveUp);
        this.actions[4] = new LayoutAction(LayoutAction.Type.MoveDown);
        this.actions[5] = new LayoutAction(LayoutAction.Type.MoveRight);
        this.actions[6] = null;
        this.actions[7] = new LayoutAction(LayoutAction.Type.IncreaseSpanX);
        this.actions[8] = new LayoutAction(LayoutAction.Type.DecreaseSpanX);
        this.actions[9] = new LayoutAction(LayoutAction.Type.IncreaseSpanY);
        this.actions[10] = new LayoutAction(LayoutAction.Type.DecreaseSpanY);
        this.actions[11] = null;
        this.actions[12] = DeleteAction.get(DeleteAction.class);
        inputMap.put(Utilities.stringToKey((String)"D-e"), "edit");
        actionMap.put("edit", this.editAction);
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), "move-left");
        actionMap.put("move-left", this.actions[2]);
        inputMap.put(KeyStroke.getKeyStroke("UP"), "move-up");
        actionMap.put("move-up", this.actions[3]);
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "move-down");
        actionMap.put("move-down", this.actions[4]);
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "move-right");
        actionMap.put("move-right", this.actions[5]);
        inputMap.put(KeyStroke.getKeyStroke("shift RIGHT"), "increase-span-x");
        actionMap.put("increase-span-x", this.actions[7]);
        inputMap.put(KeyStroke.getKeyStroke("shift LEFT"), "decrease-span-x");
        actionMap.put("decrease-span-x", this.actions[8]);
        inputMap.put(KeyStroke.getKeyStroke("shift DOWN"), "increase-span-y");
        actionMap.put("increase-span-y", this.actions[9]);
        inputMap.put(KeyStroke.getKeyStroke("shift UP"), "decrease-span-y");
        actionMap.put("decrease-span-y", this.actions[10]);
        actionMap.put(((DeleteAction)DeleteAction.get(DeleteAction.class)).getActionMapKey(), ExplorerUtils.actionDelete((ExplorerManager)this.em, (boolean)true));
    }

    public JComponent getEditorComponent() {
        return this.editorComponent;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public List<Action> getActions() {
        return Stream.of(this.actions).toList();
    }

    RootProxy getRoot() {
        return this.root;
    }

    GuiHelper getHelper() {
        return this.helper;
    }

    void setSelected(Node[] nodes) throws Exception {
        this.em.setSelectedNodes(nodes);
    }

    void performPreferredAction() {
        Node[] nodes = this.em.getSelectedNodes();
        if (nodes.length == 1) {
            nodes[0].getPreferredAction().actionPerformed(new ActionEvent(this, 1001, ""));
        }
    }

    void addRootPanel(JPanel panel) {
        this.layeredPane.add((Component)panel, JLayeredPane.DEFAULT_LAYER);
        this.editLayer = new EditLayer(this, panel);
        this.layeredPane.add((Component)this.editLayer, JLayeredPane.PALETTE_LAYER);
        this.content.add((Object)this.editLayer);
        this.editAction.setEnabled(true);
    }

    void removeRootPanel(JPanel panel) {
        this.layeredPane.remove(panel);
        this.layeredPane.remove(this.editLayer);
        this.content.remove((Object)this.editLayer);
        this.editAction.setEnabled(false);
        this.editLayer = null;
        try {
            this.em.setSelectedNodes(new Node[0]);
        }
        catch (PropertyVetoException ex) {
            Logger.getLogger(GuiEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void componentActivated() {
        DockableGuiRoot r = DockableGuiRoot.find(this.project, this.root.getAddress().rootID());
        if (r != null) {
            r.requestConnect(this);
        }
    }

    public void dispose() {
        this.palette.dispose();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DockableGuiRoot r = DockableGuiRoot.find(GuiEditor.this.project, GuiEditor.this.root.getAddress().rootID());
                if (r != null) {
                    r.requestDisconnect(GuiEditor.this);
                }
            }
        });
    }

    private class EditAction
    extends AbstractAction
    implements Presenter.Toolbar {
        private JToggleButton button;

        private EditAction() {
            super("Edit");
            this.putValue("SwingSelectedKey", Boolean.FALSE);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (GuiEditor.this.editLayer.isVisible()) {
                GuiEditor.this.editLayer.setVisible(false);
                this.putValue("SwingSelectedKey", Boolean.FALSE);
            } else {
                GuiEditor.this.editLayer.setVisible(true);
                this.putValue("SwingSelectedKey", Boolean.TRUE);
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.putValue("SwingSelectedKey", GuiEditor.this.editLayer.isVisible());
            } else {
                this.putValue("SwingSelectedKey", Boolean.FALSE);
            }
        }

        public Component getToolbarPresenter() {
            if (this.button == null) {
                this.button = new JToggleButton(this);
            }
            return this.button;
        }
    }
}

