/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.gui;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.praxislive.ide.pxr.gui.EditLayer;

class LayoutAction
extends AbstractAction
implements ContextAwareAction,
LookupListener,
ChangeListener {
    private static final String RESOURCE_DIR = "org/praxislive/ide/pxr/gui/resources/";
    private Type type;
    private EditLayer editLayer;
    private Lookup.Result<EditLayer> result;

    LayoutAction(Type type) {
        this(type, Utilities.actionsGlobalContext());
    }

    LayoutAction(Type type, Lookup context) {
        super(type.getName(), type.getIcon());
        this.type = type;
        this.putValue("ShortDescription", type.getName());
        this.setEnabled(false);
        this.result = context.lookupResult(EditLayer.class);
        this.result.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.editLayer.performLayoutAction(this.type);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new LayoutAction(this.type, actionContext);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.setEnabled(this.editLayer.isLayoutActionEnabled(this.type));
    }

    public void resultChanged(LookupEvent ev) {
        this.reset();
        Collection layers = this.result.allInstances();
        if (layers.isEmpty()) {
            return;
        }
        this.setup((EditLayer)layers.iterator().next());
    }

    private void reset() {
        if (this.editLayer != null) {
            this.editLayer.removeChangeListener(this);
            this.editLayer = null;
            this.setEnabled(false);
        }
    }

    private void setup(EditLayer editLayer) {
        this.editLayer = editLayer;
        editLayer.addChangeListener(this);
        this.setEnabled(editLayer.isLayoutActionEnabled(this.type));
    }

    static enum Type {
        MoveUp("Move Up", ImageUtilities.loadImageIcon((String)"org/praxislive/ide/pxr/gui/resources/go-up.png", (boolean)true)),
        MoveDown("Move Down", ImageUtilities.loadImageIcon((String)"org/praxislive/ide/pxr/gui/resources/go-down.png", (boolean)true)),
        MoveLeft("Move Left", ImageUtilities.loadImageIcon((String)"org/praxislive/ide/pxr/gui/resources/go-left.png", (boolean)true)),
        MoveRight("Move Right", ImageUtilities.loadImageIcon((String)"org/praxislive/ide/pxr/gui/resources/go-right.png", (boolean)true)),
        IncreaseSpanX("Increase Grid Width", ImageUtilities.loadImageIcon((String)"org/praxislive/ide/pxr/gui/resources/increase-width.png", (boolean)true)),
        DecreaseSpanX("Decrease Grid Width", ImageUtilities.loadImageIcon((String)"org/praxislive/ide/pxr/gui/resources/decrease-width.png", (boolean)true)),
        IncreaseSpanY("Increase Grid Height", ImageUtilities.loadImageIcon((String)"org/praxislive/ide/pxr/gui/resources/increase-height.png", (boolean)true)),
        DecreaseSpanY("Decrease Grid Height", ImageUtilities.loadImageIcon((String)"org/praxislive/ide/pxr/gui/resources/decrease-height.png", (boolean)true));

        private String name;
        private Icon icon;

        private Type(String name, Icon icon) {
            this.name = name;
            this.icon = icon;
        }

        String getName() {
            return this.name;
        }

        Icon getIcon() {
            return this.icon;
        }
    }
}

