package org.praxislive.ide.pxr;
/** Localizable strings for {@link org.praxislive.ide.pxr}. */
class Bundle {
    /**
     * @return <i>Delete</i>
     * @see SharedCodePanel
     */
    static String ACT_Delete() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "ACT_Delete");
    }
    /**
     * @return <i>New Type...</i>
     * @see SharedCodePanel
     */
    static String ACT_NewSharedType() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "ACT_NewSharedType");
    }
    /**
     * @return <i>Open</i>
     * @see SharedCodePanel
     */
    static String ACT_Open() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "ACT_Open");
    }
    /**
     * @return <i>Add...</i>
     * @see AddChildAction
     */
    static String CTL_AddChildAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "CTL_AddChildAction");
    }
    /**
     * @return <i>Configure root</i>
     * @see RootConfigAction
     */
    static String CTL_RootConfigAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "CTL_RootConfigAction");
    }
    /**
     * @return <i>Start</i>
     * @see StartableRootAction
     */
    static String CTL_StartableRootAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "CTL_StartableRootAction");
    }
    /**
     * @return <i>Create shared base</i>
     * @see BoundCodeProperty
     */
    static String CreateSharedBaseLabel() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "CreateSharedBaseLabel");
    }
    /**
     * @param Type_name Type name
     * @return <i>Delete shared type </i>{@code Type_name}<i>?</i>
     * @see SharedCodePanel
     */
    static String DLG_DeleteType(Object Type_name) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "DLG_DeleteType", Type_name);
    }
    /**
     * @return <i>Enter type name</i>
     * @see SharedCodePanel
     */
    static String DLG_EnterTypeName() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "DLG_EnterTypeName");
    }
    /**
     * @return <i>Root ID is invalid</i>
     * @see PXRWizardPanel1
     */
    static String ERR_InvalidRootID() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "ERR_InvalidRootID");
    }
    /**
     * @return <i>Property doesn't support text values</i>
     * @see ToolActions
     */
    static String ERR_NoSetAsText() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "ERR_NoSetAsText");
    }
    /**
     * @return <i>A root file with this name already exists</i>
     * @see PXRWizardPanel1
     */
    static String ERR_RootFileExists() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "ERR_RootFileExists");
    }
    /**
     * @return <i>Not found in component palette</i>
     * @see ToolActions
     */
    static String ERR_UnknownType() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "ERR_UnknownType");
    }
    /**
     * @param property_id property id
     * @return <i>Edit </i>{@code property_id}
     * @see BoundCodeProperty
     */
    static String EditCodeLabel(Object property_id) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "EditCodeLabel", property_id);
    }
    /**
     * @return <i>Edit shared base</i>
     * @see BoundCodeProperty
     */
    static String EditSharedBaseLabel() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "EditSharedBaseLabel");
    }
    /**
     * @return <i>Add</i>
     * @see ToolActions
     */
    static String LBL_AddAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_AddAction");
    }
    /**
     * @return <i>ID:</i>
     * @see ActionBridge
     */
    static String LBL_AddChild() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_AddChild");
    }
    /**
     * @return <i>Call</i>
     * @see ToolActions
     */
    static String LBL_CallAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_CallAction");
    }
    /**
     * @return <i>Connect</i>
     * @see ToolActions
     */
    static String LBL_ConnectAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_ConnectAction");
    }
    /**
     * @return <i>Copy</i>
     * @see ActionBridge
     */
    static String LBL_CopyAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_CopyAction");
    }
    /**
     * @return <i>Delete</i>
     * @see ActionBridge
     */
    static String LBL_DeleteAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_DeleteAction");
    }
    /**
     * @param component_count component count
     * @return <i>Delete </i>{@code component_count}<i> components?</i>
     * @see ActionBridge
     */
    static String LBL_DeleteTaskMultiple(Object component_count) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_DeleteTaskMultiple", component_count);
    }
    /**
     * @param component_ID component ID
     * @return <i>Delete </i>{@code component_ID}<i>?</i>
     * @see ActionBridge
     */
    static String LBL_DeleteTaskSingle(Object component_ID) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_DeleteTaskSingle", component_ID);
    }
    /**
     * @return <i>Disconnect</i>
     * @see ToolActions
     */
    static String LBL_DisconnectAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_DisconnectAction");
    }
    /**
     * @return <i>Duplicate</i>
     * @see ActionBridge
     */
    static String LBL_DuplicateAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_DuplicateAction");
    }
    /**
     * @return <i>Export...</i>
     * @see ActionBridge
     */
    static String LBL_ExportAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_ExportAction");
    }
    /**
     * @return <i>Root File</i>
     * @see PXRVisualPanel1
     */
    static String LBL_PXRWizardPanel() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_PXRWizardPanel");
    }
    /**
     * @return <i>Paste</i>
     * @see ActionBridge
     */
    static String LBL_PasteAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_PasteAction");
    }
    /**
     * @return <i>Select</i>
     * @see ToolActions
     */
    static String LBL_SelectAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_SelectAction");
    }
    /**
     * @return <i>Shared Code</i>
     * @see SharedCodePanel
     */
    static String LBL_ShowSharedCodeAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_ShowSharedCodeAction");
    }
    /**
     * @return <i>Files of Subgraph</i>
     * @see SubgraphDataObject
     */
    static String LBL_Subgraph_LOADER() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_Subgraph_LOADER");
    }
    /**
     * @return <i>Components</i>
     * @see TableRootEditor
     */
    static String LBL_TableNodeColumn() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_TableNodeColumn");
    }
    /**
     * @param project_name project name
     * @return <i>Build project </i>{@code project_name}<i>?</i>
     * @see PXRWizardIterator
     */
    static String MSG_buildProject(Object project_name) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "MSG_buildProject", project_name);
    }
    /**
     * @return <i>Select</i>
     * @see PXGExportVisualPanel1
     */
    static String PXGExportVisualPanel1_fileSelect() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "PXGExportVisualPanel1.fileSelect");
    }
    /**
     * @return <i>File</i>
     * @see PXGExportVisualPanel1
     */
    static String PXGExportVisualPanel1_name() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "PXGExportVisualPanel1.name");
    }
    /**
     * @return <i>PraxisLIVE Projects/Components</i>
     * @see PXGExportWizard
     */
    static String PXGExportWizard_defaultLocation() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "PXGExportWizard.defaultLocation");
    }
    /**
     * @return <i>File already exists</i>
     * @see PXGExportWizard
     */
    static String PXGExportWizard_fileExists() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "PXGExportWizard.fileExists");
    }
    /**
     * @return <i>Palette category is invalid</i>
     * @see PXGExportWizard
     */
    static String PXGExportWizard_invalidPaletteCategory() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "PXGExportWizard.invalidPaletteCategory");
    }
    /**
     * @return <i>File location must be an existing, writable directory</i>
     * @see PXGExportWizard
     */
    static String PXGExportWizard_nonWritableDirectory() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "PXGExportWizard.nonWritableDirectory");
    }
    /**
     * @return <i>Export PXG</i>
     * @see PXGExportWizard
     */
    static String PXGExportWizard_title() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "PXGExportWizard.title");
    }
    /**
     * @param property_id property id
     * @return <i>Reset </i>{@code property_id}
     * @see BoundCodeProperty
     */
    static String ResetCodeLabel(Object property_id) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "ResetCodeLabel", property_id);
    }
    /**
     * @param class_name class name
     * @return <i>Error creating shared base class </i>{@code class_name}<i>.</i>
     * @see BoundCodeProperty
     */
    static String SharedBaseClassError(Object class_name) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "SharedBaseClassError", class_name);
    }
    /**
     * @return <i>Shared base class name.</i>
     * @see BoundCodeProperty
     */
    static String SharedBaseClassLabel() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "SharedBaseClassLabel");
    }
    /**
     * @return <i>Build project?</i>
     * @see PXRWizardIterator
     */
    static String TITLE_buildProject() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TITLE_buildProject");
    }
    /**
     * @return <i>Audio patch</i>
     * @see PXRWizardIterator
     */
    static String TPL_Audio() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TPL_Audio");
    }
    /**
     * @return <i>Custom root</i>
     * @see PXRWizardIterator
     */
    static String TPL_Custom() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TPL_Custom");
    }
    /**
     * @return <i>Control panel (GUI)</i>
     * @see PXRWizardIterator
     */
    static String TPL_GUI() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TPL_GUI");
    }
    /**
     * @return <i>Generic data patch</i>
     * @see PXRWizardIterator
     */
    static String TPL_Generic() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TPL_Generic");
    }
    /**
     * @return <i>Video patch</i>
     * @see PXRWizardIterator
     */
    static String TPL_Video() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TPL_Video");
    }
    /**
     * @param component_type component type
     * @return <i>Enter an ID for </i>{@code component_type}
     * @see ActionBridge
     */
    static String TTL_AddChild(Object component_type) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TTL_AddChild", component_type);
    }
    /**
     * @return <i>Confirm deletion</i>
     * @see ActionBridge
     */
    static String TTL_DeleteTask() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TTL_DeleteTask");
    }
    /**
     * @return <i>New Type</i>
     * @see SharedCodePanel
     */
    static String TTL_NewType() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TTL_NewType");
    }
    /**
     * @return <i>&lt;no selection></i>
     * @see ToolActions
     */
    static String TXT_EmptySelection() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TXT_EmptySelection");
    }
    /**
     * @return <i>&lt;parent></i>
     * @see ToolActions
     */
    static String TXT_Parent() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TXT_Parent");
    }
    private Bundle() {}
}
