/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2019 Neil C Smith.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 for more details.
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with this work; if not, see http://www.gnu.org/licenses/
 *
 *
 * Please visit https://www.praxislive.org if you need additional information or
 * have any questions.
 */
package org.praxislive.ide.pxr.editors;

import java.util.ArrayList;
import java.util.List;
import org.praxislive.core.Value;
import org.praxislive.core.ValueFormatException;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PString;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import org.openide.explorer.propertysheet.PropertyEnv;

/**
 *
 */
class MapCustomEditor extends javax.swing.JPanel implements PropertyChangeListener {

    private final PropertyEditor editor;
    private final PropertyEnv env;

    boolean ignore;

    /**
     * Creates new form StringCustomEditor
     */
    MapCustomEditor(PropertyEditor editor, PropertyEnv env) {
        this.editor = editor;
        this.env = env;
        initComponents();
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener(this);
        populateTable();
        tableSizeChanged();
        mapTable.getModel().addTableModelListener(e -> {
            if (e.getType() != TableModelEvent.UPDATE) {
                tableSizeChanged();
            }
        });
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scrollPane = new javax.swing.JScrollPane();
        mapTable = new MapTable();
        sizeLabel = new javax.swing.JLabel();
        sizeSpinner = new javax.swing.JSpinner();

        mapTable.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        scrollPane.setViewportView(mapTable);

        sizeLabel.setText(org.openide.util.NbBundle.getMessage(MapCustomEditor.class, "MapCustomEditor.sizeLabel.text")); // NOI18N

        sizeSpinner.setModel(new javax.swing.SpinnerNumberModel(0, 0, 512, 1));
        sizeSpinner.setName(""); // NOI18N
        sizeSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                sizeSpinnerStateChanged(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(scrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(sizeLabel)
                .addGap(6, 6, 6)
                .addComponent(sizeSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(scrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 275, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(sizeLabel)
                    .addComponent(sizeSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void sizeSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_sizeSpinnerStateChanged
        if (ignore) {
            return;
        }
        ignore = true;
        DefaultTableModel model = (DefaultTableModel) mapTable.getModel();
        model.setRowCount((int) sizeSpinner.getValue());
        ignore = false;
    }//GEN-LAST:event_sizeSpinnerStateChanged


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTable mapTable;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JLabel sizeLabel;
    private javax.swing.JSpinner sizeSpinner;
    // End of variables declaration//GEN-END:variables

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (PropertyEnv.PROP_STATE.equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            setFromTable();
        }
    }

    private void tableSizeChanged() {
        if (ignore) {
            return;
        }
        ignore = true;
        sizeSpinner.setValue(mapTable.getRowCount());
        ignore = false;
    }

    // @TODO optimize and centralize String to Value support
    private void setFromTable() {
        int count = mapTable.getRowCount();
        PMap.Builder mapBuilder = PMap.builder();
        for (int i = 0; i < count; i++) {
            Object k = mapTable.getValueAt(i, 0);
            String ks = k == null ? "" : k.toString();
            if (ks.isEmpty()) {
                continue;
            }
            Object v = mapTable.getValueAt(i, 1);
            String vs = v == null ? "" : v.toString();
            mapBuilder.put(ks, vs);
        }
        editor.setValue(mapBuilder.build());
    }

    private void populateTable() {
        DefaultTableModel model = (DefaultTableModel) mapTable.getModel();
        model.setRowCount(0);
        PMap map = PMap.from((Value) editor.getValue()).orElse(PMap.EMPTY);
        for (String key : map.keys()) {
            model.addRow(new Object[]{key, map.getString(key, "")});
        }
    }

}
