/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Connection;
import org.praxislive.core.types.PMap;
import org.praxislive.ide.core.api.AbstractTask;
import org.praxislive.ide.core.api.CallExecutionException;
import org.praxislive.ide.core.api.Disposable;
import org.praxislive.ide.core.api.Task;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.model.ContainerProxy;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.ImportRenameSupport;
import org.praxislive.ide.pxr.PXGExportWizard;
import org.praxislive.ide.pxr.PXRHelper;
import org.praxislive.ide.pxr.PXRRootProxy;
import org.praxislive.ide.pxr.api.ActionSupport;
import org.praxislive.ide.pxr.api.EditorUtils;
import org.praxislive.ide.pxr.spi.ModelTransform;
import org.praxislive.ide.pxr.spi.RootEditor;
import org.praxislive.project.GraphElement;
import org.praxislive.project.GraphModel;
import org.praxislive.project.ParseException;

public class ActionBridge {
    public static final String CATEGORY = "PXR";
    private static final ActionBridge INSTANCE = new ActionBridge();
    private static final RequestProcessor RP = new RequestProcessor(ActionBridge.class);

    private ActionBridge() {
    }

    public Task.WithResult<String> createAddChildTask(ContainerProxy container, ComponentType type) {
        return new AddChildTask(Objects.requireNonNull(container), Objects.requireNonNull(type));
    }

    public Action createCopyAction(RootEditor editor, ExplorerManager explorer) {
        return new CopyActionPerformer(Objects.requireNonNull(editor), Objects.requireNonNull(explorer));
    }

    public Task createCopyTask(ContainerProxy container, List<String> children, ModelTransform.Copy copyTransform) {
        SubGraphTransferable empty = new SubGraphTransferable("");
        ActionBridge.getClipboard().setContents(empty, empty);
        return new CopyTask(Objects.requireNonNull(container), List.copyOf(children), copyTransform);
    }

    public Action createDeleteAction(RootEditor editor, ExplorerManager explorer) {
        return new DeleteActionPerformer(Objects.requireNonNull(editor), Objects.requireNonNull(explorer));
    }

    public Task createDeleteTask(ContainerProxy container, List<String> children, List<Connection> connections) {
        return new DeleteTask(Objects.requireNonNull(container), List.copyOf(children), List.copyOf(connections));
    }

    public Action createDuplicateAction(RootEditor editor, ExplorerManager explorer) {
        return new DuplicateActionPerformer(Objects.requireNonNull(editor), Objects.requireNonNull(explorer));
    }

    public Action createExportAction(RootEditor editor, ExplorerManager explorer) {
        return new ExportActionPerformer(Objects.requireNonNull(editor), Objects.requireNonNull(explorer));
    }

    public Action createPasteAction(RootEditor editor, ExplorerManager explorer) {
        return new PasteActionPerformer(Objects.requireNonNull(editor), Objects.requireNonNull(explorer));
    }

    public Task.WithResult<List<String>> createPasteTask(ContainerProxy container, ModelTransform.Paste pasteTransform) {
        return new PasteTask(Objects.requireNonNull(container), pasteTransform);
    }

    public Task createExportTask(ContainerProxy container, List<String> children, ModelTransform.Export exportTransform) {
        return new ExportTask(Objects.requireNonNull(container), List.copyOf(children), exportTransform);
    }

    public Task createImportTask(ContainerProxy container, FileObject file, ModelTransform.Import importTransform) {
        return new ImportTask(Objects.requireNonNull(container), Objects.requireNonNull(file), importTransform);
    }

    private static Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    private static PXRRootProxy findRootProxy(ContainerProxy container) {
        while (container != null) {
            if (container instanceof PXRRootProxy) {
                PXRRootProxy root = (PXRRootProxy)container;
                return root;
            }
            container = container.getParent();
        }
        throw new IllegalStateException("No root proxy found");
    }

    private static List<String> handleException(Throwable ex) {
        if (ex instanceof CompletionException) {
            CompletionException ce = (CompletionException)ex;
            return ActionBridge.handleException(ce.getCause());
        }
        if (ex instanceof CallExecutionException) {
            CallExecutionException err = (CallExecutionException)ex;
            return err.error().message().lines().toList();
        }
        return List.of(ex.toString());
    }

    public static ActionBridge getDefault() {
        return INSTANCE;
    }

    private static class AddChildTask
    extends AbstractTask.WithResult<String> {
        private final ContainerProxy container;
        private final ComponentType type;

        private AddChildTask(ContainerProxy container, ComponentType type) {
            this.container = container;
            this.type = type;
        }

        protected void handleExecute() throws Exception {
            NotifyDescriptor.InputLine dlg = new NotifyDescriptor.InputLine(Bundle.LBL_AddChild(), Bundle.TTL_AddChild(this.type));
            dlg.setInputText(EditorUtils.findFreeID(this.container.children().collect(Collectors.toSet()), EditorUtils.extractBaseID(this.type), true));
            Object retval = DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg);
            if (retval == NotifyDescriptor.OK_OPTION) {
                String id = dlg.getInputText().strip();
                this.container.addChild(id, this.type).whenComplete((r, ex) -> {
                    if (ex != null) {
                        Exceptions.printStackTrace((Throwable)ex);
                        this.updateState(Task.State.ERROR);
                    } else {
                        this.complete(id);
                    }
                });
            } else {
                this.updateState(Task.State.CANCELLED);
            }
        }
    }

    private static final class CopyActionPerformer
    extends EMSensitiveAction {
        CopyActionPerformer(RootEditor editor, ExplorerManager explorer) {
            super(Bundle.LBL_CopyAction(), editor, explorer);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContainerProxy container = this.findSharedContainer();
            List<String> children = this.selection().stream().map(ComponentProxy::getID).toList();
            if (container == null || children.isEmpty()) {
                return;
            }
            Task.run((Task)ActionSupport.createCopyTask(this.editor(), container, children)).exceptionally(this::handleException);
        }

        @Override
        void refresh() {
            this.setEnabled(!this.selection().isEmpty() && this.findSharedContainer() != null);
        }
    }

    private static class SubGraphTransferable
    implements Transferable,
    ClipboardOwner {
        private final String data;

        private SubGraphTransferable(String data) {
            this.data = data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DataFlavor.stringFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    private static class CopyTask
    extends AbstractTask {
        private final ContainerProxy container;
        private final List<String> children;
        private final ModelTransform.Copy copyTransform;

        CopyTask(ContainerProxy container, List<String> children, ModelTransform.Copy copyTransform) {
            this.container = container;
            this.children = children;
            this.copyTransform = copyTransform == null ? m -> m : copyTransform;
        }

        protected void handleExecute() throws Exception {
            CompletionStage<GraphModel> modelStage;
            PXRHelper helper = ActionBridge.findRootProxy(this.container).getHelper();
            if (this.children.size() == 1) {
                String childID = this.children.iterator().next();
                modelStage = helper.componentData(ComponentAddress.of((ComponentAddress)this.container.getAddress(), (String)childID)).thenApply(data -> GraphModel.fromSerializedComponent((String)childID, (PMap)data));
            } else {
                modelStage = helper.componentData(this.container.getAddress()).thenApply(data -> GraphModel.fromSerializedSubgraph((PMap)data, this.children::contains));
            }
            modelStage.thenApply(this.copyTransform).thenAccept(model -> {
                SubGraphTransferable trans = new SubGraphTransferable(model.writeToString());
                ActionBridge.getClipboard().setContents(trans, trans);
            }).whenComplete((r, ex) -> {
                if (ex != null) {
                    Exceptions.printStackTrace((Throwable)ex);
                    this.updateState(Task.State.ERROR);
                } else {
                    this.updateState(Task.State.COMPLETED);
                }
            });
        }
    }

    private static final class DeleteActionPerformer
    extends EMSensitiveAction {
        DeleteActionPerformer(RootEditor editor, ExplorerManager explorer) {
            super(Bundle.LBL_DeleteAction(), editor, explorer);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(() -> this.actionPerformed(e));
                return;
            }
            ContainerProxy container = this.findSharedContainer();
            List<String> children = this.selection().stream().map(ComponentProxy::getID).toList();
            if (container == null || children.isEmpty()) {
                return;
            }
            Task.run((Task)ActionSupport.createDeleteTask(this.editor(), container, children, List.of())).exceptionally(this::handleException);
        }

        @Override
        void refresh() {
            this.setEnabled(!this.selection().isEmpty() && this.findSharedContainer() != null);
        }
    }

    private static class DeleteTask
    extends AbstractTask {
        private final ContainerProxy container;
        private final List<String> children;
        private final List<Connection> connections;

        DeleteTask(ContainerProxy container, List<String> children, List<Connection> connections) {
            this.container = container;
            this.children = children;
            this.connections = connections;
        }

        protected void handleExecute() throws Exception {
            if (!this.checkDeletion()) {
                this.updateState(Task.State.CANCELLED);
                return;
            }
            Stream.concat(this.connections.stream().map(arg_0 -> ((ContainerProxy)this.container).disconnect(arg_0)), this.children.stream().map(arg_0 -> ((ContainerProxy)this.container).removeChild(arg_0))).reduce(CompletableFuture.completedStage(null), (s1, s2) -> s1.thenCombine(s2, (r1, r2) -> null)).whenComplete((r, ex) -> {
                if (ex != null) {
                    Exceptions.printStackTrace((Throwable)ex);
                    this.updateState(Task.State.ERROR);
                } else {
                    this.updateState(Task.State.COMPLETED);
                }
            });
        }

        private boolean checkDeletion() {
            if (this.children.isEmpty()) {
                return true;
            }
            int count = this.children.size();
            String msg = count > 1 ? Bundle.LBL_DeleteTaskMultiple(count) : Bundle.LBL_DeleteTaskSingle(this.children.get(0));
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, Bundle.TTL_DeleteTask(), 0);
            return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd));
        }
    }

    private static final class DuplicateActionPerformer
    extends EMSensitiveAction {
        DuplicateActionPerformer(RootEditor editor, ExplorerManager explorer) {
            super(Bundle.LBL_DuplicateAction(), editor, explorer);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RootEditor ed = this.editor();
            ContainerProxy container = this.findSharedContainer();
            List<String> children = this.selection().stream().map(ComponentProxy::getID).toList();
            if (container == null || children.isEmpty()) {
                return;
            }
            Task.run((Task)ActionSupport.createCopyTask(ed, container, children)).thenCompose(v -> Task.run(ActionSupport.createPasteTask(ed, container))).exceptionally(this::handleException);
        }

        @Override
        void refresh() {
            this.setEnabled(!this.selection().isEmpty() && this.findSharedContainer() != null);
        }
    }

    private static final class ExportActionPerformer
    extends EMSensitiveAction {
        ExportActionPerformer(RootEditor editor, ExplorerManager explorer) {
            super(Bundle.LBL_ExportAction(), editor, explorer);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContainerProxy container = this.findSharedContainer();
            List<String> children = this.selection().stream().map(ComponentProxy::getID).toList();
            if (container == null || children.isEmpty()) {
                return;
            }
            Task.run((Task)ActionSupport.createExportTask(this.editor(), container, children)).exceptionally(this::handleException);
        }

        @Override
        void refresh() {
            this.setEnabled(!this.selection().isEmpty() && this.findSharedContainer() != null);
        }
    }

    private static final class PasteActionPerformer
    extends EMSensitiveAction {
        PasteActionPerformer(RootEditor editor, ExplorerManager explorer) {
            super(Bundle.LBL_PasteAction(), editor, explorer);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContainerProxy container = this.context();
            Task.WithResult.compute(ActionSupport.createPasteTask(this.editor(), container)).thenAccept(ids -> this.selectChildren(container, (List<String>)ids)).exceptionally(this::handleException);
        }

        @Override
        void refresh() {
            this.setEnabled(this.context() != null);
        }

        private void selectChildren(ContainerProxy container, List<String> children) {
        }
    }

    private static class PasteTask
    extends AbstractTask.WithResult<List<String>> {
        private final ContainerProxy container;
        private final ModelTransform.Paste pasteTransform;
        private List<String> log;

        PasteTask(ContainerProxy container, ModelTransform.Paste pasteTransform) {
            this.container = container;
            this.pasteTransform = pasteTransform == null ? m -> m : pasteTransform;
            this.log = List.of();
        }

        protected void handleExecute() throws Exception {
            Clipboard clipboard = ActionBridge.getClipboard();
            PXRRootProxy root = ActionBridge.findRootProxy(this.container);
            PXRHelper helper = root.getHelper();
            URI projectDir = root.getProject().getProjectDirectory().toURI();
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                String script = (String)clipboard.getData(DataFlavor.stringFlavor);
                if (script.strip().isEmpty()) {
                    this.updateState(Task.State.COMPLETED);
                    return;
                }
                GraphModel model = GraphModel.parseSubgraph((URI)projectDir, (String)script);
                if ((model = ImportRenameSupport.prepareForPaste(this.container, model)) == null) {
                    this.updateState(Task.State.CANCELLED);
                    return;
                }
                model = (GraphModel)this.pasteTransform.apply(model);
                List children = model.root().children().keySet().stream().toList();
                helper.safeContextEval(projectDir, this.container.getAddress(), model.writeToString()).whenComplete((r, ex) -> {
                    if (ex != null) {
                        this.log = ActionBridge.handleException(ex);
                        this.updateState(Task.State.ERROR);
                    } else {
                        this.complete(children);
                    }
                });
            } else {
                this.updateState(Task.State.ERROR);
            }
        }

        public List<String> log() {
            return this.log;
        }
    }

    private static class ExportTask
    extends AbstractTask {
        private final ContainerProxy container;
        private final List<String> children;
        private final ModelTransform.Export exportTransform;

        ExportTask(ContainerProxy container, List<String> children, ModelTransform.Export exportTransform) {
            this.container = container;
            this.children = children;
            this.exportTransform = exportTransform == null ? m -> m : exportTransform;
        }

        protected void handleExecute() throws Exception {
            CompletionStage<GraphModel> modelStage;
            PXRHelper helper = ActionBridge.findRootProxy(this.container).getHelper();
            if (this.children.size() == 1) {
                String childID = this.children.iterator().next();
                modelStage = helper.componentData(ComponentAddress.of((ComponentAddress)this.container.getAddress(), (String)childID)).thenApply(data -> GraphModel.fromSerializedComponent((String)childID, (PMap)data));
            } else {
                modelStage = helper.componentData(this.container.getAddress()).thenApply(data -> GraphModel.fromSerializedSubgraph((PMap)data, this.children::contains));
            }
            modelStage.thenApply(this.exportTransform).thenAccept(model -> this.handleSave(model.writeToString())).exceptionally(ex -> {
                this.updateState(Task.State.ERROR);
                return null;
            });
        }

        private void handleSave(String export) {
            PXGExportWizard wizard = new PXGExportWizard();
            try {
                GraphElement.Root root = GraphModel.parseSubgraph((String)export).root();
                wizard.setSuggestedFileName(this.findSuggestedName(root));
                wizard.setSuggestedPaletteCategory(this.findPaletteCategory(root));
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
            if (wizard.display() != WizardDescriptor.FINISH_OPTION) {
                this.updateState(Task.State.CANCELLED);
                return;
            }
            File file = wizard.getExportFile();
            String paletteCategory = wizard.getPaletteCategory().replace(":", "_");
            RP.post(() -> {
                if (file.exists()) {
                    EventQueue.invokeLater(() -> {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"File already exists.", 0));
                        this.updateState(Task.State.ERROR);
                    });
                } else {
                    try {
                        Files.writeString(file.toPath(), (CharSequence)export, StandardOpenOption.CREATE_NEW);
                        FileUtil.toFileObject((File)file.getParentFile()).refresh();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        EventQueue.invokeLater(() -> this.updateState(Task.State.ERROR));
                        return;
                    }
                    try {
                        if (!paletteCategory.isEmpty()) {
                            FileObject src = FileUtil.toFileObject((File)file);
                            FileObject dst = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)("PXR/Palette/" + paletteCategory));
                            FileUtil.copyFile((FileObject)src, (FileObject)dst, (String)src.getName());
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        EventQueue.invokeLater(() -> this.updateState(Task.State.ERROR));
                        return;
                    }
                    EventQueue.invokeLater(() -> this.updateState(Task.State.COMPLETED));
                }
            });
        }

        private String findSuggestedName(GraphElement.Root root) {
            if (root.children().size() == 1) {
                return (String)root.children().firstEntry().getKey();
            }
            return "";
        }

        private String findPaletteCategory(GraphElement.Root root) {
            Object ret = "core:custom";
            for (GraphElement.Component cmp : root.children().sequencedValues()) {
                if (!cmp.children().isEmpty()) {
                    return "";
                }
                String type = cmp.type().toString();
                if (type.startsWith("video:gl:")) {
                    return "video:gl:custom";
                }
                if (type.startsWith("core")) continue;
                String base = type.substring(0, type.indexOf(":"));
                ret = base + ":custom";
            }
            return ret;
        }
    }

    private static class ImportTask
    extends AbstractTask {
        private final ContainerProxy container;
        private final FileObject file;
        private final ModelTransform.Import importTransform;
        private List<String> log;

        ImportTask(ContainerProxy container, FileObject file, ModelTransform.Import importTransform) {
            this.container = container;
            this.file = file;
            this.importTransform = importTransform == null ? m -> m : importTransform;
            this.log = List.of();
        }

        protected void handleExecute() throws Exception {
            PXRRootProxy root = ActionBridge.findRootProxy(this.container);
            PXRHelper helper = root.getHelper();
            URI projectDir = root.getProject().getProjectDirectory().toURI();
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                try {
                    return this.file.asText();
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }, (Executor)RP).thenComposeAsync(script -> {
                try {
                    GraphModel model = GraphModel.parseSubgraph((URI)projectDir, (String)script);
                    model = ImportRenameSupport.prepareForImport(this.container, model);
                    if (model == null) {
                        this.updateState(Task.State.CANCELLED);
                        return CompletableFuture.completedStage(null);
                    }
                    model = (GraphModel)this.importTransform.apply(model);
                    return helper.safeContextEval(projectDir, this.container.getAddress(), model.writeToString());
                }
                catch (ParseException pex) {
                    throw new RuntimeException(pex);
                }
            }, EventQueue::invokeLater)).whenCompleteAsync((r, ex) -> {
                if (ex != null) {
                    this.log = ActionBridge.handleException(ex);
                    this.updateState(Task.State.ERROR);
                } else if (this.getState() == Task.State.RUNNING) {
                    this.updateState(Task.State.COMPLETED);
                }
            }, EventQueue::invokeLater);
        }

        public List<String> log() {
            return this.log;
        }
    }

    private static abstract class EMSensitiveAction
    extends AbstractAction
    implements Disposable {
        private final RootEditor editor;
        private final ExplorerManager explorer;
        private final PropertyChangeListener baseListener;
        private final PropertyChangeListener emListener;
        private ContainerProxy container;
        private List<ComponentProxy> selection;

        EMSensitiveAction(String name, RootEditor editor, ExplorerManager explorer) {
            super(name);
            this.editor = Objects.requireNonNull(editor);
            this.explorer = Objects.requireNonNull(explorer);
            this.baseListener = this::propertyChange;
            this.emListener = WeakListeners.propertyChange((PropertyChangeListener)this.baseListener, (Object)explorer);
            this.explorer.addPropertyChangeListener(this.emListener);
            this.propertyChange(null);
        }

        final ContainerProxy context() {
            return this.container;
        }

        final List<ComponentProxy> selection() {
            return this.selection;
        }

        final ContainerProxy findSharedContainer() {
            if (this.selection.isEmpty()) {
                return null;
            }
            ContainerProxy container = this.selection.get(0).getParent();
            if (container == null) {
                return null;
            }
            for (int i = 1; i < this.selection.size(); ++i) {
                ContainerProxy parent = this.selection.get(i).getParent();
                if (parent != null && parent == container) continue;
                return null;
            }
            return container;
        }

        final RootEditor editor() {
            return this.editor;
        }

        final ExplorerManager explorer() {
            return this.explorer;
        }

        final Void handleException(Throwable t) {
            CompletionException ex;
            if (!(t instanceof CancellationException || t instanceof CompletionException && (ex = (CompletionException)t).getCause() instanceof CancellationException)) {
                Exceptions.printStackTrace((Throwable)t);
            }
            return null;
        }

        void refresh() {
        }

        public void dispose() {
            this.explorer.removePropertyChangeListener(this.emListener);
            this.container = null;
            this.selection = List.of();
        }

        private void propertyChange(PropertyChangeEvent ev) {
            Node contextNode = this.explorer.getExploredContext();
            Node[] selectedNodes = this.explorer.getSelectedNodes();
            this.container = (ContainerProxy)contextNode.getLookup().lookup(ContainerProxy.class);
            this.selection = Stream.of(selectedNodes).map(n -> (ComponentProxy)n.getLookup().lookup(ComponentProxy.class)).filter(c -> c != null).toList();
            this.refresh();
        }
    }
}

