/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.actions.Openable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PString;
import org.praxislive.ide.code.api.ClassBodyWrapper;
import org.praxislive.ide.core.api.Callback;
import org.praxislive.ide.model.HubProxy;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.BoundArgumentProperty;
import org.praxislive.ide.pxr.BoundCodeResetPanel;
import org.praxislive.ide.pxr.BoundSharedCodeProperty;
import org.praxislive.ide.pxr.Bundle;

class BoundCodeProperty
extends BoundArgumentProperty {
    static final String KEY_LAST_SAVED = "last-saved";
    private static final Map<String, String> mimeToExt = new HashMap<String, String>();
    private static final String PXJ_MIME = "text/x-praxis-java";
    private final PraxisProject project;
    private final String mimeType;
    private final String template;
    private final FileListener fileListener;
    private final String fileName;
    private final Action editAction;
    private final Action resetAction;
    private final Action quickEditAction;
    private final SharedBaseAction sharedBaseAction;
    private FileObject file;
    private static final Pattern EXTENDS_STATEMENT_PATTERN;
    private static final String SHARED_PREFIX = "SHARED.";

    BoundCodeProperty(PraxisProject project, ControlAddress address, ControlInfo info, String mimeType) {
        super(project, address, info);
        this.project = project;
        this.mimeType = mimeType;
        this.template = ((ArgumentInfo)info.outputs().get(0)).properties().getString("template", "");
        this.fileListener = new FileListener();
        this.fileName = this.safeFileName(address);
        String id = address.controlID();
        this.editAction = new EditAction(id);
        this.resetAction = new ResetAction(id);
        this.quickEditAction = new QuickEditAction(id);
        this.setHidden(true);
        if (PXJ_MIME.equals(mimeType)) {
            this.sharedBaseAction = new SharedBaseAction((ArgumentInfo)info.outputs().get(0));
            this.addPropertyChangeListener(this.sharedBaseAction);
        } else {
            this.sharedBaseAction = null;
        }
    }

    private String safeFileName(ControlAddress address) {
        Object name = address.component().componentID() + "_" + address.controlID();
        name = ((String)name).replace('-', '_');
        return name;
    }

    @Override
    public void restoreDefaultValue() {
        super.restoreDefaultValue();
        this.deleteFile();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.deleteFile();
    }

    Action getEditAction() {
        return this.editAction;
    }

    Action getResetAction() {
        return this.resetAction;
    }

    Action getQuickEditAction() {
        return this.quickEditAction;
    }

    Action getSharedBaseAction() {
        return this.sharedBaseAction;
    }

    private void openEditor() {
        try {
            DataObject dob;
            Openable openable;
            if (this.file == null) {
                this.file = this.constructFile();
            }
            if ((openable = (Openable)(dob = DataObject.find((FileObject)this.file)).getLookup().lookup(Openable.class)) != null) {
                openable.open();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject constructFile() throws Exception {
        FileSystem fs = FileUtil.createMemoryFileSystem();
        String ext = this.findExtension(this.mimeType);
        FileObject f = ext != null ? fs.getRoot().createData(this.fileName, ext) : fs.getRoot().createData(this.fileName);
        try (OutputStreamWriter writer = null;){
            writer = new OutputStreamWriter(f.getOutputStream());
            writer.append(this.constructFileContent());
        }
        f.setAttribute("project", (Object)this.project);
        f.setAttribute("controlAddress", (Object)this.getAddress());
        f.setAttribute("argumentInfo", this.getInfo().outputs().get(0));
        f.addFileChangeListener((FileChangeListener)this.fileListener);
        return f;
    }

    private String findExtension(String mimeType) {
        if (mimeToExt.containsKey(mimeType)) {
            return mimeToExt.get(mimeType);
        }
        List exts = FileUtil.getMIMETypeExtensions((String)mimeType);
        String ext = null;
        if (exts.size() > 0) {
            ext = (String)exts.get(0);
        }
        mimeToExt.put(mimeType, ext);
        return ext;
    }

    private String constructFileContent() {
        Object lastSaved;
        String content = this.getValue().toString();
        if (content.isBlank() && (lastSaved = this.getValue(KEY_LAST_SAVED)) instanceof Value) {
            content = lastSaved.toString();
        }
        if (content.isBlank()) {
            content = this.template;
        }
        return content;
    }

    private void updateFromFile() {
        if (this.file != null) {
            try {
                this.setValue((Value)PString.of((String)this.file.asText()));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void deleteFile() {
        if (this.file == null) {
            return;
        }
        try {
            this.file.delete();
            this.file = null;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private BoundSharedCodeProperty findSharedCodeProperty() {
        try {
            HubProxy hub = (HubProxy)this.project.getLookup().lookup(HubProxy.class);
            RootProxy root = hub.getRoot(this.getAddress().component().rootID());
            PraxisProperty property = root.getProperty("shared-code");
            if (property instanceof BoundSharedCodeProperty) {
                return (BoundSharedCodeProperty)property;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    static {
        mimeToExt.put(PXJ_MIME, "pxj");
        mimeToExt.put("text/x-praxis-script", "pxs");
        mimeToExt.put("text/x-glsl-frag", "frag");
        mimeToExt.put("text/x-glsl-vert", "vert");
        EXTENDS_STATEMENT_PATTERN = Pattern.compile("\\s*extends\\s+(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.\\*)?);");
    }

    class FileListener
    extends FileChangeAdapter {
        FileListener() {
        }

        public void fileChanged(final FileEvent fe) {
            if (EventQueue.isDispatchThread()) {
                if (fe.getFile() == BoundCodeProperty.this.file) {
                    BoundCodeProperty.this.updateFromFile();
                } else {
                    fe.getFile().removeFileChangeListener((FileChangeListener)this);
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileListener.this.fileChanged(fe);
                    }
                });
            }
        }
    }

    class EditAction
    extends AbstractAction {
        private EditAction(String id) {
            super(Bundle.EditCodeLabel(id));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BoundCodeProperty.this.openEditor();
        }
    }

    class ResetAction
    extends AbstractAction {
        private ResetAction(String id) {
            super(Bundle.ResetCodeLabel(id));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object last = BoundCodeProperty.this.getValue(BoundCodeProperty.KEY_LAST_SAVED);
            BoundCodeResetPanel panel = new BoundCodeResetPanel(last instanceof Value);
            DialogDescriptor dialog = new DialogDescriptor((Object)panel, BoundCodeProperty.this.getName());
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialog) == NotifyDescriptor.OK_OPTION) {
                if (panel.isLastSavedOption()) {
                    BoundCodeProperty.this.setValue((Value)last);
                    BoundCodeProperty.this.deleteFile();
                } else {
                    BoundCodeProperty.this.restoreDefaultValue();
                    if (last != null) {
                        BoundCodeProperty.this.setValue(BoundCodeProperty.KEY_LAST_SAVED, PString.EMPTY);
                    }
                }
            }
        }
    }

    class QuickEditAction
    extends AbstractAction {
        private QuickEditAction(String id) {
            super(Bundle.EditCodeLabel(id));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BoundCodeProperty.this.sharedBaseAction != null && BoundCodeProperty.this.sharedBaseAction.openSharedBase()) {
                return;
            }
            BoundCodeProperty.this.editAction.actionPerformed(e);
        }
    }

    class SharedBaseAction
    extends AbstractAction
    implements PropertyChangeListener {
        private final String primaryBaseClass;
        private final List<String> primaryBaseImports;
        private boolean hasSharedBase;

        private SharedBaseAction(ArgumentInfo info) {
            super(Bundle.CreateSharedBaseLabel());
            this.primaryBaseClass = Optional.ofNullable(info.properties().get("base-class")).map(Value::toString).orElse("java.lang.Object");
            List baseImports = Optional.ofNullable(info.properties().get("base-imports")).flatMap(PArray::from).orElse(PArray.EMPTY).stream().map(Value::toString).collect(Collectors.toList());
            this.primaryBaseImports = List.copyOf(baseImports);
            this.hasSharedBase = false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.hasSharedBase) {
                this.openSharedBase();
            } else {
                this.createSharedBase();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.checkForBase();
        }

        private void checkForBase() {
            String code = BoundCodeProperty.this.getValue().toString();
            this.hasSharedBase = !code.isBlank() && code.lines().allMatch(line -> line.isBlank() || EXTENDS_STATEMENT_PATTERN.matcher((CharSequence)line).lookingAt() && line.contains(BoundCodeProperty.SHARED_PREFIX));
            this.putValue("Name", this.hasSharedBase ? Bundle.EditSharedBaseLabel() : Bundle.CreateSharedBaseLabel());
        }

        private void createSharedBase() {
            try {
                BoundSharedCodeProperty shared = BoundCodeProperty.this.findSharedCodeProperty();
                PMap sharedCode = (PMap)PMap.from((Value)shared.getValue()).orElseThrow();
                NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(Bundle.SharedBaseClassLabel(), Bundle.CreateSharedBaseLabel());
                String defaultBaseName = this.calculateBaseName();
                if (!sharedCode.keys().contains(BoundCodeProperty.SHARED_PREFIX + defaultBaseName)) {
                    input.setInputText(this.calculateBaseName());
                }
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) == NotifyDescriptor.OK_OPTION) {
                    String baseName = input.getInputText().strip();
                    String baseSource = ClassBodyWrapper.create().className(BoundCodeProperty.SHARED_PREFIX + baseName).extendsType(this.primaryBaseClass).defaultImports(this.primaryBaseImports).wrap(BoundCodeProperty.this.constructFileContent());
                    PMap updatedSharedCode = PMap.merge((PMap)sharedCode, (PMap)PMap.of((String)(BoundCodeProperty.SHARED_PREFIX + baseName), (Object)baseSource), (BinaryOperator)PMap.REPLACE);
                    shared.setValue((Value)updatedSharedCode, Callback.create(result -> {
                        if (result.isError()) {
                            this.notifyError(baseName);
                        } else {
                            BoundCodeProperty.this.deleteFile();
                            BoundCodeProperty.this.setValue((Value)PString.of((String)("extends SHARED." + baseName + ";")), Callback.create(result2 -> {
                                if (result2.isError()) {
                                    this.notifyError(baseName);
                                } else {
                                    shared.openFile(BoundCodeProperty.SHARED_PREFIX + baseName);
                                }
                            }));
                        }
                    }));
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private boolean openSharedBase() {
            if (this.hasSharedBase) {
                BoundSharedCodeProperty shared = BoundCodeProperty.this.findSharedCodeProperty();
                String code = BoundCodeProperty.this.getValue().toString();
                String sharedBaseType = code.lines().map(line -> {
                    String superClass;
                    Matcher m = EXTENDS_STATEMENT_PATTERN.matcher((CharSequence)line);
                    if (m.lookingAt() && (superClass = m.group(1)).startsWith(BoundCodeProperty.SHARED_PREFIX)) {
                        return superClass;
                    }
                    return "";
                }).filter(s -> !s.isBlank()).findFirst().orElse(null);
                if (sharedBaseType != null) {
                    shared.openFile(sharedBaseType);
                    return true;
                }
            }
            return false;
        }

        private String calculateBaseName() {
            String componentID = BoundCodeProperty.this.getAddress().component().componentID();
            StringBuilder sb = new StringBuilder();
            boolean capitalize = true;
            for (int i = 0; i < componentID.length(); ++i) {
                char c = componentID.charAt(i);
                if (i > 0 && Character.isJavaIdentifierPart(c) || Character.isJavaIdentifierStart(c)) {
                    sb.append(capitalize ? Character.toUpperCase(c) : c);
                    capitalize = false;
                    continue;
                }
                capitalize = true;
            }
            return sb.toString();
        }

        private void notifyError(String baseName) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.SharedBaseClassError(baseName), 0));
        }
    }
}

