/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.DelegatingArgumentEditor;

class DelegatingArgumentCustomEditor
extends JPanel {
    private DelegatingArgumentEditor delegateEditor;
    private PropertyEnv env;
    private PraxisProperty.Editor[] allEditors;
    private PraxisProperty.Editor currentEditor;
    private JComboBox<String> chooser;
    private JLabel chooserLabel;
    private JPanel editors;

    DelegatingArgumentCustomEditor(DelegatingArgumentEditor delegateEditor, PropertyEnv env) {
        this.delegateEditor = delegateEditor;
        this.env = env;
        this.initComponents();
        this.allEditors = delegateEditor.getAllEditors();
        this.currentEditor = delegateEditor.getCurrentEditor();
        this.installEditors();
        this.installListeners();
    }

    private void initComponents() {
        this.chooserLabel = new JLabel();
        this.chooser = new JComboBox();
        this.editors = new JPanel();
        this.chooserLabel.setLabelFor(this.chooser);
        this.chooserLabel.setText(NbBundle.getMessage(DelegatingArgumentCustomEditor.class, (String)"DelegatingArgumentCustomEditor.chooserLabel.text"));
        this.editors.setBorder(BorderFactory.createEtchedBorder());
        this.editors.setLayout(new CardLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(246, Short.MAX_VALUE).addComponent(this.chooserLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooser, -2, -1, -2).addContainerGap()).addComponent(this.editors, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chooser, -2, -1, -2).addComponent(this.chooserLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editors, -1, 255, Short.MAX_VALUE)));
    }

    private void installEditors() {
        Object value = this.delegateEditor.getValue();
        for (int i = 0; i < this.allEditors.length; ++i) {
            PraxisProperty.Editor ed = this.allEditors[i];
            if (ed != this.currentEditor) {
                try {
                    ed.setValue(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ed instanceof ExPropertyEditor) {
                    ((ExPropertyEditor)ed).attachEnv(this.env);
                }
            }
            Component custEd = null;
            if (ed.supportsCustomEditor()) {
                custEd = ed.getCustomEditor();
            }
            if (custEd == null || custEd instanceof Window) {
                custEd = new JPanel();
            }
            this.editors.add(custEd, "" + i);
            this.chooser.addItem(ed.getClass().getSimpleName());
            if (ed != this.currentEditor) continue;
            this.chooser.setSelectedIndex(i);
        }
        this.setupCurrentEditor();
    }

    private void setupCurrentEditor() {
        int selected = this.chooser.getSelectedIndex();
        PraxisProperty.Editor ed = this.allEditors[selected];
        CardLayout cards = (CardLayout)this.editors.getLayout();
        cards.show(this.editors, "" + selected);
        if (ed != this.currentEditor) {
            this.delegateEditor.setCurrentEditor(ed);
            this.currentEditor = ed;
        }
    }

    private void installListeners() {
        this.chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DelegatingArgumentCustomEditor.this.setupCurrentEditor();
            }
        });
        this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        this.env.addPropertyChangeListener(new PropertyChangeListener(this){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!"state".equals(evt.getPropertyName()) || evt.getNewValue() == PropertyEnv.STATE_VALID) {
                    // empty if block
                }
            }
        });
    }
}

