/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.filechooser.FileSystemView;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.PXGExportWizardPanel1;

public final class PXGExportWizard {
    static final String KEY_FILE = "file";
    static final String KEY_PALETTE_CATEGORY = "palette-category";
    private String suggestedFileName = "";
    private String suggestedPaletteCategory = "";
    private File exportFile;
    private String paletteCategory;

    public void setSuggestedFileName(String suggestedFileName) {
        this.suggestedFileName = Objects.requireNonNull(suggestedFileName);
    }

    public String getSuggestedFileName() {
        return this.suggestedFileName;
    }

    public void setSuggestedPaletteCategory(String paletteCategory) {
        this.suggestedPaletteCategory = Objects.requireNonNull(paletteCategory);
    }

    public String getSuggestedPaletteCategory() {
        return this.suggestedPaletteCategory;
    }

    public Object display() {
        ArrayList<PXGExportWizardPanel1> panels = new ArrayList<PXGExportWizardPanel1>();
        panels.add(new PXGExportWizardPanel1(this));
        String[] steps = new String[panels.size()];
        for (int i = 0; i < panels.size(); ++i) {
            Component c = ((WizardDescriptor.Panel)panels.get(i)).getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", true);
            jc.putClientProperty("WizardPanel_contentDisplayed", true);
            jc.putClientProperty("WizardPanel_contentNumbered", true);
        }
        WizardDescriptor wiz = new WizardDescriptor((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(panels));
        wiz.setTitleFormat(new MessageFormat("{0}"));
        wiz.setTitle(Bundle.PXGExportWizard_title());
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)wiz);
        if (ret == WizardDescriptor.FINISH_OPTION) {
            this.exportFile = (File)wiz.getProperty(KEY_FILE);
            this.paletteCategory = (String)wiz.getProperty(KEY_PALETTE_CATEGORY);
        } else {
            this.exportFile = null;
            this.paletteCategory = null;
        }
        return ret;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public String getPaletteCategory() {
        return this.paletteCategory;
    }

    File getDefaultLocation() {
        File location = FileSystemView.getFileSystemView().getDefaultDirectory();
        if (location != null) {
            try {
                String[] path;
                for (String dir : path = Bundle.PXGExportWizard_defaultLocation().split("/")) {
                    File d = new File(location, dir);
                    if (d.exists()) {
                        if (!d.isDirectory() || !d.canWrite()) break;
                        location = d;
                        continue;
                    }
                    if (!d.mkdir()) break;
                    location = d;
                }
                return location;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return FileUtil.normalizeFile((File)new File(System.getProperty("user.home")));
    }
}

