/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.openide.util.Lookup;
import org.praxislive.core.Component;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Connection;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.PortAddress;
import org.praxislive.core.Value;
import org.praxislive.core.types.PMap;
import org.praxislive.ide.core.api.AbstractHelperComponent;
import org.praxislive.ide.core.spi.ExtensionProvider;

public class PXRHelper
extends AbstractHelperComponent {
    private static final String ALLOWED_COMMANDS = "[array @ ~ file array map cd libraries]";
    private static final String EVAL_COMMAND = "eval --trap-errors --allowed-commands [array @ ~ file array map cd libraries] ";
    private static final String ROOT_SCRIPT = "eval --trap-errors --allowed-commands [array @ ~ file array map cd libraries] {\ncd %1$s\n%2$s\n}\n";
    private static final String SUB_SCRIPT = "eval --trap-errors --allowed-commands [array @ ~ file array map cd libraries] {\ncd %1$s\n@ %2$s {\n%3$s\n}\n}\n";

    private PXRHelper() {
    }

    CompletionStage<List<Value>> safeEval(URI workingDir, String script) {
        return this.execScript(ROOT_SCRIPT.formatted(workingDir, script));
    }

    CompletionStage<List<Value>> safeContextEval(URI workingDir, ComponentAddress address, String script) {
        return this.execScript(SUB_SCRIPT.formatted(workingDir, address, script));
    }

    CompletionStage<ComponentInfo> createComponentAndGetInfo(ComponentAddress address, ComponentType type) {
        return this.execScript("@ " + String.valueOf(address) + " " + String.valueOf(type) + " { .info }").thenApply(result -> {
            assert (EventQueue.isDispatchThread());
            return (ComponentInfo)ComponentInfo.from((Value)((Value)result.get(0))).orElseThrow();
        });
    }

    CompletionStage<ComponentAddress> createComponent(ComponentAddress address, ComponentType type) {
        return this.execScript("@ " + String.valueOf(address) + " " + String.valueOf(type)).thenApply(result -> address);
    }

    CompletionStage<PMap> componentData(ComponentAddress address) {
        String script = address.depth() == 1 ? String.valueOf(address) + ".serialize" : "/" + address.rootID() + ".serialize [map subtree " + String.valueOf(address) + "]";
        return this.execScript(script).thenApply(r -> (PMap)PMap.from((Value)((Value)r.get(0))).orElseThrow());
    }

    CompletionStage<ComponentInfo> componentInfo(ComponentAddress address) {
        return this.send(ControlAddress.of((ComponentAddress)address, (String)"info"), List.of()).thenApply(res -> (ComponentInfo)ComponentInfo.from((Value)((Value)res.get(0))).orElseThrow());
    }

    CompletionStage<?> removeComponent(ComponentAddress address) {
        return this.execScript("!@ " + String.valueOf(address));
    }

    CompletionStage<Connection> connect(ComponentAddress container, Connection connection) {
        return this.connectionImpl(container, connection, true);
    }

    CompletionStage<Connection> disconnect(ComponentAddress container, Connection connection) {
        return this.connectionImpl(container, connection, false);
    }

    private CompletionStage<Connection> connectionImpl(ComponentAddress container, Connection connection, boolean connect) {
        PortAddress source = PortAddress.of((ComponentAddress)ComponentAddress.of((ComponentAddress)container, (String)connection.sourceComponent()), (String)connection.sourcePort());
        PortAddress target = PortAddress.of((ComponentAddress)ComponentAddress.of((ComponentAddress)container, (String)connection.targetComponent()), (String)connection.targetPort());
        String script = connect ? "~ " + String.valueOf(source) + " " + String.valueOf(target) : "!~ " + String.valueOf(source) + " " + String.valueOf(target);
        return this.execScript(script).thenApply(v -> {
            assert (EventQueue.isDispatchThread());
            return connection;
        });
    }

    public static class Provider
    implements ExtensionProvider {
        public Optional<Component> createExtension(Lookup context) {
            return Optional.of(new PXRHelper());
        }
    }
}

