/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Watch;
import org.praxislive.core.types.PBoolean;
import org.praxislive.ide.components.api.Components;
import org.praxislive.ide.components.api.Icons;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.ActionPropertyWrapper;
import org.praxislive.ide.pxr.BooleanPropertyWrapper;
import org.praxislive.ide.pxr.BoundArgumentProperty;
import org.praxislive.ide.pxr.FunctionPropertyWrapper;
import org.praxislive.ide.pxr.PXRComponentProxy;
import org.praxislive.ide.pxr.PXRContainerProxy;

class PXRProxyNode
extends AbstractNode {
    private final PXRComponentProxy component;
    private final Action preferredAction;
    private Action[] actions;
    private Image icon;
    boolean ignore;

    PXRProxyNode(PXRComponentProxy component) {
        this(component, (Children)(component instanceof PXRContainerProxy ? new ContainerChildren((PXRContainerProxy)component) : Children.LEAF), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)component), component.getLookup()}));
    }

    private PXRProxyNode(PXRComponentProxy component, Children children, Lookup lookup) {
        super(children, lookup);
        this.component = component;
        this.preferredAction = new PreferredAction();
        this.setName(component.getAddress().componentID());
        this.refreshProperties();
        this.refreshActions();
    }

    final void refreshProperties() {
        this.setSheet(this.createSheetOnEQ());
    }

    final void refreshActions() {
        List<Action> prop;
        ArrayList<Action> lst = new ArrayList<Action>();
        lst.add(this.component.getEditorAction());
        List<Action> triggers = this.component.getTriggerActions();
        if (!triggers.isEmpty()) {
            lst.add(null);
            lst.addAll(triggers);
        }
        if (!(prop = this.component.getPropertyActions()).isEmpty()) {
            lst.add(null);
            lst.addAll(prop);
        }
        this.actions = lst.toArray(new Action[lst.size()]);
    }

    final void refreshChildren() {
        Children chs = this.getChildren();
        assert (chs instanceof ContainerChildren);
        if (chs instanceof ContainerChildren) {
            ((ContainerChildren)chs).update();
        }
    }

    public String getDisplayName() {
        return this.getName();
    }

    public Action[] getActions(boolean context) {
        return (Action[])this.actions.clone();
    }

    public Action getPreferredAction() {
        return this.preferredAction;
    }

    public boolean canDestroy() {
        return this.canDestroyImpl();
    }

    private boolean canDestroyImpl() {
        return this.component.getParent() != null;
    }

    public void destroy() throws IOException {
        if (EventQueue.isDispatchThread()) {
            this.destroyImpl();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PXRProxyNode.this.destroyImpl();
                }
            });
        }
    }

    private void destroyImpl() {
        assert (EventQueue.isDispatchThread());
        PXRContainerProxy container = this.component.getParent();
        container.removeChild(container.getChildID(this.component));
    }

    public Image getIcon(int type) {
        if (this.icon == null) {
            Components cmps = (Components)this.component.getRoot().getProject().getLookup().lookup(Components.class);
            this.icon = cmps != null ? cmps.getIcon(this.component.getType()) : Icons.getIcon((ComponentType)this.component.getType());
        }
        return this.icon;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    private Sheet createSheetOnEQ() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set props = Sheet.createPropertiesSet();
        sheet.put(props);
        for (PraxisProperty<?> proxyProp : this.component.getProxyProperties()) {
            proxyProp.setHidden(true);
            props.put(proxyProp);
        }
        for (FunctionPropertyWrapper input : this.inputControls()) {
            props.put((Node.Property)input);
        }
        for (Action action : this.component.getTriggerActions()) {
            props.put((Node.Property)new ActionPropertyWrapper(action));
        }
        for (Iterator<Object> iterator : this.component.getPropertyIDs()) {
            BoundArgumentProperty bap;
            Object prop = this.component.getProperty((String)((Object)iterator));
            if (prop.canWrite() && prop instanceof BoundArgumentProperty && (bap = prop).getArgumentType() == PBoolean.class) {
                prop = new BooleanPropertyWrapper(bap);
            }
            props.put((Node.Property)prop);
        }
        for (FunctionPropertyWrapper function : this.functionControls()) {
            props.put((Node.Property)function);
        }
        return sheet;
    }

    private List<FunctionPropertyWrapper> inputControls() {
        ComponentInfo info = this.component.getInfo();
        ArrayList<FunctionPropertyWrapper> inputs = new ArrayList<FunctionPropertyWrapper>();
        for (String id : info.controls()) {
            ControlInfo ci = info.controlInfo(id);
            if (ci.controlType() != ControlInfo.Type.Function || !ci.properties().getString("input-port", "").equals(id)) continue;
            inputs.add(new FunctionPropertyWrapper(this, id, ci));
        }
        return inputs;
    }

    private List<FunctionPropertyWrapper> functionControls() {
        ComponentInfo info = this.component.getInfo();
        ArrayList<FunctionPropertyWrapper> functions = new ArrayList<FunctionPropertyWrapper>();
        for (String id : info.controls()) {
            ControlInfo ci = info.controlInfo(id);
            if (ci.controlType() != ControlInfo.Type.Function || Watch.isWatch((ControlInfo)ci) || ci.properties().get("input-port") != null || this.component.isHiddenFunction(id)) continue;
            functions.add(new FunctionPropertyWrapper(this, id, ci));
        }
        return functions;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.component.getType().toString());
    }

    PXRComponentProxy component() {
        return this.component;
    }

    void propertyChange(String property, Object oldValue, Object newValue) {
        this.firePropertyChange(property, oldValue, newValue);
    }

    static class ContainerChildren
    extends Children.Keys<String> {
        final PXRContainerProxy container;

        private ContainerChildren(PXRContainerProxy container) {
            this.container = container;
            this.update();
        }

        protected Node[] createNodes(String key) {
            PXRComponentProxy component = this.container.getChild(key);
            if (component != null) {
                return new Node[]{component.getNodeDelegate()};
            }
            return new Node[0];
        }

        private void update() {
            this.setKeys((String[])this.container.children().toArray(String[]::new));
        }
    }

    private class PreferredAction
    extends AbstractAction {
        private PreferredAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Action codeAction;
            if ((e.getModifiers() & 1) != 0 && (codeAction = PXRProxyNode.this.component.getCodeEditAction()) != null) {
                codeAction.actionPerformed(e);
                return;
            }
            PXRProxyNode.this.component.getEditorAction().actionPerformed(e);
        }
    }
}

