/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.io.File;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.praxislive.base.Binding;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.protocols.StartableProtocol;
import org.praxislive.ide.code.api.SharedCodeInfo;
import org.praxislive.ide.core.api.Disposable;
import org.praxislive.ide.core.api.ValuePropertyAdaptor;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.pxr.BoundArgumentProperty;
import org.praxislive.ide.pxr.BoundSharedCodeProperty;
import org.praxislive.ide.pxr.PXRContainerProxy;
import org.praxislive.ide.pxr.PXRDataObject;
import org.praxislive.ide.pxr.PXRHelper;
import org.praxislive.ide.pxr.PXRRootRegistry;

public class PXRRootProxy
extends PXRContainerProxy
implements RootProxy,
Disposable {
    private final ComponentAddress address;
    private final PXRDataObject source;
    private final PraxisProject project;
    private final PXRHelper helper;
    private final ValuePropertyAdaptor.ReadOnly runningAdaptor;

    PXRRootProxy(PraxisProject project, PXRHelper helper, PXRDataObject source, String id, ComponentType type, ComponentInfo info) {
        super(null, type, info);
        this.address = ComponentAddress.of((String)("/" + id));
        this.source = source;
        this.project = project;
        this.helper = helper;
        if (info.hasProtocol(StartableProtocol.class)) {
            this.runningAdaptor = new ValuePropertyAdaptor.ReadOnly((Object)this, "is-running", true, Binding.SyncRate.Low);
            helper.bind(ControlAddress.of((ComponentAddress)this.address, (String)"is-running"), (Binding.Adaptor)this.runningAdaptor);
        } else {
            this.runningAdaptor = null;
        }
    }

    @Override
    public ComponentAddress getAddress() {
        return this.address;
    }

    public FileObject getSourceFile() {
        return this.source.getPrimaryFile();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.runningAdaptor != null) {
            this.helper.unbind(ControlAddress.of((ComponentAddress)this.address, (String)"is-running"), (Binding.Adaptor)this.runningAdaptor);
        }
        PXRRootRegistry reg = (PXRRootRegistry)this.project.getLookup().lookup(PXRRootRegistry.class);
        assert (reg != null);
        if (reg != null) {
            reg.remove(this);
        }
    }

    @Override
    PXRRootProxy getRoot() {
        return this;
    }

    PXRDataObject getSource() {
        return this.source;
    }

    PraxisProject getProject() {
        return this.project;
    }

    PXRHelper getHelper() {
        return this.helper;
    }

    File getWorkingDirectory() {
        if (this.project == null) {
            return FileUtil.toFile((FileObject)this.source.getPrimaryFile().getParent());
        }
        return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
    }

    @Override
    Lookup createLookup() {
        BoundArgumentProperty property = this.getProperty("shared-code");
        if (property instanceof BoundSharedCodeProperty) {
            SharedCodeInfo sharedInfo = ((BoundSharedCodeProperty)property).getSharedCodeInfo();
            return new ProxyLookup(new Lookup[]{Lookups.singleton((Object)sharedInfo), super.createLookup()});
        }
        return super.createLookup();
    }

    @Override
    boolean isHiddenFunction(String id) {
        return switch (id) {
            case "serialize" -> true;
            default -> super.isHiddenFunction(id);
        };
    }

    @Override
    protected BoundArgumentProperty createPropertyForControl(ControlAddress address, ControlInfo info) {
        List args;
        if ("shared-code".equals(address.controlID()) && info.controlType() == ControlInfo.Type.Property && (args = info.outputs()).size() == 1 && "Map".equals(((ArgumentInfo)args.get(0)).argumentType())) {
            return new BoundSharedCodeProperty(this.getProject(), address, info);
        }
        return super.createPropertyForControl(address, info);
    }
}

