/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.praxislive.ide.core.api.Task;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.project.spi.RootLifecycleHandler;
import org.praxislive.ide.pxr.PXRRootProxy;
import org.praxislive.ide.pxr.PXRRootRegistry;
import org.praxislive.ide.pxr.SaveTask;

public class RootLifecycleHandlerImpl
implements RootLifecycleHandler {
    private final PraxisProject project;

    public RootLifecycleHandlerImpl(Lookup lookup) {
        this.project = Objects.requireNonNull((PraxisProject)lookup.lookup(PraxisProject.class));
    }

    public Optional<Task> getDeletionTask(String description, Set<String> rootIDs) {
        PXRRootRegistry reg = (PXRRootRegistry)this.project.getLookup().lookup(PXRRootRegistry.class);
        if (reg == null) {
            return Optional.empty();
        }
        Set roots = rootIDs.stream().map(rootID -> reg.getRootByID((String)rootID)).filter(root -> root != null).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!roots.isEmpty()) {
            return Optional.of(new DeletionSaveTask(description, roots));
        }
        return Optional.empty();
    }

    private static class DeletionSaveTask
    implements Task,
    PropertyChangeListener {
        private Set<PXRRootProxy> roots;
        private Task.State state;
        private PropertyChangeSupport pcs;
        private SaveTask delegate;
        private String description;

        private DeletionSaveTask(String description, Set<PXRRootProxy> roots) {
            this.description = description;
            this.roots = roots;
            this.state = Task.State.NEW;
            this.pcs = new PropertyChangeSupport(this);
        }

        public Task.State execute() {
            if (this.state != Task.State.NEW) {
                throw new IllegalStateException();
            }
            this.updateState(Task.State.RUNNING);
            this.roots.forEach(r -> r.send("stop", List.of()));
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)this.buildDialogMessage(), this.description);
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (ret == NotifyDescriptor.YES_OPTION) {
                LinkedHashSet dobs = this.roots.stream().map(PXRRootProxy::getSource).collect(Collectors.toCollection(LinkedHashSet::new));
                this.delegate = SaveTask.createSaveTask(dobs);
                this.delegate.addPropertyChangeListener(this);
                return this.delegate.execute();
            }
            if (ret == NotifyDescriptor.NO_OPTION) {
                this.updateState(Task.State.COMPLETED);
                return this.state;
            }
            this.updateState(Task.State.CANCELLED);
            return this.state;
        }

        private String buildDialogMessage() {
            return this.roots.stream().map(r -> r.getSource().getName()).collect(Collectors.joining(" /", "Save changes to /", "?"));
        }

        private void updateState(Task.State state) {
            Task.State old = this.state;
            this.state = state;
            this.pcs.firePropertyChange("state", old, state);
        }

        public Task.State getState() {
            return this.state;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        public boolean cancel() {
            if (this.delegate != null) {
                return this.delegate.cancel();
            }
            return false;
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (this.delegate.getState() != this.state) {
                this.updateState(this.delegate.getState());
            }
        }
    }
}

