/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.concurrent.Executor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.praxislive.ide.core.api.Task;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.PXRDataObject;
import org.praxislive.ide.pxr.PXRRootProxy;
import org.praxislive.ide.pxr.PXRRootRegistry;
import org.praxislive.ide.pxr.SaveTask;

public final class SaveAsTemplateAction
implements ActionListener {
    private static final String TEMPLATES_PATH = "Templates/Roots";
    private static final RequestProcessor RP = new RequestProcessor();
    private final PXRDataObject rootDOB;

    public SaveAsTemplateAction(PXRDataObject context) {
        this.rootDOB = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        NotifyDescriptor.InputLine dlg = new NotifyDescriptor.InputLine(Bundle.LBL_TemplateName(), Bundle.TTL_TemplateName());
        dlg.setInputText(this.rootDOB.getPrimaryFile().getName());
        Object retval = DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg);
        if (retval == NotifyDescriptor.OK_OPTION) {
            String templateName = dlg.getInputText().strip();
            PXRRootProxy active = PXRRootRegistry.findRootForFile(this.rootDOB.getPrimaryFile());
            if (active != null) {
                Task.run((Task)SaveTask.createSaveTask(Set.of(this.rootDOB))).thenRunAsync(() -> this.copyTemplate(templateName), (Executor)RP);
            } else {
                RP.execute(() -> this.copyTemplate(templateName));
            }
        }
    }

    private void copyTemplate(String name) {
        try {
            FileObject templateFolder = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)TEMPLATES_PATH);
            if (templateFolder.getFileObject(name + ".pxr") != null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_TemplateExists(), 0));
                return;
            }
            FileObject template = FileUtil.copyFile((FileObject)this.rootDOB.getPrimaryFile(), (FileObject)templateFolder, (String)name);
            template.setAttribute("template", (Object)true);
            template.setAttribute("displayName", (Object)name);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

