/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.praxislive.core.types.PMap;
import org.praxislive.ide.core.api.AbstractTask;
import org.praxislive.ide.core.api.Task;
import org.praxislive.ide.pxr.PXRDataObject;
import org.praxislive.ide.pxr.PXRRootProxy;
import org.praxislive.ide.pxr.PXRRootRegistry;
import org.praxislive.project.GraphModel;

abstract class SaveTask
extends AbstractTask {
    private static final RequestProcessor RP = new RequestProcessor();
    private static final Logger LOG = Logger.getLogger(SaveTask.class.getName());
    private static final Map<PXRDataObject, Single> activeTasks = new HashMap<PXRDataObject, Single>();

    SaveTask() {
    }

    static SaveTask createSaveTask(Set<PXRDataObject> dobs) {
        if (dobs == null || dobs.isEmpty()) {
            return null;
        }
        if (dobs.size() == 1) {
            PXRDataObject dob = dobs.iterator().next();
            Single active = activeTasks.get((Object)dob);
            if (active != null) {
                return new Compound(Collections.singleton(dob));
            }
            return new Single(dob);
        }
        return new Compound(new HashSet<PXRDataObject>(dobs));
    }

    private static class Single
    extends SaveTask {
        private final PXRDataObject dob;
        private PXRRootProxy root;
        private ProgressHandle ph;

        private Single(PXRDataObject dob) {
            this.dob = dob;
        }

        public void handleExecute() {
            this.dob.preSave();
            this.root = PXRRootRegistry.findRootForFile(this.dob.getPrimaryFile());
            activeTasks.put(this.dob, this);
            this.ph = ProgressHandle.createHandle((String)("Saving " + String.valueOf(this.root.getAddress())), (Cancellable)this);
            this.ph.setInitialDelay(0);
            this.ph.start();
            this.ph.progress("Syncing.");
            this.root.getHelper().componentData(this.root.getAddress()).thenApply(this::toFileContent).thenAcceptAsync(this::saveToFile, (Executor)RP).whenCompleteAsync((res, ex) -> {
                assert (EventQueue.isDispatchThread());
                if (ex != null) {
                    Exceptions.printStackTrace((Throwable)ex);
                    this.updateState(Task.State.ERROR);
                } else {
                    this.updateState(Task.State.COMPLETED);
                }
                activeTasks.remove((Object)this.dob);
                this.ph.finish();
            }, EventQueue::invokeLater);
        }

        private String toFileContent(PMap data) {
            return GraphModel.fromSerializedRoot((String)this.root.getAddress().rootID(), (PMap)data).withContext(this.dob.getPrimaryFile().getParent().toURI()).writeToString();
        }

        private void saveToFile(String content) {
            try {
                Files.writeString(FileUtil.toPath((FileObject)this.dob.getPrimaryFile()), (CharSequence)content, new OpenOption[0]);
            }
            catch (IOException ioex) {
                throw new UncheckedIOException(ioex);
            }
        }
    }

    private static class Compound
    extends SaveTask
    implements PropertyChangeListener {
        private final Set<Single> childTasks;
        private final Set<PXRDataObject> dobs;

        private Compound(Set<PXRDataObject> dobs) {
            this.dobs = dobs;
            this.childTasks = new HashSet<Single>(dobs.size());
        }

        public void handleExecute() {
            this.dobs.forEach(this::initChildTask);
        }

        private void initChildTask(PXRDataObject dob) {
            Single child = activeTasks.get((Object)dob);
            if (child == null) {
                child = new Single(dob);
            }
            this.childTasks.add(child);
            child.addPropertyChangeListener(this);
            if (child.getState() != Task.State.RUNNING) {
                child.execute();
            }
        }

        public boolean handleCancel() {
            for (Single child : this.childTasks) {
                child.cancel();
            }
            return true;
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            Single task = (Single)((Object)pce.getSource());
            if (this.getState() != Task.State.RUNNING) {
                task.removePropertyChangeListener(this);
                return;
            }
            switch (task.getState()) {
                case ERROR: 
                case CANCELLED: {
                    this.childTasks.clear();
                    this.updateState(task.getState());
                    break;
                }
                case COMPLETED: {
                    this.childTasks.remove((Object)task);
                    if (!this.childTasks.isEmpty()) break;
                    this.updateState(Task.State.COMPLETED);
                    break;
                }
            }
        }
    }
}

