/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JToggleButton;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.protocols.StartableProtocol;
import org.praxislive.core.types.PBoolean;
import org.praxislive.ide.core.api.HubUnavailableException;
import org.praxislive.ide.pxr.ActionEditorContext;
import org.praxislive.ide.pxr.BoundArgumentProperty;
import org.praxislive.ide.pxr.PXRRootProxy;

public class StartableRootAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Toolbar {
    public static final String ID = "org.praxislive.ide.pxr.StartableRootAction";
    private static final String RESOURCE_DIR = "org/praxislive/ide/pxr/resources/";
    private final PropertyChangeListener baseListener;
    private final Lookup.Result<ActionEditorContext> result;
    private PXRRootProxy root;
    private PropertyChangeListener rootListener;
    private JToggleButton button;

    public StartableRootAction() {
        this(Utilities.actionsGlobalContext());
    }

    private StartableRootAction(Lookup context) {
        super("", ImageUtilities.loadImageIcon((String)"org/praxislive/ide/pxr/resources/play.png", (boolean)true));
        this.result = context.lookupResult(ActionEditorContext.class);
        this.result.addLookupListener(this::resultChanged);
        this.baseListener = this::propertyChange;
        this.putValue("SwingSelectedKey", Boolean.FALSE);
        this.setEnabled(false);
        this.resultChanged(null);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            ControlAddress to = this.getValue("SwingSelectedKey") == Boolean.TRUE ? ControlAddress.of((ComponentAddress)this.root.getAddress(), (String)"start") : ControlAddress.of((ComponentAddress)this.root.getAddress(), (String)"stop");
            this.root.getHelper().send(to, List.of(), null);
        }
        catch (HubUnavailableException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new StartableRootAction(actionContext);
    }

    public Component getToolbarPresenter() {
        if (this.button == null) {
            this.button = new JToggleButton(this);
        }
        return this.button;
    }

    private void resultChanged(LookupEvent ev) {
        Collection roots;
        if (this.root != null) {
            this.reset();
        }
        if ((roots = this.result.allInstances()).isEmpty()) {
            return;
        }
        this.setup(((ActionEditorContext)roots.iterator().next()).root());
    }

    private void propertyChange(PropertyChangeEvent pce) {
        String prop = pce.getPropertyName();
        if (prop == null || "is-running".equals(prop)) {
            this.update();
        }
    }

    private void update() {
        PBoolean active = Optional.ofNullable(this.root).map(r -> r.getProperty("is-running")).map(BoundArgumentProperty::getValue).flatMap(PBoolean::from).orElse(PBoolean.FALSE);
        this.putValue("SwingSelectedKey", active.value());
    }

    private void reset() {
        this.putValue("SwingSelectedKey", Boolean.FALSE);
        this.setEnabled(false);
        if (this.root != null) {
            if (this.rootListener != null) {
                this.root.removePropertyChangeListener(this.rootListener);
            }
            this.root = null;
            this.rootListener = null;
        }
    }

    private void setup(PXRRootProxy root) {
        this.root = root;
        if (!this.isStartable(root)) {
            return;
        }
        this.setEnabled(true);
        this.update();
        this.rootListener = WeakListeners.propertyChange((PropertyChangeListener)this.baseListener, (Object)root);
        root.addPropertyChangeListener(this.rootListener);
    }

    private boolean isStartable(PXRRootProxy root) {
        return root.getInfo().hasProtocol(StartableProtocol.class);
    }
}

