/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PString;
import org.praxislive.project.GraphElement;
import org.praxislive.project.GraphModel;

public class SubgraphDataObject
extends MultiDataObject {
    public static final String KEY_ATTR_TYPES = "componentTypes";
    private static final RequestProcessor RP = new RequestProcessor();
    private final RequiredTypes requiredTypes;

    public SubgraphDataObject(FileObject file, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(file, loader);
        this.requiredTypes = this.initTypes(file);
    }

    public Lookup getLookup() {
        return new ProxyLookup(new Lookup[]{super.getLookup(), Lookups.singleton((Object)this.requiredTypes)});
    }

    protected int associateLookup() {
        return 1;
    }

    private RequiredTypes initTypes(FileObject file) {
        Object attr = file.getAttribute(KEY_ATTR_TYPES);
        if (attr instanceof String) {
            String str = (String)attr;
            try {
                return PArray.from((Value)PString.of((String)str)).map(a -> a.asListOf(ComponentType.class)).map(RequiredTypes::new).orElseThrow();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        RP.execute(() -> {
            try {
                String script = file.asText();
                GraphModel model = GraphModel.parseSubgraph((URI)file.getParent().toURI(), (String)script);
                LinkedHashSet<ComponentType> types = new LinkedHashSet<ComponentType>();
                this.extractUniqueTypes((GraphElement.Component)model.root(), types);
                PArray typeArray = PArray.of(types);
                file.setAttribute(KEY_ATTR_TYPES, (Object)typeArray.toString());
                List typeList = typeArray.asListOf(ComponentType.class);
                EventQueue.invokeLater(() -> this.requiredTypes.updateTypes(typeList));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                try {
                    file.setAttribute(KEY_ATTR_TYPES, (Object)PArray.EMPTY.toString());
                }
                catch (IOException ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                }
            }
        });
        return new RequiredTypes(List.of());
    }

    private void extractUniqueTypes(GraphElement.Component component, Set<ComponentType> types) {
        component.children().values().forEach(child -> {
            types.add(child.type());
            this.extractUniqueTypes((GraphElement.Component)child, types);
        });
    }

    public static final class RequiredTypes {
        private List<ComponentType> types;

        private RequiredTypes(List<ComponentType> types) {
            this.types = List.copyOf(types);
        }

        private void updateTypes(List<ComponentType> types) {
            this.types = List.copyOf(types);
        }

        public List<ComponentType> requiredTypes() {
            return this.types;
        }
    }
}

