/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.api;

import java.util.Optional;
import org.praxislive.core.Value;
import org.praxislive.core.types.PString;
import org.praxislive.ide.model.ComponentProxy;

public interface Attributes {
    public void setAttribute(String var1, String var2);

    public String getAttribute(String var1);

    default public void setAttributeValue(String key, Value value) {
        if (value == null || value.isEmpty()) {
            this.setAttribute(key, null);
        } else {
            this.setAttribute(key, value.toString());
        }
    }

    default public <T extends Value> T getAttributeValue(Class<T> type, String key) {
        String attr = this.getAttribute(key);
        if (attr == null) {
            return null;
        }
        if (type == PString.class || type == Value.class) {
            return (T)((Value)type.cast(PString.of((String)attr)));
        }
        return (T)((Value)((Optional)Value.Type.of(type).converter().apply(PString.of((String)attr))).orElse(null));
    }

    public static void clear(ComponentProxy cmp, String key) {
        Attributes attrs = (Attributes)cmp.getLookup().lookup(Attributes.class);
        if (attrs == null) {
            return;
        }
        attrs.setAttribute(key, null);
    }

    public static String get(ComponentProxy cmp, String key, String def) {
        Attributes attrs = (Attributes)cmp.getLookup().lookup(Attributes.class);
        if (attrs == null) {
            return def;
        }
        String ret = attrs.getAttribute(key);
        return ret == null ? def : ret;
    }

    public static <T extends Value> T get(ComponentProxy cmp, Class<T> type, String key, T def) {
        Attributes attrs = (Attributes)cmp.getLookup().lookup(Attributes.class);
        if (attrs == null) {
            return def;
        }
        T ret = attrs.getAttributeValue(type, key);
        return ret == null ? def : ret;
    }

    public static void set(ComponentProxy cmp, String key, String value) {
        Attributes attrs = (Attributes)cmp.getLookup().lookup(Attributes.class);
        if (attrs == null) {
            return;
        }
        attrs.setAttribute(key, value);
    }

    public static void set(ComponentProxy cmp, String key, Value value) {
        Attributes attrs = (Attributes)cmp.getLookup().lookup(Attributes.class);
        if (attrs == null) {
            return;
        }
        attrs.setAttributeValue(key, value);
    }
}

