/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;
import org.praxislive.core.Value;
import org.praxislive.core.types.PMap;
import org.praxislive.ide.pxr.editors.MapTable;

class MapCustomEditor
extends JPanel
implements PropertyChangeListener {
    private final PropertyEditor editor;
    private final PropertyEnv env;
    boolean ignore;
    private JTable mapTable;
    private JScrollPane scrollPane;
    private JLabel sizeLabel;
    private JSpinner sizeSpinner;

    MapCustomEditor(PropertyEditor editor, PropertyEnv env) {
        this.editor = editor;
        this.env = env;
        this.initComponents();
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
        this.populateTable();
        this.tableSizeChanged();
        this.mapTable.getModel().addTableModelListener(e -> {
            if (e.getType() != 0) {
                this.tableSizeChanged();
            }
        });
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.mapTable = new MapTable();
        this.sizeLabel = new JLabel();
        this.sizeSpinner = new JSpinner();
        this.mapTable.setSelectionMode(1);
        this.scrollPane.setViewportView(this.mapTable);
        this.sizeLabel.setText(NbBundle.getMessage(MapCustomEditor.class, (String)"MapCustomEditor.sizeLabel.text"));
        this.sizeSpinner.setModel(new SpinnerNumberModel(0, 0, 512, 1));
        this.sizeSpinner.setName("");
        this.sizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MapCustomEditor.this.sizeSpinnerStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 400, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.sizeLabel).addGap(6, 6, 6).addComponent(this.sizeSpinner, -2, 60, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scrollPane, -2, 275, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeLabel).addComponent(this.sizeSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void sizeSpinnerStateChanged(ChangeEvent evt) {
        if (this.ignore) {
            return;
        }
        this.ignore = true;
        DefaultTableModel model = (DefaultTableModel)this.mapTable.getModel();
        model.setRowCount((Integer)this.sizeSpinner.getValue());
        this.ignore = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.setFromTable();
        }
    }

    private void tableSizeChanged() {
        if (this.ignore) {
            return;
        }
        this.ignore = true;
        this.sizeSpinner.setValue(this.mapTable.getRowCount());
        this.ignore = false;
    }

    private void setFromTable() {
        int count = this.mapTable.getRowCount();
        PMap.Builder mapBuilder = PMap.builder();
        for (int i = 0; i < count; ++i) {
            String ks;
            Object k = this.mapTable.getValueAt(i, 0);
            String string = ks = k == null ? "" : k.toString();
            if (ks.isEmpty()) continue;
            Object v = this.mapTable.getValueAt(i, 1);
            String vs = v == null ? "" : v.toString();
            mapBuilder.put(ks, vs);
        }
        this.editor.setValue(mapBuilder.build());
    }

    private void populateTable() {
        DefaultTableModel model = (DefaultTableModel)this.mapTable.getModel();
        model.setRowCount(0);
        PMap map = PMap.from((Value)((Value)this.editor.getValue())).orElse(PMap.EMPTY);
        for (String key : map.keys()) {
            model.addRow(new Object[]{key, map.getString(key, "")});
        }
    }
}

