/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URI;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.view.ContextTreeView;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.praxislive.core.types.PResource;
import org.praxislive.core.types.PString;
import org.praxislive.ide.pxr.editors.ResourceEditor;

class ResourceCustomEditor
extends JPanel
implements ExplorerManager.Provider {
    private static final Logger LOG = Logger.getLogger(ResourceCustomEditor.class.getName());
    private final Listener listener;
    private final ExplorerManager em;
    private FileObject rootDir;
    private URI current;
    private final PropertyEnv env;
    private boolean ignoreChanges;
    private final ResourceEditor editor;
    private JButton browseButton;
    private JButton clearButton;
    private JScrollPane contextView;
    private JScrollPane fileView;
    private JToolBar jToolBar1;
    private JTextField uriField;

    ResourceCustomEditor(ResourceEditor editor, FileObject workingDir, URI current, PropertyEnv env) {
        this.initComponents();
        this.current = current;
        this.env = env;
        this.editor = editor;
        this.em = new ExplorerManager();
        if (workingDir != null) {
            FileObject root = workingDir.getFileObject("resources");
            if (root == null) {
                root = workingDir;
            }
            try {
                this.em.setRootContext((Node)new FileNode(DataObject.find((FileObject)root).getNodeDelegate()));
                this.rootDir = root;
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (current != null) {
            this.uriField.setText(current.toString());
            this.syncEM();
        }
        this.listener = new Listener();
        env.addVetoableChangeListener((VetoableChangeListener)this.listener);
        this.uriField.getDocument().addDocumentListener(this.listener);
        this.em.addPropertyChangeListener((PropertyChangeListener)this.listener);
        this.initContextView((ContextTreeView)this.contextView);
        this.initFileListView((ListView)this.fileView);
    }

    private void initContextView(ContextTreeView view) {
        view.setDefaultActionAllowed(false);
    }

    private void initFileListView(ListView view) {
        view.setPopupAllowed(false);
        view.setSelectionMode(0);
    }

    private void syncEM() {
        try {
            if (this.current != null && "file".equals(this.current.getScheme()) && this.rootDir != null) {
                FileObject fob = FileUtil.toFileObject((File)Utilities.toFile((URI)this.current));
                if (fob != null && FileUtil.isParentOf((FileObject)this.rootDir, (FileObject)fob)) {
                    Node sel = null;
                    Node root = this.em.getRootContext();
                    String relPath = FileUtil.getRelativePath((FileObject)this.rootDir, (FileObject)fob);
                    String[] path = relPath.split("/");
                    path[path.length - 1] = fob.getName();
                    sel = this.findNode(root, path);
                    if (sel == null) {
                        path[path.length - 1] = fob.getNameExt();
                        sel = this.findNode(root, path);
                    }
                    if (sel != null) {
                        this.em.setExploredContextAndSelection(sel.getParentNode(), new Node[]{sel});
                    }
                }
            } else {
                this.em.setExploredContext(this.em.getRootContext(), new Node[0]);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Node findNode(Node start, String[] path) {
        Node node = null;
        try {
            node = NodeOp.findPath((Node)start, (String[])path);
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            // empty catch block
        }
        return node;
    }

    private void initComponents() {
        this.uriField = new JTextField();
        this.contextView = new ContextTreeView();
        this.fileView = new ListView();
        this.jToolBar1 = new JToolBar();
        this.clearButton = new JButton();
        this.browseButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.uriField.setText(NbBundle.getMessage(ResourceCustomEditor.class, (String)"ResourceCustomEditor.uriField.text"));
        this.jToolBar1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/org/praxislive/ide/pxr/resources/clear.png")));
        this.clearButton.setText(NbBundle.getMessage(ResourceCustomEditor.class, (String)"ResourceCustomEditor.clearButton.text"));
        this.clearButton.setFocusable(false);
        this.clearButton.setHorizontalTextPosition(0);
        this.clearButton.setVerticalTextPosition(3);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResourceCustomEditor.this.clearButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.clearButton);
        this.browseButton.setIcon(new ImageIcon(this.getClass().getResource("/org/praxislive/ide/pxr/resources/open.png")));
        this.browseButton.setText(NbBundle.getMessage(ResourceCustomEditor.class, (String)"ResourceCustomEditor.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResourceCustomEditor.this.browseButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.browseButton);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.contextView, -1, 195, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fileView, -1, 192, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.uriField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar1, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.uriField, -2, -1, -2).addComponent(this.jToolBar1, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contextView, -1, 241, Short.MAX_VALUE).addComponent(this.fileView)).addContainerGap()));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File loc = null;
        if (this.current != null && "file".equals(this.current.getScheme())) {
            try {
                loc = Utilities.toFile((URI)this.current);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (loc == null && this.rootDir != null) {
            try {
                loc = FileUtil.toFile((FileObject)this.rootDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FileChooserBuilder dlgBld = new FileChooserBuilder(ResourceCustomEditor.class);
        if (loc != null) {
            dlgBld.setDefaultWorkingDirectory(loc).forceUseOfDefaultWorkingDirectory(true);
        }
        dlgBld.setTitle("Choose File").setApproveText("OK").setFileHiding(true);
        File file = dlgBld.showOpenDialog();
        if (file != null) {
            this.current = file.toURI();
            this.ignoreChanges = true;
            this.uriField.setText(this.current.toString());
            this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            this.syncEM();
            this.ignoreChanges = false;
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.uriField.setText("");
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }

    private class FileNode
    extends FilterNode {
        FileNode(Node node) {
            super(node, (Children)(node.isLeaf() ? FilterNode.Children.LEAF : new FileChildren(node)));
        }

        public Action getPreferredAction() {
            if (this.getOriginal().isLeaf()) {
                return new FileAction(this);
            }
            return super.getPreferredAction();
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private class Listener
    implements VetoableChangeListener,
    DocumentListener,
    PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            if (ResourceCustomEditor.this.ignoreChanges) {
                return;
            }
            ResourceCustomEditor.this.ignoreChanges = true;
            String txt = ResourceCustomEditor.this.uriField.getText();
            if (txt.isEmpty()) {
                ResourceCustomEditor.this.current = null;
                ResourceCustomEditor.this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            } else {
                try {
                    ResourceCustomEditor.this.current = PResource.parse((String)ResourceCustomEditor.this.uriField.getText()).value();
                    ResourceCustomEditor.this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
                }
                catch (Exception ex) {
                    ResourceCustomEditor.this.env.setState(PropertyEnv.STATE_INVALID);
                }
            }
            ResourceCustomEditor.this.syncEM();
            ResourceCustomEditor.this.ignoreChanges = false;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if ("state".equals(evt.getPropertyName()) && PropertyEnv.STATE_VALID.equals(evt.getNewValue())) {
                if (ResourceCustomEditor.this.current == null) {
                    ResourceCustomEditor.this.editor.setValue(PString.EMPTY);
                } else {
                    ResourceCustomEditor.this.editor.setValue(PResource.of((URI)ResourceCustomEditor.this.current));
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Node[] nodes;
            if (ResourceCustomEditor.this.ignoreChanges) {
                return;
            }
            if ("selectedNodes".equals(evt.getPropertyName()) && (nodes = ResourceCustomEditor.this.em.getSelectedNodes()).length == 1) {
                FileObject fob = (FileObject)nodes[0].getLookup().lookup(FileObject.class);
                ResourceCustomEditor.this.current = fob.toURI();
                ResourceCustomEditor.this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
                ResourceCustomEditor.this.ignoreChanges = true;
                ResourceCustomEditor.this.uriField.setText(ResourceCustomEditor.this.current.toString());
                ResourceCustomEditor.this.ignoreChanges = false;
            }
        }
    }

    private class FileAction
    extends AbstractAction {
        private FileNode node;

        private FileAction(FileNode node) {
            super("OK");
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FileObject fob = (FileObject)this.node.getLookup().lookup(FileObject.class);
                ResourceCustomEditor.this.current = fob.toURI();
                ResourceCustomEditor.this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
                SwingUtilities.getRootPane(ResourceCustomEditor.this).getDefaultButton().doClick();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class FileChildren
    extends FilterNode.Children {
        public FileChildren(Node node) {
            super(node);
        }

        protected Node copyNode(Node node) {
            return new FileNode(node);
        }
    }
}

