/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.Value;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.syntax.Tokenizer;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PResource;
import org.praxislive.ide.properties.EditorSupport;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.properties.SyntaxUtils;
import org.praxislive.ide.pxr.editors.ResourceCustomEditor;

public class ResourceEditor
extends EditorSupport
implements PraxisProperty.SubCommandEditor,
ExPropertyEditor {
    private static final Logger LOG = Logger.getLogger(ResourceEditor.class.getName());
    private final boolean allowEmpty;
    private PropertyEnv env;
    private FileObject workingDir;

    public ResourceEditor(PraxisProperty property, ArgumentInfo info) {
        Object dir = property.getValue("workingDir");
        if (dir instanceof File) {
            this.workingDir = FileUtil.toFileObject((File)((File)dir));
        }
        PMap props = info.properties();
        this.allowEmpty = true;
    }

    public String getPraxisInitializationString() {
        URI uri = this.getURI();
        if (uri == null) {
            return "{}";
        }
        if (this.workingDir != null) {
            uri = this.workingDir.toURI().relativize(uri);
        }
        if (uri.isAbsolute()) {
            return uri.toString();
        }
        return "[file " + SyntaxUtils.escapeQuoted((String)uri.getPath()) + "]";
    }

    private URI getURI() {
        try {
            Value arg = (Value)this.getValue();
            if (arg.isEmpty()) {
                return null;
            }
            return ((PResource)PResource.from((Value)arg).orElseThrow()).value();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getDisplayName() {
        return "Resource Editor";
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public String getAsText() {
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        gfx.drawString(this.getValue().toString(), box.x, box.y + (box.height - fm.getHeight()) / 2 + fm.getAscent());
    }

    public void setFromCommand(String command) throws Exception {
        Iterator toks = new Tokenizer((CharSequence)command).iterator();
        Token cmd = (Token)toks.next();
        Token file = (Token)toks.next();
        if (cmd.getType() != Token.Type.PLAIN || !"file".equals(cmd.getText())) {
            throw new IllegalArgumentException("Not file command");
        }
        switch (file.getType()) {
            case PLAIN: 
            case QUOTED: 
            case BRACED: {
                URI path = this.workingDir.toURI().resolve(new URI(null, null, file.getText(), null));
                LOG.log(Level.FINE, "Setting path to {0}", path);
                this.setValue(PResource.of((URI)path));
                break;
            }
            default: {
                throw new IllegalArgumentException("Couldn't parse file");
            }
        }
    }

    public String[] getSupportedCommands() {
        return new String[]{"file"};
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new ResourceCustomEditor(this, this.workingDir, this.getURI(), this.env);
    }
}

