/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.palette;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.spi.dashboard.DashboardDisplayer;
import org.netbeans.spi.dashboard.DashboardWidget;
import org.netbeans.spi.dashboard.WidgetElement;
import org.openide.util.Exceptions;
import org.praxislive.ide.pxr.palette.Bundle;
import org.praxislive.ide.pxr.palette.Utils;

public class PXGWidget
implements DashboardWidget {
    private final List<WidgetElement> elements = new ArrayList<WidgetElement>();
    private final Set<DashboardDisplayer.Panel> active = new HashSet<DashboardDisplayer.Panel>();
    private State state = State.START;

    public PXGWidget() {
        this.refresh();
    }

    public String title(DashboardDisplayer.Panel panel) {
        return Bundle.TITLE_PXGWidget();
    }

    public List<WidgetElement> elements(DashboardDisplayer.Panel panel) {
        return List.copyOf(this.elements);
    }

    public void showing(DashboardDisplayer.Panel panel) {
        this.active.add(panel);
    }

    public void hidden(DashboardDisplayer.Panel panel) {
        this.active.remove(panel);
    }

    private void refresh() {
        this.elements.clear();
        this.elements.add((WidgetElement)WidgetElement.text((String)Bundle.TXT_PXGWidget()));
        switch (this.state.ordinal()) {
            case 0: {
                if (!Utils.isInstalled()) {
                    this.elements.add((WidgetElement)WidgetElement.action((Action)new InstallAction()));
                    break;
                }
                if (!Utils.isLatest()) {
                    this.elements.add((WidgetElement)WidgetElement.aside((String)Bundle.TXT_UpdateAvailable()));
                    this.elements.add((WidgetElement)WidgetElement.action((Action)new InstallAction()));
                    break;
                }
                this.elements.add((WidgetElement)WidgetElement.action((Action)new InstallAction(true)));
                break;
            }
            case 1: {
                this.elements.add((WidgetElement)WidgetElement.aside((String)Bundle.TXT_Installing()));
                break;
            }
            case 2: {
                this.elements.add((WidgetElement)WidgetElement.aside((String)Bundle.TXT_Installed()));
                break;
            }
            case 3: {
                this.elements.add((WidgetElement)WidgetElement.unavailable((String)Bundle.TXT_Error()));
                this.elements.add((WidgetElement)WidgetElement.action((Action)new InstallAction()));
            }
        }
        this.active.forEach(DashboardDisplayer.Panel::refresh);
    }

    private static enum State {
        START,
        INSTALLING,
        INSTALLED,
        ERROR;

    }

    private class InstallAction
    extends AbstractAction {
        private InstallAction() {
            this(false);
        }

        private InstallAction(boolean reinstall) {
            super(reinstall ? Bundle.LBL_Reinstall() : Bundle.LBL_Install());
            this.putValue("ShortDescription", reinstall ? Bundle.STATUS_Reinstall() : Bundle.STATUS_Install());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(() -> {
                PXGWidget.this.state = State.INSTALLING;
                PXGWidget.this.refresh();
            });
            Utils.RP.post(() -> {
                try {
                    Utils.install();
                    EventQueue.invokeLater(() -> {
                        PXGWidget.this.state = State.INSTALLED;
                        PXGWidget.this.refresh();
                    });
                }
                catch (Exception ex) {
                    EventQueue.invokeLater(() -> {
                        Exceptions.printStackTrace((Throwable)ex);
                        PXGWidget.this.state = State.ERROR;
                        PXGWidget.this.refresh();
                    });
                }
            });
        }
    }
}

