/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.palette;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.praxislive.core.ComponentType;
import org.praxislive.ide.core.api.DynamicFileSystem;
import org.praxislive.ide.pxr.palette.Utils;

class PaletteFiles {
    static final String FOLDER = "PXR/Palette/";
    private static final PaletteFiles INSTANCE = new PaletteFiles();
    private final Set<ComponentType> knownTypes = new TreeSet<ComponentType>(Comparator.comparing(ComponentType::toString));
    private final FileSystem typeFileSystem = FileUtil.createMemoryFileSystem();

    private PaletteFiles() {
        try {
            FileUtil.createFolder((FileObject)this.typeFileSystem.getRoot(), (String)FOLDER);
            for (String folder : Utils.knownFolders().values()) {
                FileUtil.createFolder((FileObject)this.typeFileSystem.getRoot(), (String)(FOLDER + folder));
            }
            this.refreshCategoryOrder();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        DynamicFileSystem.getDefault().mount(this.typeFileSystem);
    }

    synchronized void addTypes(Collection<ComponentType> types) {
        if (this.knownTypes.containsAll(types)) {
            return;
        }
        TreeSet<ComponentType> toAdd = new TreeSet<ComponentType>(Comparator.comparing(ComponentType::toString));
        toAdd.addAll(types);
        toAdd.removeAll(this.knownTypes);
        try {
            this.typeFileSystem.runAtomicAction(() -> {
                toAdd.stream().forEachOrdered(this::addType);
                this.refreshCategoryOrder();
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    DataFolder paletteFolder() {
        return DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)FOLDER));
    }

    private void addType(ComponentType type) {
        try {
            String typeString = type.toString();
            String category = typeString.substring(0, typeString.lastIndexOf(":"));
            FileObject folder = this.getOrCreateCategory(category);
            FileObject typeFile = FileUtil.createData((FileObject)folder, (String)(this.safeFileName(typeString) + ".type"));
            typeFile.setAttribute("componentType", (Object)typeString);
            this.knownTypes.add(type);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private FileObject getOrCreateCategory(String category) throws IOException {
        FileObject categoryFolder = FileUtil.createFolder((FileObject)this.typeFileSystem.getRoot(), (String)(FOLDER + this.safeFileName(category)));
        categoryFolder.setAttribute("displayName", (Object)category);
        return categoryFolder;
    }

    private void refreshCategoryOrder() throws IOException {
        FileObject root = this.typeFileSystem.findResource(FOLDER);
        FileObject[] categories = root.getChildren();
        Arrays.sort(categories, Comparator.comparing(FileObject::getName, (n1, n2) -> {
            if (n1.startsWith("core")) {
                return n2.startsWith("core") ? n1.compareTo((String)n2) : -1;
            }
            return n2.startsWith("core") ? 1 : n1.compareTo((String)n2);
        }));
        FileUtil.setOrder(Arrays.asList(categories));
    }

    private String safeFileName(String fileName) {
        return fileName.replace(":", "_");
    }

    static PaletteFiles getDefault() {
        return INSTANCE;
    }
}

