/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.palette;

import java.awt.Image;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.praxislive.core.ComponentType;
import org.praxislive.ide.components.api.Icons;

public class TypeDataObject
extends MultiDataObject {
    private static final Logger LOG = Logger.getLogger(TypeDataObject.class.getName());
    static final String TYPE_ATTR_KEY = "componentType";
    private ComponentType type;

    public TypeDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        try {
            this.type = ComponentType.of((String)pf.getAttribute(TYPE_ATTR_KEY).toString());
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Invalid or non-existent ComponentType in .type file.", ex);
        }
    }

    protected DataNode createNodeDelegate() {
        return new Node();
    }

    public Lookup getLookup() {
        if (this.type == null) {
            return super.getLookup();
        }
        return new ProxyLookup(new Lookup[]{super.getLookup(), Lookups.fixed((Object[])new Object[]{this.type})});
    }

    public HelpCtx getHelpCtx() {
        if (this.type == null) {
            return super.getHelpCtx();
        }
        return new HelpCtx(this.type.toString());
    }

    protected int associateLookup() {
        return 1;
    }

    private class Node
    extends DataNode {
        Node() {
            super((DataObject)TypeDataObject.this, Children.LEAF, TypeDataObject.this.getLookup());
        }

        public Image getIcon(int size) {
            if (TypeDataObject.this.type == null) {
                return super.getIcon(size);
            }
            return Icons.getIcon((ComponentType)TypeDataObject.this.type);
        }

        public Image getOpenedIcon(int size) {
            return this.getIcon(size);
        }

        public String getDisplayName() {
            return TypeDataObject.this.type.toString();
        }
    }
}

