/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2025 Neil C Smith.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 for more details.
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with this work; if not, see http://www.gnu.org/licenses/
 *
 *
 * Please visit https://www.praxislive.org if you need additional information or
 * have any questions.
 */
package org.praxislive.ide.pxr;

import java.io.File;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

@NbBundle.Messages({
    "SaveAsTemplateVisualPanel1.name=File",
    "SaveAsTemplateVisualPanel1.fileSelect=Select"
})
final class SaveAsTemplateVisualPanel1 extends JPanel implements DocumentListener {

    private final SaveAsTemplateWizardPanel1 wizardPanel;
    private final FileChooserBuilder fileChooser;
    private FileObject location;

    SaveAsTemplateVisualPanel1(SaveAsTemplateWizardPanel1 wizardPanel) {
        this.wizardPanel = wizardPanel;
        initComponents();
        SaveAsTemplateWizard wizard = wizardPanel.getWizard();
        location = wizard.getDefaultDestination();
        fileChooser = new FileChooserBuilder(SaveAsTemplateVisualPanel1.class)
                .setDirectoriesOnly(true)
                .setApproveText(Bundle.SaveAsTemplateVisualPanel1_fileSelect());
        locationField.setText(location.getPath());
        fileField.setText(location.toString());
        nameField.setText(wizard.getSuggestedFileName());
        nameField.getDocument().addDocumentListener(this);
        if (wizard.hasLibraries()) {
            librariesCheckbox.setEnabled(true);
            librariesCheckbox.setSelected(wizard.mightUseLibraries());
        } else {
            librariesCheckbox.setEnabled(false);
            librariesCheckbox.setSelected(false);
        }
    }

    @Override
    public String getName() {
        return Bundle.SaveAsTemplateVisualPanel1_name();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        update();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        nameLabel = new javax.swing.JLabel();
        locationLabel = new javax.swing.JLabel();
        fileLabel = new javax.swing.JLabel();
        nameField = new javax.swing.JTextField();
        locationField = new javax.swing.JTextField();
        browseButton = new javax.swing.JButton();
        fileField = new javax.swing.JTextField();
        librariesCheckbox = new javax.swing.JCheckBox();

        org.openide.awt.Mnemonics.setLocalizedText(nameLabel, org.openide.util.NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, "PXGExportVisualPanel1.nameLabel.text_1")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(locationLabel, org.openide.util.NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, "PXGExportVisualPanel1.locationLabel.text_1")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(fileLabel, org.openide.util.NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, "PXGExportVisualPanel1.fileLabel.text_1")); // NOI18N

        nameField.setText(org.openide.util.NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, "PXGExportVisualPanel1.nameField.text_1")); // NOI18N

        locationField.setEditable(false);
        locationField.setText(org.openide.util.NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, "PXGExportVisualPanel1.locationField.text_1")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(browseButton, org.openide.util.NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, "PXGExportVisualPanel1.browseButton.text_1")); // NOI18N
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        fileField.setEditable(false);
        fileField.setText(org.openide.util.NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, "PXGExportVisualPanel1.fileField.text_1")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(librariesCheckbox, org.openide.util.NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, "PXGExportVisualPanel1.librariesCheckbox.text")); // NOI18N
        librariesCheckbox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                librariesCheckboxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(fileLabel)
                            .addComponent(locationLabel)
                            .addComponent(nameLabel))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(nameField)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(locationField, javax.swing.GroupLayout.DEFAULT_SIZE, 306, Short.MAX_VALUE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(browseButton))
                            .addComponent(fileField)))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(librariesCheckbox)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(nameLabel)
                    .addComponent(nameField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(locationLabel)
                    .addComponent(locationField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(browseButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(fileLabel)
                    .addComponent(fileField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(librariesCheckbox)
                .addGap(124, 124, 124))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        File loc = fileChooser.showOpenDialog();
        if (loc != null) {
            location = FileUtil.toFileObject(loc);
            locationField.setText(location.getPath());
            update();
        }
    }//GEN-LAST:event_browseButtonActionPerformed

    private void librariesCheckboxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_librariesCheckboxActionPerformed
        update();
    }//GEN-LAST:event_librariesCheckboxActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseButton;
    private javax.swing.JTextField fileField;
    private javax.swing.JLabel fileLabel;
    private javax.swing.JCheckBox librariesCheckbox;
    private javax.swing.JTextField locationField;
    private javax.swing.JLabel locationLabel;
    private javax.swing.JTextField nameField;
    private javax.swing.JLabel nameLabel;
    // End of variables declaration//GEN-END:variables

    @Override
    public void insertUpdate(DocumentEvent e) {
        update();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        update();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        update();
    }

    FileObject getDestinationFolder() {
        return location;
    }

    String getFileName() {
        return nameField.getText();
    }

    boolean includeLibraries() {
        return librariesCheckbox.isSelected();
    }

    private void update() {
        String name = nameField.getText();
        if (!name.isEmpty() && !name.endsWith(".pxx")) {
            name = name + ".pxx";
        }
        fileField.setText(locationField.getText() + File.separator + name);
        wizardPanel.validate();
    }
}
