/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.nodes.Node;
import org.praxislive.ide.properties.EditorSupport;

class ActionPropertyWrapper
extends Node.Property<String> {
    private final Action action;
    private final String id;

    ActionPropertyWrapper(Action action) {
        super(String.class);
        this.action = action;
        this.id = String.valueOf(action.getValue("Name"));
        this.setName(this.id);
    }

    public boolean canRead() {
        return true;
    }

    public String getValue() throws IllegalAccessException, InvocationTargetException {
        return "";
    }

    public boolean canWrite() {
        return true;
    }

    public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
    }

    public PropertyEditor getPropertyEditor() {
        return new Editor(this.action);
    }

    private static class Editor
    extends EditorSupport
    implements ExPropertyEditor,
    InplaceEditor.Factory {
        private final Button button;

        Editor(Action action) {
            this.button = new Button(action);
        }

        public void attachEnv(PropertyEnv env) {
            env.registerInplaceEditorFactory((InplaceEditor.Factory)this);
        }

        public InplaceEditor getInplaceEditor() {
            return this.button;
        }

        public boolean isPaintable() {
            return true;
        }

        public void paintValue(Graphics gfx, Rectangle box) {
            this.button.setSize(box.width, box.height);
            this.button.doLayout();
            Graphics g = gfx.create(box.x, box.y, box.width, box.height);
            this.button.print(g);
            g.dispose();
        }

        public void setAsText(String text) throws IllegalArgumentException {
        }
    }

    private static class Button
    extends JButton
    implements InplaceEditor {
        private PropertyEditor pe;
        private PropertyEnv env;
        private PropertyModel pm;

        private Button(Action action) {
            super(String.valueOf(action.getValue("Name")));
            this.setActionCommand("success");
            this.addActionListener(e -> action.actionPerformed(e));
        }

        public void connect(PropertyEditor pe, PropertyEnv env) {
            this.pe = pe;
            this.env = env;
            AWTEvent invokingEvent = EventQueue.getCurrentEvent();
            if (invokingEvent instanceof KeyEvent) {
                EventQueue.invokeLater(this::doClick);
            }
        }

        public JComponent getComponent() {
            return this;
        }

        public void clear() {
            this.pe = null;
            this.env = null;
        }

        public Object getValue() {
            return "";
        }

        public void setValue(Object o) {
        }

        public boolean supportsTextEntry() {
            return true;
        }

        public void reset() {
        }

        public KeyStroke[] getKeyStrokes() {
            return new KeyStroke[0];
        }

        public PropertyEditor getPropertyEditor() {
            return this.pe;
        }

        public PropertyModel getPropertyModel() {
            return this.pm;
        }

        public void setPropertyModel(PropertyModel pm) {
            this.pm = pm;
        }

        public boolean isKnownComponent(Component c) {
            return false;
        }
    }
}

