/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.base.Binding;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PString;
import org.praxislive.ide.core.api.Callback;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.DelegatingArgumentEditor;
import org.praxislive.ide.pxr.PXRHelper;
import org.praxislive.ide.pxr.SubCommandArgument;

public class BoundArgumentProperty
extends PraxisProperty<Value> {
    private static final Logger LOG = Logger.getLogger(BoundArgumentProperty.class.getName());
    private final PropertyChangeSupport pcs;
    private final PXRHelper helper;
    private final Adaptor adaptor;
    private final ControlAddress address;
    private final ControlInfo info;
    private final boolean writable;
    private final boolean isTransient;
    private final Value defaultValue;
    private DelegatingArgumentEditor editor;
    private Value value;

    BoundArgumentProperty(PraxisProject project, ControlAddress address, ControlInfo info) {
        super(Value.class);
        if (address == null || info == null) {
            throw new NullPointerException();
        }
        if (info.outputs().size() != 1) {
            throw new IllegalArgumentException("Property doesn't accept single argument");
        }
        this.address = address;
        this.info = info;
        this.writable = this.isWritable(info);
        this.defaultValue = this.getDefault(info);
        this.isTransient = this.isTransient(info);
        this.pcs = new PropertyChangeSupport((Object)this);
        this.adaptor = new Adaptor();
        this.value = this.defaultValue;
        this.helper = Objects.requireNonNull((PXRHelper)((Object)project.getLookup().lookup(PXRHelper.class)), "No helper component found");
        this.helper.bind(address, this.adaptor);
        this.setName(address.controlID());
        this.setValue("canAutoComplete", Boolean.FALSE);
        this.setValue("project", project);
    }

    private boolean isWritable(ControlInfo info) {
        return switch (info.controlType()) {
            case ControlInfo.Type.Property -> true;
            case ControlInfo.Type.ReadOnlyProperty -> false;
            default -> throw new IllegalArgumentException();
        };
    }

    private Value getDefault(ControlInfo info) {
        List defs = info.defaults();
        return defs.isEmpty() ? PString.EMPTY : (Value)defs.get(0);
    }

    private boolean isTransient(ControlInfo info) {
        return info.properties().getBoolean("transient", false);
    }

    protected PraxisProperty.Editor createEditor() {
        if (this.editor == null) {
            this.editor = new DelegatingArgumentEditor(this, this.info);
        }
        this.editor.setValue(this.value);
        return this.editor;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        if (!this.writable) {
            throw new UnsupportedOperationException("Read only property");
        }
        if (this.value.equals((Object)value)) {
            return;
        }
        this.setValueImpl(value, true, null);
    }

    public void setValue(Value value, Callback callback) {
        this.setValueImpl(value, true, callback);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return this.equivalent(this.defaultValue, this.value);
    }

    public void restoreDefaultValue() {
        if (this.editor != null) {
            this.editor.restoreDefaultEditor();
        }
        this.setValue(this.defaultValue);
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public String getHtmlDisplayName() {
        if (this.isTransient) {
            return "<i>" + this.getDisplayName() + "</i>";
        }
        return null;
    }

    public void setSyncing(boolean sync) {
        if (LOG.isLoggable(Level.FINE)) {
            if (sync) {
                LOG.log(Level.FINE, "Activating binding for : {0}", this.address);
            } else {
                LOG.log(Level.FINE, "Deactivating binding for : {0}", this.address);
            }
        }
        this.adaptor.setActive(sync);
    }

    public boolean isSyncing() {
        return this.adaptor.isActive();
    }

    public void dispose() {
        super.dispose();
        this.helper.unbind(this.address, this.adaptor);
    }

    Class<? extends Value> getArgumentType() {
        return ((Value.Type)Value.Type.fromName((String)((ArgumentInfo)this.info.outputs().get(0)).argumentType()).get()).asClass();
    }

    ControlAddress getAddress() {
        return this.address;
    }

    ControlInfo getInfo() {
        return this.info;
    }

    private void setValueImpl(Value value, boolean send, Callback callback) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof SubCommandArgument) {
            LOG.finest("Delegating to Property Editor");
            PropertyEditor ed = this.getPropertyEditor();
            ed.setValue(value);
            value = (Value)ed.getValue();
        }
        Value oldValue = this.value;
        if (send) {
            this.adaptor.sendValue(value, callback);
        }
        this.value = value;
        if (!this.equivalent(oldValue, value)) {
            this.pcs.firePropertyChange(this.address.controlID(), oldValue, value);
        }
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return this.writable;
    }

    private boolean equivalent(Value v1, Value v2) {
        return v1.equivalent(v2) || v2.equivalent(v1);
    }

    private class Adaptor
    extends Binding.Adaptor {
        private Callback callback;

        private Adaptor() {
            this.setSyncRate(Binding.SyncRate.Medium);
        }

        public void update() {
            List args;
            Value arg = null;
            Binding binding = this.getBinding();
            if (binding != null && (args = binding.getValues()).size() > 0) {
                arg = (Value)args.get(0);
            }
            if (arg != null) {
                BoundArgumentProperty.this.setValueImpl(arg, false, null);
            }
        }

        void sendValue(Value val, Callback callback) {
            this.send(List.of(val));
            if (callback != null) {
                if (this.callback != null) {
                    this.callback.onError(List.of());
                }
                this.callback = callback;
            }
        }

        public void onResponse(List<Value> args) {
            if (this.callback != null) {
                Callback cb = this.callback;
                this.callback = null;
                cb.onReturn(args);
            }
        }

        public void onError(List<Value> args) {
            if (this.callback != null) {
                Callback cb = this.callback;
                this.callback = null;
                cb.onError(args);
            }
        }

        public void updateBindingConfiguration() {
        }
    }
}

