/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openide.awt.HtmlRenderer;
import org.openide.nodes.Node;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PString;
import org.praxislive.ide.core.api.CallExecutionException;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.PXRProxyNode;

class FunctionPropertyWrapper
extends Node.Property<String> {
    private final PXRProxyNode node;
    private final String control;
    private final ControlInfo info;
    private Editor editor;
    private String lastInput;
    private String lastOutput;
    private boolean lastWasError;

    public FunctionPropertyWrapper(PXRProxyNode node, String control, ControlInfo info) {
        super(String.class);
        this.node = node;
        this.control = control;
        this.info = info;
        this.setName(control);
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new Editor();
        }
        return this.editor;
    }

    public String getValue() throws IllegalAccessException, InvocationTargetException {
        return "???";
    }

    public void setValue(String text) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        List inputs = this.info.inputs();
        List<Object> args = inputs.isEmpty() ? List.of() : (inputs.size() == 1 ? List.of(PString.of((String)text)) : ((PArray)PArray.from((Value)PString.of((String)text)).orElseThrow(IllegalArgumentException::new)).asList());
        this.lastInput = text;
        this.node.component().send(this.control, args).whenComplete(this::handleResponse);
    }

    private void handleResponse(List<Value> result, Throwable error) {
        if (error != null) {
            this.lastWasError = true;
            if (error instanceof CallExecutionException) {
                CallExecutionException cee = (CallExecutionException)error;
                this.lastOutput = cee.error().toString();
            } else {
                this.lastOutput = error.toString();
            }
        } else {
            this.lastOutput = result.isEmpty() ? "" : (result.size() == 1 ? result.get(0).toString() : PArray.of(result).toString());
            this.lastWasError = false;
        }
        this.node.propertyChange(this.control, null, null);
    }

    private class Editor
    extends PropertyEditorSupport {
        private Editor() {
        }

        @Override
        public String getAsText() {
            return FunctionPropertyWrapper.this.lastInput == null ? "" : FunctionPropertyWrapper.this.lastInput;
        }

        @Override
        public boolean isPaintable() {
            return true;
        }

        @Override
        public void paintValue(Graphics g, Rectangle r) {
            if (FunctionPropertyWrapper.this.lastOutput == null) {
                return;
            }
            String html = FunctionPropertyWrapper.this.lastWasError ? Bundle.HTML_ResultError(FunctionPropertyWrapper.this.lastOutput) : Bundle.HTML_ResultOK(FunctionPropertyWrapper.this.lastOutput);
            Font font = g.getFont();
            FontMetrics fm = g.getFontMetrics(font);
            HtmlRenderer.renderHTML((String)html, (Graphics)g, (int)r.x, (int)(r.y + (r.height - fm.getHeight()) / 2 + fm.getAscent()), (int)r.width, (int)r.height, (Font)g.getFont(), (Color)g.getColor(), (int)1, (boolean)true);
        }

        @Override
        public boolean supportsCustomEditor() {
            return FunctionPropertyWrapper.this.lastOutput != null;
        }

        @Override
        public Component getCustomEditor() {
            JTextArea textArea = new JTextArea(FunctionPropertyWrapper.this.lastOutput);
            textArea.setEditable(false);
            textArea.setColumns(40);
            textArea.setRows(20);
            JScrollPane scroll = new JScrollPane(textArea);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(scroll);
            return panel;
        }
    }
}

