/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.PXGExportWizard;
import org.praxislive.ide.pxr.PXGExportWizardPanel1;

final class PXGExportVisualPanel1
extends JPanel
implements DocumentListener {
    private final PXGExportWizardPanel1 wizardPanel;
    private final FileChooserBuilder fileChooser;
    private File location;
    private JButton browseButton;
    private JTextField fileField;
    private JLabel fileLabel;
    private JCheckBox librariesCheckbox;
    private JTextField locationField;
    private JLabel locationLabel;
    private JTextField nameField;
    private JLabel nameLabel;
    private JTextField paletteCategoryField;
    private JLabel paletteCategoryLabel;
    private JCheckBox paletteCheckbox;
    private JCheckBox sharedCodeCheckbox;

    PXGExportVisualPanel1(PXGExportWizardPanel1 wizardPanel) {
        this.wizardPanel = wizardPanel;
        this.initComponents();
        PXGExportWizard wizard = wizardPanel.getWizard();
        this.location = wizard.getDefaultLocation();
        this.fileChooser = new FileChooserBuilder(PXGExportVisualPanel1.class).setDirectoriesOnly(true).setApproveText(Bundle.PXGExportVisualPanel1_fileSelect()).setDefaultWorkingDirectory(this.location).forceUseOfDefaultWorkingDirectory(true);
        this.locationField.setText(this.location.toString());
        this.fileField.setText(this.location.toString());
        this.nameField.setText(wizard.getSuggestedFileName());
        this.paletteCategoryField.setText(wizard.getSuggestedPaletteCategory());
        this.nameField.getDocument().addDocumentListener(this);
        this.paletteCategoryField.getDocument().addDocumentListener(this);
        if (wizard.hasLibraries()) {
            this.librariesCheckbox.setEnabled(true);
            this.librariesCheckbox.setSelected(wizard.mightUseLibraries());
        } else {
            this.librariesCheckbox.setEnabled(false);
            this.librariesCheckbox.setSelected(false);
        }
        if (wizard.hasSharedCode()) {
            this.sharedCodeCheckbox.setEnabled(true);
            this.sharedCodeCheckbox.setSelected(wizard.mightUseSharedCode());
        } else {
            this.sharedCodeCheckbox.setEnabled(false);
            this.sharedCodeCheckbox.setSelected(false);
        }
    }

    @Override
    public String getName() {
        return Bundle.PXGExportVisualPanel1_name();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.update();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.locationLabel = new JLabel();
        this.fileLabel = new JLabel();
        this.nameField = new JTextField();
        this.locationField = new JTextField();
        this.browseButton = new JButton();
        this.fileField = new JTextField();
        this.paletteCategoryLabel = new JLabel();
        this.paletteCategoryField = new JTextField();
        this.paletteCheckbox = new JCheckBox();
        this.librariesCheckbox = new JCheckBox();
        this.sharedCodeCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(PXGExportVisualPanel1.class, (String)"PXGExportVisualPanel1.nameLabel.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(PXGExportVisualPanel1.class, (String)"PXGExportVisualPanel1.locationLabel.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(PXGExportVisualPanel1.class, (String)"PXGExportVisualPanel1.fileLabel.text_1"));
        this.nameField.setText(NbBundle.getMessage(PXGExportVisualPanel1.class, (String)"PXGExportVisualPanel1.nameField.text_1"));
        this.locationField.setEditable(false);
        this.locationField.setText(NbBundle.getMessage(PXGExportVisualPanel1.class, (String)"PXGExportVisualPanel1.locationField.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PXGExportVisualPanel1.class, (String)"PXGExportVisualPanel1.browseButton.text_1"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PXGExportVisualPanel1.this.browseButtonActionPerformed(evt);
            }
        });
        this.fileField.setEditable(false);
        this.fileField.setText(NbBundle.getMessage(PXGExportVisualPanel1.class, (String)"PXGExportVisualPanel1.fileField.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.paletteCategoryLabel, (String)NbBundle.getMessage(PXGExportVisualPanel1.class, (String)"PXGExportVisualPanel1.paletteCategoryLabel.text_1"));
        this.paletteCategoryField.setText(NbBundle.getMessage(PXGExportVisualPanel1.class, (String)"PXGExportVisualPanel1.paletteCategoryField.text_1"));
        this.paletteCheckbox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.paletteCheckbox, (String)NbBundle.getMessage(PXGExportVisualPanel1.class, (String)"PXGExportVisualPanel1.paletteCheckbox.text_1"));
        this.paletteCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PXGExportVisualPanel1.this.paletteCheckboxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.librariesCheckbox, (String)NbBundle.getMessage(PXGExportVisualPanel1.class, (String)"PXGExportVisualPanel1.librariesCheckbox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.sharedCodeCheckbox, (String)NbBundle.getMessage(PXGExportVisualPanel1.class, (String)"PXGExportVisualPanel1.sharedCodeCheckbox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fileLabel).addComponent(this.locationLabel).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameField).addGroup(layout.createSequentialGroup().addComponent(this.locationField, -1, 306, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addComponent(this.fileField))).addGroup(layout.createSequentialGroup().addComponent(this.paletteCategoryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paletteCategoryField)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paletteCheckbox).addComponent(this.librariesCheckbox).addComponent(this.sharedCodeCheckbox)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationLabel).addComponent(this.locationField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileField, -2, -1, -2)).addGap(26, 26, 26).addComponent(this.paletteCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.paletteCategoryLabel).addComponent(this.paletteCategoryField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.librariesCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sharedCodeCheckbox).addContainerGap()));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File loc = this.fileChooser.showOpenDialog();
        if (loc != null) {
            this.location = loc;
            this.locationField.setText(this.location.toString());
            this.update();
        }
    }

    private void paletteCheckboxActionPerformed(ActionEvent evt) {
        this.paletteCategoryField.setEnabled(this.paletteCheckbox.isSelected());
        this.update();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update();
    }

    File getFileLocation() {
        return this.location;
    }

    String getFileName() {
        return this.nameField.getText();
    }

    String getPaletteCategory() {
        return this.paletteCheckbox.isSelected() ? this.paletteCategoryField.getText() : "";
    }

    boolean includeLibraries() {
        return this.librariesCheckbox.isSelected();
    }

    boolean includeSharedCode() {
        return this.sharedCodeCheckbox.isSelected();
    }

    private void update() {
        Object name = this.nameField.getText();
        if (!((String)name).isEmpty() && !((String)name).endsWith(".pxg")) {
            name = (String)name + ".pxg";
        }
        this.fileField.setText(this.locationField.getText() + File.separator + (String)name);
        this.wizardPanel.validate();
    }
}

